/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrRemoveModifierFix;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u00022\b\b\u0001\u0010\r\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a:\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\r\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0017H\u0000\"\u001c\u0010\u0000\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006 "}, d2={"VARIABLE_MODIFIERS", "", "", "Lcom/intellij/openapi/util/NlsSafe;", "getVARIABLE_MODIFIERS", "()Ljava/util/Set;", "checkModifierIsNotAllowed", "", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "modifier", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "message", "checkVariableModifiers", "variableDeclaration", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariableDeclaration;", "registerLocalFix", "Lcom/intellij/lang/annotation/AnnotationBuilder;", "annotationBuilder", "fix", "Lcom/intellij/codeInspection/LocalQuickFix;", "place", "Lcom/intellij/psi/PsiElement;", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "range", "Lcom/intellij/openapi/util/TextRange;", "createDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Lcom/intellij/lang/annotation/Annotation;", "element", "intellij.groovy.psi"})
public final class UtilKt {
    @NotNull
    private static final Set<String> VARIABLE_MODIFIERS;

    @NotNull
    public static final Set<String> getVARIABLE_MODIFIERS() {
        return VARIABLE_MODIFIERS;
    }

    public static final void checkVariableModifiers(@NotNull AnnotationHolder holder, @NotNull GrVariableDeclaration variableDeclaration) {
        GrModifierList modifierList = variableDeclaration.getModifierList();
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if (VARIABLE_MODIFIERS.contains(modifier)) continue;
            Object[] objectArray = new Object[]{modifier};
            UtilKt.checkModifierIsNotAllowed(modifierList, modifier, GroovyBundle.message("variable.cannot.be", objectArray), holder);
        }
    }

    public static final void checkModifierIsNotAllowed(@NotNull GrModifierList modifierList, @GrModifier.GrModifierConstant @NotNull String modifier, @NotNull AnnotationHolder holder) {
        Object[] objectArray = new Object[]{modifier};
        UtilKt.checkModifierIsNotAllowed(modifierList, modifier, GroovyBundle.message("modifier.0.not.allowed", objectArray), holder);
    }

    public static final void checkModifierIsNotAllowed(@NotNull GrModifierList modifierList, @GrModifier.GrModifierConstant @NotNull String modifier, @InspectionMessage @NotNull String message, @NotNull AnnotationHolder holder) {
        PsiElement psiElement = modifierList.getModifier(modifier);
        if (psiElement == null) {
            return;
        }
        PsiElement modifierElement = psiElement;
        AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.ERROR, message).range(modifierElement);
        Object[] objectArray = new Object[]{modifier};
        GrRemoveModifierFix fix = new GrRemoveModifierFix(modifier, GroovyBundle.message("remove.modifier", objectArray));
        builder = UtilKt.registerLocalFix(builder, fix, modifierElement, message, ProblemHighlightType.ERROR, modifierElement.getTextRange());
        builder.create();
    }

    @NotNull
    public static final AnnotationBuilder registerLocalFix(@NotNull AnnotationBuilder annotationBuilder, @NotNull LocalQuickFix fix, @NotNull PsiElement place, @InspectionMessage @NotNull String message, @NotNull ProblemHighlightType problemHighlightType, @NotNull TextRange range) {
        boolean bl;
        InspectionManager manager = InspectionManager.getInstance((Project)place.getProject());
        boolean bl2 = bl = !place.getTextRange().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = place.getContainingFile().getName();
            throw new AssertionError((Object)string);
        }
        ProblemDescriptor descriptor = manager.createProblemDescriptor(place, place, message, problemHighlightType, true, new LocalQuickFix[0]);
        return annotationBuilder.newLocalQuickFix(fix, descriptor).range(range).registerFix();
    }

    @NotNull
    public static final ProblemDescriptor createDescriptor(@NotNull Annotation $this$createDescriptor, @NotNull PsiElement element) {
        return InspectionManager.getInstance((Project)element.getProject()).createProblemDescriptor(element, element, $this$createDescriptor.getMessage(), $this$createDescriptor.getHighlightType(), true, new LocalQuickFix[0]);
    }

    static {
        Object[] objectArray = new String[]{"def", "final"};
        VARIABLE_MODIFIERS = SetsKt.setOf((Object[])objectArray);
    }
}

