/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator40;
import org.jetbrains.plugins.groovy.annotator.UtilKt;
import org.jetbrains.plugins.groovy.annotator.intentions.AddToPermitsList;
import org.jetbrains.plugins.groovy.annotator.intentions.GrChangeModifiersFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GrReplaceReturnWithYield;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrYieldStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSwitchExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrPermitsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrRecordDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.util.GrRecordUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.SealedUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;
import org.jetbrains.plugins.groovy.transformations.immutable.GrImmutableUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 D2\u00020\u0001:\u0001DB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J'\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\b\"\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u001a\u0010 \u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0013H\u0002J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\tH\u0016J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0019H\u0016J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u001cH\u0016J\u0014\u00107\u001a\u00020\u0006*\u00020\u001c2\u0006\u00108\u001a\u000209H\u0002J\u0014\u0010:\u001a\u00020\u0006*\u00020\u001c2\u0006\u0010;\u001a\u00020<H\u0002J\u0014\u0010=\u001a\u00020\u0006*\u00020\u001c2\u0006\u0010>\u001a\u00020?H\u0002J\u0014\u0010@\u001a\u00020\u0006*\u00020\u001c2\u0006\u0010A\u001a\u00020BH\u0002J\f\u0010C\u001a\u00020\u0006*\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotator40;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "checkArrowColonConsistency", "", "caseSections", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/clauses/GrCaseSection;", "([Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/clauses/GrCaseSection;)V", "checkCompactConstructor", "method", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "checkEnum", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "checkExclusiveness", "exclusiveElement", "Lcom/intellij/psi/PsiElement;", "([Lcom/intellij/psi/PsiElement;)Lkotlin/Unit;", "checkFormalRecordParameters", "formalParameter", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/params/GrParameter;", "record", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrRecordDefinition;", "checkNonSealed", "owner", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "nonSealedElement", "checkRecordModifiers", "recordDefinition", "checkSealed", "sealedElement", "checkSealingModifiers", "createExclusivenessAnnotation", "element", "visitCaseSection", "caseSection", "visitMethod", "visitMethodCall", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "visitRecordDefinition", "visitSwitchElement", "switchElement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrSwitchElement;", "visitSwitchExpression", "switchExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrSwitchExpression;", "visitSwitchStatement", "switchStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrSwitchStatement;", "visitTypeDefinition", "typeDefinition", "checkExtendsClause", "extendsClause", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrExtendsClause;", "checkImplementsClause", "implementsClause", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrImplementsClause;", "checkPermissions", "referenceClause", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrReferenceList;", "checkPermitsClause", "permitsClause", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrPermitsClause;", "forbidForRecord", "Companion", "intellij.groovy.psi"})
public final class GroovyAnnotator40
extends GroovyElementVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnnotationHolder holder;
    @NotNull
    private static final List<String> CONFLICTING_MODIFIERS;
    @NotNull
    private static final List<String> FORBIDDEN_FOR_RECORD;

    public GroovyAnnotator40(@NotNull AnnotationHolder holder) {
        this.holder = holder;
    }

    @Override
    public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        GrReferenceList it;
        this.checkSealingModifiers(typeDefinition);
        GrPermitsClause grPermitsClause = typeDefinition.getPermitsClause();
        if (grPermitsClause != null) {
            it = grPermitsClause;
            boolean bl = false;
            this.checkPermitsClause(typeDefinition, (GrPermitsClause)it);
        }
        GrExtendsClause grExtendsClause = typeDefinition.getExtendsClause();
        if (grExtendsClause != null) {
            it = grExtendsClause;
            boolean bl = false;
            this.checkExtendsClause(typeDefinition, (GrExtendsClause)it);
        }
        GrImplementsClause grImplementsClause = typeDefinition.getImplementsClause();
        if (grImplementsClause != null) {
            it = grImplementsClause;
            boolean bl = false;
            this.checkImplementsClause(typeDefinition, (GrImplementsClause)it);
        }
        super.visitTypeDefinition(typeDefinition);
    }

    @Override
    public void visitRecordDefinition(@NotNull GrRecordDefinition recordDefinition) {
        GrModifierList grModifierList = (GrModifierList)recordDefinition.getModifierList();
        if (grModifierList != null) {
            GrModifierList it = grModifierList;
            boolean bl = false;
            this.checkRecordModifiers(it);
        }
        for (GrParameter formalParameter : recordDefinition.getParameters()) {
            this.checkFormalRecordParameters(formalParameter, recordDefinition);
        }
        super.visitRecordDefinition(recordDefinition);
    }

    private final void checkFormalRecordParameters(GrParameter formalParameter, GrRecordDefinition record) {
        GrField grField;
        block4: {
            if (formalParameter.hasModifierProperty("static")) {
                return;
            }
            GrField[] grFieldArray = record.getFields();
            int n = grFieldArray.length;
            for (int j = 0; j < n; ++j) {
                GrField grField2;
                GrField it = grField2 = grFieldArray[j];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)formalParameter.getName())) continue;
                grField = grField2;
                break block4;
            }
            grField = null;
        }
        if (grField == null) {
            return;
        }
        GrField field = grField;
        if (!GrImmutableUtils.isImmutable(field)) {
            Object[] objectArray = new Object[]{formalParameter.getName()};
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.record.parameter.should.be.immutable", objectArray)).range(formalParameter.getNameIdentifierGroovy()).create();
        }
    }

    private final void checkRecordModifiers(GrModifierList recordDefinition) {
        block7: {
            GrAnnotation grAnnotation;
            block6: {
                GrAnnotation grAnnotation2;
                GrAnnotation it;
                GrAnnotation grAnnotation3;
                int n;
                int n2;
                GrAnnotation[] grAnnotationArray;
                block5: {
                    PsiElement psiElement = recordDefinition.getModifier("sealed");
                    if (psiElement != null) {
                        this.forbidForRecord(psiElement);
                    }
                    PsiElement psiElement2 = recordDefinition.getModifier("non-sealed");
                    if (psiElement2 != null) {
                        this.forbidForRecord(psiElement2);
                    }
                    grAnnotationArray = recordDefinition.getAnnotations();
                    n2 = grAnnotationArray.length;
                    for (n = 0; n < n2; ++n) {
                        it = grAnnotation3 = grAnnotationArray[n];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"groovy.transform.Sealed")) continue;
                        grAnnotation2 = grAnnotation3;
                        break block5;
                    }
                    grAnnotation2 = null;
                }
                if (grAnnotation2 != null) {
                    this.forbidForRecord(grAnnotation2);
                }
                grAnnotationArray = recordDefinition.getAnnotations();
                n2 = grAnnotationArray.length;
                for (n = 0; n < n2; ++n) {
                    it = grAnnotation3 = grAnnotationArray[n];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"groovy.transform.NonSealed")) continue;
                    grAnnotation = grAnnotation3;
                    break block6;
                }
                grAnnotation = null;
            }
            if (grAnnotation == null) break block7;
            this.forbidForRecord(grAnnotation);
        }
    }

    private final void forbidForRecord(PsiElement $this$forbidForRecord) {
        String elementName = $this$forbidForRecord instanceof GrAnnotation ? ((GrAnnotation)$this$forbidForRecord).getShortName() : $this$forbidForRecord.getText();
        Object[] objectArray = new Object[]{elementName};
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.0.not.allowed.for.record", objectArray)).range($this$forbidForRecord).withFix((IntentionAction)new GrChangeModifiersFix(FORBIDDEN_FOR_RECORD, null, GroovyBundle.message("intention.name.remove.wrong.modifiers.for.record", new Object[0]), true)).create();
    }

    private final void checkSealingModifiers(GrTypeDefinition owner) {
        GrModifierList grModifierList = (GrModifierList)owner.getModifierList();
        if (grModifierList == null) {
            return;
        }
        GrModifierList modifierList = grModifierList;
        if (owner instanceof GrEnumTypeDefinition) {
            this.checkEnum(modifierList);
            return;
        }
        PsiElement sealed = modifierList.getModifier("sealed");
        PsiElement nonSealed = modifierList.getModifier("non-sealed");
        PsiElement psiElement = modifierList.getModifier("final");
        PsiAnnotation sealedAnno = modifierList.findAnnotation("groovy.transform.Sealed");
        PsiAnnotation nonSealedAnno = modifierList.findAnnotation("groovy.transform.NonSealed");
        PsiElement[] psiElementArray = new PsiElement[]{sealed, nonSealed, psiElement, (PsiElement)sealedAnno, (PsiElement)nonSealedAnno};
        this.checkExclusiveness(psiElementArray);
        PsiElement psiElement2 = sealed;
        if (psiElement2 == null) {
            psiElement2 = (PsiElement)sealedAnno;
        }
        this.checkSealed(owner, psiElement2);
        PsiElement psiElement3 = nonSealed;
        if (psiElement3 == null) {
            psiElement3 = (PsiElement)nonSealedAnno;
        }
        this.checkNonSealed(owner, psiElement3);
    }

    private final Unit checkExclusiveness(PsiElement ... exclusiveElement) {
        Unit unit;
        List list;
        List it = list = ArraysKt.filterNotNull((Object[])exclusiveElement);
        boolean bl = false;
        List list2 = it.size() > 1 ? list : null;
        if (list2 != null) {
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement p0 = (PsiElement)element$iv;
                boolean bl2 = false;
                this.createExclusivenessAnnotation(p0);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final void createExclusivenessAnnotation(PsiElement element) {
        String elementName = element instanceof GrAnnotation ? ((GrAnnotation)element).getShortName() : element.getText();
        Object[] objectArray = new Object[]{elementName};
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.only.one.final.sealed.non.sealed.should.be.applied.to.class", new Object[0])).range(element).withFix((IntentionAction)new GrChangeModifiersFix(CONFLICTING_MODIFIERS, null, GroovyBundle.message("leave.only.modifier.or.annotation.0", objectArray), false, 8, null)).create();
    }

    private final void checkSealed(GrTypeDefinition owner, PsiElement sealedElement) {
        if (sealedElement == null) {
            return;
        }
        if (SealedUtil.getAllPermittedClassElements(owner).isEmpty()) {
            if (owner.isInterface()) {
                Object[] objectArray = new Object[]{owner.getName()};
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.interface.has.no.explicit.or.implicit.implementors", objectArray)).range(sealedElement).create();
            } else {
                Object[] objectArray = new Object[]{owner.getName()};
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.class.has.no.explicit.or.implicit.subclasses", objectArray)).range(sealedElement).create();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkNonSealed(GrTypeDefinition owner, PsiElement nonSealedElement) {
        boolean bl;
        Object[] objectArray;
        block9: {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            if (nonSealedElement == null) {
                return;
            }
            objectArray = new GrReferenceList[]{owner.getExtendsClause(), owner.getImplementsClause()};
            Iterable $this$flatMap$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                GrReferenceList it = (GrReferenceList)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = ArraysKt.asList((Object[])it.getReferencedTypes());
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List referencedClasses = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv = referencedClasses;
            boolean $i$f$mapNotNull = false;
            $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PsiClass it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                PsiClassType p0 = (PsiClassType)element$iv$iv;
                boolean bl4 = false;
                if (p0.resolve() == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$all$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PsiClass it = (PsiClass)element$iv;
                    boolean bl6 = false;
                    if (!(it instanceof GrTypeDefinition) || SealedUtil.getSealedElement((GrTypeDefinition)it) == null) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (bl) {
            if (owner.isInterface()) {
                objectArray = new Object[]{owner.getName()};
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.interface.cannot.be.non.sealed.without.sealed.parent", objectArray)).range(nonSealedElement).create();
            } else {
                objectArray = new Object[]{owner.getName()};
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.class.cannot.be.non.sealed.without.sealed.parent", objectArray)).range(nonSealedElement).create();
            }
        }
    }

    private final void checkEnum(GrModifierList modifierList) {
        block1: {
            PsiAnnotation it;
            UtilKt.checkModifierIsNotAllowed(modifierList, "sealed", GroovyBundle.message("inspection.message.modifier.sealed.cannot.be.applied.to.enum.class", new Object[0]), this.holder);
            UtilKt.checkModifierIsNotAllowed(modifierList, "non-sealed", GroovyBundle.message("inspection.message.modifier.non.sealed.cannot.be.applied.to.enum.class", new Object[0]), this.holder);
            PsiAnnotation psiAnnotation = modifierList.findAnnotation("groovy.transform.Sealed");
            if (psiAnnotation != null) {
                it = psiAnnotation;
                boolean bl = false;
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.annotation.sealed.cannot.be.applied.to.enum.class", new Object[0])).range((PsiElement)it).create();
            }
            PsiAnnotation psiAnnotation2 = modifierList.findAnnotation("groovy.transform.NonSealed");
            if (psiAnnotation2 == null) break block1;
            it = psiAnnotation2;
            boolean bl = false;
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.annotation.non.sealed.cannot.be.applied.to.enum.class", new Object[0])).range((PsiElement)it).create();
        }
    }

    private final void checkPermitsClause(GrTypeDefinition $this$checkPermitsClause, GrPermitsClause permitsClause) {
        if (permitsClause.getKeyword() == null || permitsClause.getReferencedTypes().length == 0) {
            super.visitPermitsClause(permitsClause);
            return;
        }
        GrModifierList grModifierList = (GrModifierList)$this$checkPermitsClause.getModifierList();
        boolean bl = grModifierList != null ? grModifierList.hasModifierProperty("sealed") : false;
        if (bl) {
            return;
        }
        GrChangeModifiersFix fix = new GrChangeModifiersFix(CONFLICTING_MODIFIERS, "sealed", GroovyBundle.message("add.modifier.sealed", new Object[0]), false, 8, null);
        Object[] objectArray = new Object[]{$this$checkPermitsClause.getName()};
        AnnotationBuilder annotationBuilder = this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.invalid.permits.clause.must.be.sealed", objectArray));
        PsiElement psiElement = permitsClause.getKeyword();
        Intrinsics.checkNotNull((Object)psiElement);
        annotationBuilder.range(psiElement).withFix((IntentionAction)fix).create();
    }

    private final void checkExtendsClause(GrTypeDefinition $this$checkExtendsClause, GrExtendsClause extendsClause) {
        this.checkPermissions($this$checkExtendsClause, extendsClause);
    }

    private final void checkImplementsClause(GrTypeDefinition $this$checkImplementsClause, GrImplementsClause implementsClause) {
        this.checkPermissions($this$checkImplementsClause, implementsClause);
    }

    private final void checkPermissions(GrTypeDefinition $this$checkPermissions, GrReferenceList referenceClause) {
        PsiClassType ownerType = InferenceKt.type($this$checkPermissions);
        for (Pair pair : ArraysKt.zip((Object[])referenceClause.getReferencedTypes(), (Object[])referenceClause.getReferenceElementsGroovy())) {
            GrTypeDefinition baseClass;
            List<PsiClass> permittedClasses;
            Object object;
            PsiClass psiClass;
            PsiClassType type2 = (PsiClassType)pair.component1();
            GrCodeReferenceElement element = (GrCodeReferenceElement)pair.component2();
            if (type2.resolve() != null) {
                PsiClass it = psiClass;
                boolean bl = false;
                object = it instanceof GrTypeDefinition && SealedUtil.getSealedElement((GrTypeDefinition)it) != null ? psiClass : null;
            } else {
                object = null;
            }
            PsiClass psiClass2 = object;
            GrTypeDefinition grTypeDefinition = psiClass2 instanceof GrTypeDefinition ? (GrTypeDefinition)psiClass2 : null;
            if (grTypeDefinition == null || (permittedClasses = SealedUtil.getAllPermittedClasses(baseClass = grTypeDefinition)).contains($this$checkPermissions)) continue;
            Object[] objectArray = new Object[]{ownerType.getClassName()};
            String message = GroovyBundle.message("inspection.message.not.allowed.in.sealed.hierarchy", objectArray);
            ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)$this$checkPermissions.getProject()).createProblemDescriptor((PsiElement)element, (PsiElement)element, message, ProblemHighlightType.ERROR, true, new LocalQuickFix[0]);
            PsiClass $this$checkPermissions_u24lambda_u2415 = psiClass = this.holder.newAnnotation(HighlightSeverity.ERROR, message).range((PsiElement)element);
            boolean bl = false;
            if (baseClass.hasModifierProperty("sealed")) {
                if (baseClass.getPermitsClause() != null) {
                    boolean bl2 = false;
                    String string = $this$checkPermissions.getName();
                    if (string == null) {
                        string = "";
                    }
                    $this$checkPermissions_u24lambda_u2415.newLocalQuickFix((LocalQuickFix)new AddToPermitsList(string, element.getText()), problemDescriptor).range(element.getTextRange()).registerFix();
                }
            }
            psiClass.create();
        }
    }

    @Override
    public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
        this.visitSwitchElement(switchStatement);
        super.visitSwitchStatement(switchStatement);
    }

    @Override
    public void visitSwitchExpression(@NotNull GrSwitchExpression switchExpression) {
        this.visitSwitchElement(switchExpression);
        super.visitSwitchExpression(switchExpression);
    }

    @Override
    public void visitMethod(@NotNull GrMethod method) {
        if (method.getContainingClass() instanceof GrRecordDefinition && GrRecordUtils.isCompactConstructor(method)) {
            this.checkCompactConstructor(method);
        }
        super.visitMethod(method);
    }

    private final void checkCompactConstructor(GrMethod method) {
        if (method.getModifierList().getModifier("public") == null && method.getModifierList().getModifier("private") == null && method.getModifierList().getModifier("protected") == null) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.compact.constructor.should.have.explicit.visibility.modifier", new Object[0])).range(method.getNameIdentifierGroovy()).withFix((IntentionAction)new GrChangeModifiersFix(CollectionsKt.emptyList(), "public", GroovyBundle.message("intention.name.make.compact.constructor.public", new Object[0]), false, 8, null)).create();
        }
    }

    private final void visitSwitchElement(GrSwitchElement switchElement) {
        block18: {
            Object element$iv;
            boolean $i$f$all;
            GrCaseSection[] jointFlow2;
            int n;
            GrCaseSection[] caseSections;
            block17: {
                boolean bl;
                block14: {
                    if (PsiUtil.isPlainSwitchStatement(switchElement)) {
                        return;
                    }
                    GrCaseSection[] grCaseSectionArray = switchElement.getCaseSections();
                    if (grCaseSectionArray == null) {
                        boolean $i$f$emptyArray = false;
                        grCaseSectionArray = new GrCaseSection[]{};
                    }
                    if ((caseSections = grCaseSectionArray).length == 0) {
                        PsiElement psiElement = switchElement.getFirstChild();
                        if (psiElement != null) {
                            PsiElement it = psiElement;
                            boolean bl2 = false;
                            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.case.or.default.branches.are.expected", new Object[0])).range(it).create();
                        }
                    }
                    this.checkArrowColonConsistency(caseSections);
                    GrCaseSection[] $this$forEach$iv = caseSections;
                    boolean $i$f$forEach = false;
                    n = $this$forEach$iv.length;
                    for (int it = 0; it < n; ++it) {
                        GrCaseSection grCaseSection;
                        GrCaseSection p0 = grCaseSection = $this$forEach$iv[it];
                        boolean bl3 = false;
                        this.visitCaseSection(p0);
                    }
                    jointFlow2 = SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])caseSections), (Function1)visitSwitchElement.jointFlow.1.INSTANCE);
                    if (!(switchElement instanceof GrSwitchStatement)) break block17;
                    GrCaseSection[] $this$all$iv = caseSections;
                    $i$f$all = false;
                    int n2 = $this$all$iv.length;
                    for (n = 0; n < n2; ++n) {
                        Object it = element$iv = $this$all$iv[n];
                        boolean bl4 = false;
                        if (it.getColon() != null) continue;
                        bl = false;
                        break block14;
                    }
                    bl = true;
                }
                if (bl) break block18;
            }
            if (!(caseSections.length == 0)) {
                boolean bl;
                GrCaseSection[] $this$all$iv;
                block15: {
                    $this$all$iv = caseSections;
                    $i$f$all = false;
                    int n3 = $this$all$iv.length;
                    for (n = 0; n < n3; ++n) {
                        Object it = element$iv = $this$all$iv[n];
                        boolean bl5 = false;
                        if (it.getColon() != null) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
                if (bl) {
                    boolean bl2;
                    block16: {
                        $this$all$iv = jointFlow2;
                        $i$f$all = false;
                        for (Object e : $this$all$iv) {
                            Instruction it = (Instruction)e;
                            boolean bl7 = false;
                            if (!(it.getElement() instanceof GrYieldStatement) && !(it.getElement() instanceof GrThrowStatement)) continue;
                            bl2 = false;
                            break block16;
                        }
                        bl2 = true;
                    }
                    if (bl2) {
                        PsiElement psiElement = switchElement.getFirstChild();
                        if (psiElement == null) {
                            psiElement = switchElement;
                        }
                        PsiElement errorOwner = psiElement;
                        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.yield.or.throw.expected.in.case.section", new Object[0])).range(errorOwner).create();
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkArrowColonConsistency(GrCaseSection[] caseSections) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        GrCaseSection[] $this$mapNotNull$iv = caseSections;
        boolean $i$f$mapNotNull = false;
        GrCaseSection[] grCaseSectionArray = $this$mapNotNull$iv;
        GrCaseSection[] destination$iv$iv = (GrCaseSection[])new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            PsiElement it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            void p0 = element$iv$iv;
            boolean bl2 = false;
            if (p0.getArrow() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        List p0 = list;
        boolean bl = false;
        Object object = !((Collection)p0).isEmpty() ? list : null;
        if (object == null) {
            return;
        }
        List arrows = object;
        Object $this$mapNotNull$iv2 = caseSections;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        int n2 = ((void)$this$forEach$iv$iv$iv2).length;
        for (n = 0; n < n2; ++n) {
            PsiElement it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv2[n];
            boolean bl4 = false;
            void p02 = element$iv$iv;
            boolean bl5 = false;
            if (p02.getColon() == null) continue;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Object p03 = $this$mapNotNull$iv2 = (List)destination$iv$iv2;
        boolean bl7 = false;
        Object object2 = !((Collection)p03).isEmpty() ? $this$mapNotNull$iv2 : null;
        if (object2 == null) {
            return;
        }
        Object colons = object2;
        for (PsiElement element : CollectionsKt.plus((Collection)arrows, (Iterable)((Iterable)colons))) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.mixing.arrows.colons.not.allowed", new Object[0])).range(element).create();
        }
    }

    @Override
    public void visitMethodCall(@NotNull GrMethodCall call) {
        block5: {
            Object object;
            block7: {
                block6: {
                    PsiMethod psiMethod;
                    super.visitMethodCall(call);
                    GrExpression $this$asSafely$iv = call.getInvokedExpression();
                    boolean $i$f$asSafely = false;
                    GrExpression grExpression = $this$asSafely$iv;
                    if (!(grExpression instanceof GrReferenceExpression)) {
                        grExpression = null;
                    }
                    GrReferenceExpression grReferenceExpression = (GrReferenceExpression)grExpression;
                    boolean bl = grReferenceExpression != null ? !grReferenceExpression.isQualified() : false;
                    if (!bl) break block5;
                    object = call.resolveMethod();
                    if (object == null) break block6;
                    PsiMethod it = psiMethod = object;
                    boolean bl2 = false;
                    object = it.hasModifierProperty("static") ? psiMethod : null;
                    if (object != null) break block7;
                }
                return;
            }
            PsiMethod resolved = object;
            PsiClass psiClass = resolved.getContainingClass();
            boolean bl = psiClass != null ? psiClass.isInterface() : false;
            if (bl) {
                GroovyFix fix = GroovyQuickFixFactory.getInstance().createQualifyExpressionFix();
                ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)call.getProject()).createProblemDescriptor((PsiElement)call, GroovyBundle.message("intention.name.replace.with.qualified.expression", new Object[0]), (LocalQuickFix)fix, ProblemHighlightType.ERROR, true);
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.static.interface.methods.must.be.qualified.in.groovy.4", new Object[0])).range((PsiElement)call.getInvokedExpression()).newLocalQuickFix((LocalQuickFix)fix, problemDescriptor).registerFix().create();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitCaseSection(@NotNull GrCaseSection caseSection) {
        void $this$filterIsInstanceTo$iv$iv;
        boolean bl;
        PsiElement $this$parentOfType_u24default$iv = caseSection;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        GrSwitchElement grSwitchElement = (GrSwitchElement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GrSwitchElement.class, (boolean)true);
        if (grSwitchElement != null) {
            GrSwitchElement p0 = grSwitchElement;
            boolean bl2 = false;
            bl = PsiUtil.isPlainSwitchStatement(p0);
        } else {
            bl = false;
        }
        if (bl) {
            return;
        }
        Instruction[] flow = ControlFlowUtils.getCaseSectionInstructions(caseSection);
        List<GrStatement> returns = ControlFlowUtils.collectReturns(flow, caseSection, false);
        Iterable $this$filterIsInstance$iv = returns;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GrReturnStatement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (GrReturnStatement returnStatement : (List)destination$iv$iv) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.switch.expressions.do.not.support.return", new Object[0])).range((PsiElement)returnStatement).withFix((IntentionAction)new GrReplaceReturnWithYield()).create();
        }
        super.visitCaseSection(caseSection);
    }

    static {
        Object[] objectArray = new String[]{"sealed", "non-sealed", "final", "groovy.transform.Sealed", "groovy.transform.NonSealed"};
        CONFLICTING_MODIFIERS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"sealed", "non-sealed", "groovy.transform.Sealed", "groovy.transform.NonSealed"};
        FORBIDDEN_FOR_RECORD = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotator40$Companion;", "", "()V", "CONFLICTING_MODIFIERS", "", "", "FORBIDDEN_FOR_RECORD", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

