/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.groovy;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.template.GroovyTemplateContextType;

public class GroovyStructuralSearchProfile
extends StructuralSearchProfileBase {
    public static final PatternContext FILE_CONTEXT = new PatternContext("File", () -> SSRBundle.message((String)"pattern.context.default", (Object[])new Object[0]));
    public static final PatternContext CLASS_CONTEXT = new PatternContext("Class", () -> SSRBundle.message((String)"pattern.context.class.member", (Object[])new Object[0]));
    private static final List<PatternContext> PATTERN_CONTEXTS = ContainerUtil.immutableList((Object[])new PatternContext[]{FILE_CONTEXT, CLASS_CONTEXT});
    private static final TokenSet VARIABLE_DELIMITERS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mCOMMA, GroovyTokenTypes.mSEMI});

    protected String @NotNull [] getVarPrefixes() {
        return new String[]{"_$_____"};
    }

    @NotNull
    public List<PatternContext> getPatternContexts() {
        return PATTERN_CONTEXTS;
    }

    public boolean isMyLanguage(@NotNull Language language) {
        return language == GroovyLanguage.INSTANCE;
    }

    @NotNull
    protected TokenSet getVariableDelimiters() {
        return VARIABLE_DELIMITERS;
    }

    public PsiCodeFragment createCodeFragment(@NotNull Project project, @NotNull String text, String contextId) {
        return new GroovyCodeFragment(project, text);
    }

    @NotNull
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return GroovyTemplateContextType.Generic.class;
    }

    @NotNull
    public String getContext(@NotNull String pattern, @Nullable Language language, String contextId) {
        return CLASS_CONTEXT.getId().equals(contextId) ? "class AAAAA { $$PATTERN_PLACEHOLDER$$ }" : "$$PATTERN_PLACEHOLDER$$";
    }

    public boolean isIdentifier(@Nullable PsiElement element) {
        return element instanceof PsiIdentifier;
    }
}

