/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.BaseUpdateCommandListener;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.update.UpdateClient;

public class CmdUpdateClient
extends BaseSvnClient
implements UpdateClient {
    @Nullable
    private ProgressTracker myDispatcher;
    private boolean myIgnoreExternals;

    @Override
    public void setEventHandler(ProgressTracker dispatcher) {
        this.myDispatcher = dispatcher;
    }

    @Override
    public void setIgnoreExternals(boolean ignoreExternals) {
        this.myIgnoreExternals = ignoreExternals;
    }

    private void checkWorkingCopy(@NotNull File path) throws SvnBindException {
        Info info2 = this.myFactory.createInfoClient().doInfo(path, Revision.UNDEFINED);
        if (info2 == null || info2.getUrl() == null) {
            throw new SvnBindException(ErrorCode.WC_NOT_WORKING_COPY, path.getPath());
        }
    }

    private long[] run(@NotNull File path, @NotNull List<String> parameters, @NotNull SvnCommandName command) throws SvnBindException {
        File base = path.isDirectory() ? path : path.getParentFile();
        AtomicReference<long[]> updatedToRevision = new AtomicReference<long[]>();
        updatedToRevision.set(new long[0]);
        BaseUpdateCommandListener listener2 = this.createCommandListener(new File[]{path}, updatedToRevision, base);
        this.execute(this.myVcs, Target.on(base), command, parameters, (LineCommandListener)listener2);
        listener2.throwWrappedIfException();
        return updatedToRevision.get();
    }

    private BaseUpdateCommandListener createCommandListener(final File[] paths, final AtomicReference<long[]> updatedToRevision, File base) {
        return new BaseUpdateCommandListener(base, this.myDispatcher){
            final long[] myRevisions;
            {
                super(base, handler);
                this.myRevisions = new long[paths.length];
            }

            @Override
            protected void beforeHandler(@NotNull ProgressEvent event) {
                if (EventAction.UPDATE_COMPLETED.equals((Object)event.getAction())) {
                    long eventRevision = event.getRevision();
                    for (int i = 0; i < paths.length; ++i) {
                        File path = paths[i];
                        if (!FileUtil.filesEqual((File)path, (File)event.getFile())) continue;
                        this.myRevisions[i] = eventRevision;
                        break;
                    }
                }
            }

            public void processTerminated(int exitCode) {
                super.processTerminated(exitCode);
                updatedToRevision.set(this.myRevisions);
            }
        };
    }

    private static void fillParameters(@NotNull List<String> parameters, @Nullable Revision revision, @Nullable Depth depth, boolean depthIsSticky, boolean allowUnversionedObstructions) {
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, depth, depthIsSticky);
        CommandUtil.put(parameters, allowUnversionedObstructions, "--force");
        CommandUtil.put(parameters, "--accept", "postpone");
    }

    @Override
    public long doUpdate(File path, Revision revision, Depth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SvnBindException {
        this.checkWorkingCopy(path);
        ArrayList<String> parameters = new ArrayList<String>();
        CmdUpdateClient.fillParameters(parameters, revision, depth, depthIsSticky, allowUnversionedObstructions);
        CommandUtil.put(parameters, this.myIgnoreExternals, "--ignore-externals");
        CommandUtil.put(parameters, path);
        long[] longs = this.run(path, parameters, SvnCommandName.up);
        return longs[0];
    }

    @Override
    public long doSwitch(File path, Url url, Revision pegRevision, Revision revision, Depth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SvnBindException {
        long[] revisions;
        this.checkWorkingCopy(path);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, Target.on(url, pegRevision));
        CommandUtil.put(parameters, path, false);
        CmdUpdateClient.fillParameters(parameters, revision, depth, depthIsSticky, allowUnversionedObstructions);
        if (!this.myVcs.is16SupportedByCommandLine() || WorkingCopyFormat.from(this.myFactory.createVersionClient().getVersion()).isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN)) {
            parameters.add("--ignore-ancestry");
        }
        return (revisions = this.run(path, parameters, SvnCommandName.switchCopy)) != null && revisions.length > 0 ? revisions[0] : -1L;
    }
}

