/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.treeConflict;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.idea.svn.BackgroundTaskGroup;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.treeConflict.ApplyPatchSaveToFileExecutor;
import org.jetbrains.idea.svn.treeConflict.SvnTreeConflictResolver;
import org.jetbrains.idea.svn.treeConflict.TreeConflictRefreshablePanel;

public final class MergeFromTheirsResolver
extends BackgroundTaskGroup {
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final TreeConflictDescription myDescription;
    @NotNull
    private final Change myChange;
    @NotNull
    private final FilePath myOldFilePath;
    @NotNull
    private final FilePath myNewFilePath;
    @NotNull
    private final String myOldPresentation;
    @NotNull
    private final String myNewPresentation;
    private final SvnRevisionNumber myCommittedRevision;
    private Boolean myAdd;
    @NotNull
    private final List<Change> myTheirsChanges;
    @NotNull
    private final List<Change> myTheirsBinaryChanges;
    private List<FilePatch> myTextPatches;
    private final VirtualFile myBaseForPatch;
    private boolean myThereAreCreations;

    public MergeFromTheirsResolver(@NotNull SvnVcs vcs, @NotNull TreeConflictDescription description, @NotNull Change change, SvnRevisionNumber revision) {
        super(vcs.getProject(), SvnBundle.message("progress.title.resolve.tree.conflict", new Object[0]));
        this.myVcs = vcs;
        this.myDescription = description;
        this.myChange = change;
        this.myCommittedRevision = revision;
        this.myOldFilePath = Objects.requireNonNull(this.myChange.getBeforeRevision()).getFile();
        this.myNewFilePath = Objects.requireNonNull(this.myChange.getAfterRevision()).getFile();
        this.myBaseForPatch = ChangesUtil.findValidParentAccurately((FilePath)this.myNewFilePath);
        this.myOldPresentation = TreeConflictRefreshablePanel.filePath(this.myOldFilePath);
        this.myNewPresentation = TreeConflictRefreshablePanel.filePath(this.myNewFilePath);
        this.myTheirsChanges = new ArrayList<Change>();
        this.myTheirsBinaryChanges = new ArrayList<Change>();
        this.myTextPatches = Collections.emptyList();
    }

    @RequiresEdt
    public void execute() {
        String message = this.myChange.isMoved() ? SvnBundle.message("confirmation.resolve.tree.conflict.merge.moved", this.myOldPresentation, this.myNewPresentation) : SvnBundle.message("confirmation.resolve.tree.conflict.merge.renamed", this.myOldPresentation, this.myNewPresentation);
        int ok = Messages.showOkCancelDialog((Project)this.myVcs.getProject(), (String)message, (String)SvnBundle.message("dialog.title.resolve.tree.conflict", new Object[0]), (Icon)Messages.getQuestionIcon());
        if (0 != ok) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        this.runInBackground(SvnBundle.message("progress.title.getting.base.and.theirs.revisions.content", new Object[0]), (ThrowableConsumer<ProgressIndicator, VcsException>)((ThrowableConsumer)indicator -> this.preloadContent()));
        this.runInEdt((ThrowableRunnable<VcsException>)((ThrowableRunnable)this::convertTextPaths));
        this.runInBackground(SvnBundle.message("progress.title.creating.patch.for.theirs.changes", new Object[0]), (ThrowableConsumer<ProgressIndicator, VcsException>)((ThrowableConsumer)indicator -> this.createPatches()));
        this.runInEdt((ThrowableRunnable<VcsException>)((ThrowableRunnable)() -> this.selectPatchesInApplyPatchDialog(exception -> {
            if (exception == null) {
                this.runInBackground(SvnBundle.message("progress.title.accepting.working.state", new Object[0]), (ThrowableConsumer<ProgressIndicator, VcsException>)((ThrowableConsumer)indicator -> this.resolveConflicts()));
                if (this.myThereAreCreations) {
                    this.runInBackground(SvnBundle.message("progress.title.adding.file.to.subversion", this.myOldPresentation), (ThrowableConsumer<ProgressIndicator, VcsException>)((ThrowableConsumer)indicator -> this.addDirectories()));
                }
                this.runInEdt((ThrowableRunnable<VcsException>)((ThrowableRunnable)this::selectBinaryFiles));
                this.runInBackground(SvnBundle.message("progress.title.applying.binary.changes", new Object[0]), (ThrowableConsumer<ProgressIndicator, VcsException>)((ThrowableConsumer)indicator -> this.applyBinaryChanges()));
                this.runInEdt((ThrowableRunnable<VcsException>)((ThrowableRunnable)this::notifyMergeIsFinished));
            } else {
                this.addError((VcsException)((Object)((Object)exception)));
                this.showErrors();
            }
        })));
    }

    private void notifyMergeIsFinished() {
        VcsBalloonProblemNotifier.showOverChangesView((Project)this.myVcs.getProject(), (String)SvnBundle.message("message.theirs.changes.merged.for.file", this.myOldPresentation), (MessageType)MessageType.INFO, (NamedRunnable[])new NamedRunnable[0]);
        this.showErrors();
    }

    private void resolveConflicts() throws VcsException {
        new SvnTreeConflictResolver(this.myVcs, this.myOldFilePath, null).resolveSelectMineFull();
    }

    @RequiresEdt
    private void convertTextPaths() throws VcsException {
        List<Change> convertedChanges = this.convertPaths(this.myTheirsChanges);
        this.myTheirsChanges.clear();
        this.myTheirsChanges.addAll(convertedChanges);
    }

    @RequiresEdt
    private void selectPatchesInApplyPatchDialog(@NotNull Consumer<VcsException> callback) {
        LocalChangeList changeList = ChangeListManager.getInstance((Project)this.myVcs.getProject()).getChangeList(this.myChange);
        TreeConflictApplyTheirsPatchExecutor patchExecutor = new TreeConflictApplyTheirsPatchExecutor(this.myVcs, this.myBaseForPatch);
        ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(this.myVcs.getProject(), (ApplyPatchExecutor)patchExecutor, Collections.singletonList(new ApplyPatchSaveToFileExecutor(this.myVcs.getProject(), this.myBaseForPatch)), ApplyPatchMode.APPLY_PATCH_IN_MEMORY, this.myTextPatches, (ChangeList)changeList);
        patchExecutor.myPromise.onSuccess(callback);
        dialog.show();
    }

    private void addDirectories() throws VcsException {
        this.myVcs.getFactory(this.myOldFilePath.getIOFile()).createAddClient().add(this.myOldFilePath.getIOFile(), Depth.EMPTY, true, false, true, null);
    }

    private void createPatches() throws VcsException {
        List patches = IdeaTextPatchBuilder.buildPatch((Project)this.myVcs.getProject(), this.myTheirsChanges, (Path)Objects.requireNonNull(this.myBaseForPatch).toNioPath(), (boolean)false);
        this.myTextPatches = ContainerUtil.map((Collection)patches, TextFilePatch.class::cast);
    }

    @RequiresEdt
    private void selectBinaryFiles() throws VcsException {
        List<Change> converted = this.convertPaths(this.myTheirsBinaryChanges);
        if (!converted.isEmpty()) {
            Map map = converted.stream().collect(Collectors.toMap(ChangesUtil::getFilePath, Function.identity()));
            Collection<FilePath> selected = this.chooseBinaryFiles(converted, map.keySet());
            this.myTheirsBinaryChanges.clear();
            if (!ContainerUtil.isEmpty(selected)) {
                for (FilePath filePath : selected) {
                    this.myTheirsBinaryChanges.add((Change)map.get(filePath));
                }
            }
        }
    }

    private void applyBinaryChanges() throws VcsException {
        ArrayList dirtyPaths = new ArrayList();
        for (Change change : this.myTheirsBinaryChanges) {
            try {
                WriteAction.runAndWait(() -> {
                    dirtyPaths.add(ChangesUtil.getFilePath((Change)change));
                    try {
                        MergeFromTheirsResolver.applyBinaryChange(change);
                    }
                    catch (IOException e) {
                        throw new VcsException((Throwable)e);
                    }
                });
            }
            catch (Throwable e) {
                this.processBinaryChangeError(e);
            }
        }
        VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject()).filePathsDirty(dirtyPaths, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processBinaryChangeError(@NotNull Throwable error) throws VcsException {
        if (error instanceof VcsException) {
            VcsException vcsError = (VcsException)error;
            if (!vcsError.isWarning()) throw vcsError;
            this.addError(vcsError);
            return;
        } else {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)error);
        }
    }

    private static void applyBinaryChange(@NotNull Change change) throws IOException, VcsException {
        if (change.getAfterRevision() == null) {
            FilePath path = Objects.requireNonNull(change.getBeforeRevision()).getFile();
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path.getPath());
            if (file == null) {
                throw new VcsException(SvnBundle.message("error.can.not.delete.file", path.getPath()), true);
            }
            file.delete(TreeConflictRefreshablePanel.class);
        } else {
            FilePath file = change.getAfterRevision().getFile();
            String parentPath = Objects.requireNonNull(file.getParentPath()).getPath();
            VirtualFile parentFile = VfsUtil.createDirectoryIfMissing((String)parentPath);
            if (parentFile == null) {
                throw new VcsException(SvnBundle.message("error.can.not.create.directory", parentPath), true);
            }
            VirtualFile child = parentFile.createChildData(TreeConflictRefreshablePanel.class, file.getName());
            byte[] content = ((BinaryContentRevision)change.getAfterRevision()).getBinaryContent();
            if (content == null) {
                throw new VcsException(SvnBundle.message("error.can.not.load.theirs.content.for.file", file.getPath()), true);
            }
            child.setBinaryContent(content);
        }
    }

    @Nullable
    private Collection<FilePath> chooseBinaryFiles(@NotNull List<Change> changes, @NotNull Set<FilePath> paths) {
        return AbstractVcsHelper.getInstance((Project)this.myVcs.getProject()).selectFilePathsToProcess(new ArrayList<FilePath>(paths), SvnBundle.message("dialog.title.resolve.tree.conflict", new Object[0]), SvnBundle.message("dialog.message.select.binary.files.to.patch", new Object[0]), SvnBundle.message("dialog.title.resolve.tree.conflict", new Object[0]), changes.size() == 1 ? MergeFromTheirsResolver.getSingleBinaryFileMessage(changes.get(0)) : "", VcsShowConfirmationOption.STATIC_SHOW_CONFIRMATION);
    }

    @NlsContexts.DialogMessage
    @NotNull
    private static String getSingleBinaryFileMessage(@NotNull Change change) {
        String path = TreeConflictRefreshablePanel.filePath(ChangesUtil.getFilePath((Change)change));
        return FileStatus.DELETED.equals(change.getFileStatus()) ? SvnBundle.message("dialog.message.merge.from.theirs.delete.binary.file", path) : (FileStatus.ADDED.equals(change.getFileStatus()) ? SvnBundle.message("dialog.message.merge.from.theirs.create.binary.file", path) : SvnBundle.message("dialog.message.merge.from.theirs.modify.binary.file", path));
    }

    @RequiresEdt
    @NotNull
    private List<Change> convertPaths(@NotNull List<Change> changes) throws VcsException {
        this.initAddOption();
        ArrayList<Change> result = new ArrayList<Change>();
        for (Change change : changes) {
            if (!MergeFromTheirsResolver.isUnderOldDir(change, this.myOldFilePath)) continue;
            result.add(new Change(this.convertBeforeRevision(change.getBeforeRevision()), this.convertAfterRevision(change, change.getAfterRevision())));
        }
        return result;
    }

    @Nullable
    private ContentRevision convertBeforeRevision(@Nullable ContentRevision revision) throws VcsException {
        return revision != null ? this.toSimpleRevision(revision, true) : null;
    }

    @Nullable
    private ContentRevision convertAfterRevision(@NotNull Change change, @Nullable ContentRevision revision) throws VcsException {
        if (revision == null) {
            return null;
        }
        return this.myAdd != false && (change.getBeforeRevision() == null || change.isMoved() || change.isRenamed()) ? revision : this.toSimpleRevision(revision, true);
    }

    @NotNull
    private SimpleContentRevision toSimpleRevision(@NotNull ContentRevision revision, boolean rebasePath) throws VcsException {
        return new SimpleContentRevision(revision.getContent(), rebasePath ? MergeFromTheirsResolver.rebasePath(this.myOldFilePath, this.myNewFilePath, revision.getFile()) : this.myNewFilePath, revision.getRevisionNumber().asString());
    }

    private static boolean isUnderOldDir(@NotNull Change change, @NotNull FilePath path) {
        FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
        FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
        return beforePath != null && FileUtil.isAncestor((String)path.getPath(), (String)beforePath.getPath(), (boolean)true) || afterPath != null && FileUtil.isAncestor((String)path.getPath(), (String)afterPath.getPath(), (boolean)true);
    }

    @NotNull
    private static FilePath rebasePath(@NotNull FilePath oldBase, @NotNull FilePath newBase, @NotNull FilePath path) {
        String relativePath = Objects.requireNonNull(FileUtil.getRelativePath((String)oldBase.getPath(), (String)path.getPath(), (char)'/'));
        return VcsUtil.getFilePath((String)(newBase.getPath() + "/" + relativePath), (boolean)path.isDirectory());
    }

    private void preloadContent() throws VcsException {
        if (this.myDescription.isDirectory()) {
            this.preloadForDirectory();
        } else {
            this.preloadForFile();
        }
    }

    private void preloadForFile() throws VcsException {
        SvnContentRevision base = SvnContentRevision.createBaseRevision(this.myVcs, this.myNewFilePath, this.myCommittedRevision.getRevision());
        SvnContentRevision remote = SvnContentRevision.createRemote(this.myVcs, this.myOldFilePath, Revision.of(this.myDescription.getSourceRightVersion().getPegRevision()));
        this.myTheirsChanges.add(new Change((ContentRevision)this.toSimpleRevision(base, false), (ContentRevision)this.toSimpleRevision(remote, false)));
    }

    private void preloadForDirectory() throws VcsException {
        List changes = CommittedChangesTreeBrowser.collectChanges(this.loadSvnChangeListsForPatch(this.myDescription), (boolean)true);
        for (Change change : changes) {
            MergeFromTheirsResolver.preloadRevisionContents(change.getBeforeRevision());
            MergeFromTheirsResolver.preloadRevisionContents(change.getAfterRevision());
        }
        Map<Boolean, List<Change>> changesSplit = changes.stream().collect(Collectors.partitioningBy(MergeFromTheirsResolver::isBinaryChange));
        this.myTheirsBinaryChanges.addAll((Collection<Change>)changesSplit.get(Boolean.TRUE));
        this.myTheirsChanges.addAll((Collection<Change>)changesSplit.get(Boolean.FALSE));
    }

    private static void preloadRevisionContents(@Nullable ContentRevision revision) throws VcsException {
        if (revision != null) {
            if (revision instanceof BinaryContentRevision) {
                ((BinaryContentRevision)revision).getBinaryContent();
            } else {
                revision.getContent();
            }
        }
    }

    @NotNull
    private List<SvnChangeList> loadSvnChangeListsForPatch(@NotNull TreeConflictDescription description) throws VcsException {
        long max = description.getSourceRightVersion().getPegRevision();
        long min = description.getSourceLeftVersion().getPegRevision();
        SvnRepositoryLocation location = new SvnRepositoryLocation(description.getSourceRightVersion().getRepositoryRoot());
        ChangeBrowserSettings settings = new ChangeBrowserSettings();
        settings.USE_CHANGE_AFTER_FILTER = true;
        settings.USE_CHANGE_BEFORE_FILTER = true;
        settings.CHANGE_BEFORE = String.valueOf(max);
        settings.CHANGE_AFTER = String.valueOf(min);
        CachingCommittedChangesProvider provider = Objects.requireNonNull(this.myVcs.getCachingCommittedChangesProvider());
        List committedChanges = provider.getCommittedChanges(settings, (RepositoryLocation)location, 0);
        return ContainerUtil.filter((Collection)committedChanges, changeList -> changeList.getNumber() != min);
    }

    @RequiresEdt
    private void initAddOption() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myAdd == null) {
            this.myAdd = this.getAddedFilesPlaceOption();
        }
    }

    private boolean getAddedFilesPlaceOption() {
        final SvnConfiguration configuration = this.myVcs.getSvnConfiguration();
        Boolean add = configuration.isKeepNewFilesAsIsForTreeConflictMerge();
        if (add != null) {
            return add;
        }
        if (!MergeFromTheirsResolver.containAdditions(this.myTheirsChanges) && !MergeFromTheirsResolver.containAdditions(this.myTheirsBinaryChanges)) {
            return false;
        }
        return 0 == ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)SvnBundle.message("dialog.title.resolve.tree.conflict", new Object[0]), (String)SvnBundle.message("dialog.message.keep.newly.created.files.in.their.original.place", new Object[0])).yesText(SvnBundle.message("button.keep", new Object[0]))).noText(SvnBundle.message("button.move", new Object[0]))).doNotAsk(new DoNotAskOption(){

            public boolean isToBeShown() {
                return true;
            }

            public void setToBeShown(boolean value, int exitCode) {
                if (!value) {
                    configuration.setKeepNewFilesAsIsForTreeConflictMerge(exitCode == 0);
                }
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            @NotNull
            public String getDoNotShowMessage() {
                return IdeCoreBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]);
            }
        })).show();
    }

    private static boolean containAdditions(@NotNull List<Change> changes) {
        return changes.stream().anyMatch(change -> change.getBeforeRevision() == null || change.isMoved() || change.isRenamed());
    }

    private static boolean isBinaryContentRevision(@Nullable ContentRevision revision) {
        return revision instanceof BinaryContentRevision && !revision.getFile().isDirectory();
    }

    private static boolean isBinaryChange(@NotNull Change change) {
        return MergeFromTheirsResolver.isBinaryContentRevision(change.getBeforeRevision()) || MergeFromTheirsResolver.isBinaryContentRevision(change.getAfterRevision());
    }

    private class TreeConflictApplyTheirsPatchExecutor
    implements ApplyPatchExecutor<TextFilePatchInProgress> {
        @NotNull
        private final SvnVcs myVcs;
        private final VirtualFile myBaseDir;
        @NotNull
        private final AsyncPromise<VcsException> myPromise;

        TreeConflictApplyTheirsPatchExecutor(SvnVcs vcs, VirtualFile baseDir) {
            this.myVcs = vcs;
            this.myBaseDir = baseDir;
            this.myPromise = new AsyncPromise();
        }

        public String getName() {
            return VcsBundle.message((String)"button.apply.patch", (Object[])new Object[0]);
        }

        public void apply(@NotNull List<? extends FilePatch> remaining, final @NotNull MultiMap<VirtualFile, TextFilePatchInProgress> patchGroupsToApply, final @Nullable LocalChangeList localList, @Nullable String fileName, @Nullable ThrowableComputable<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
            new Task.Backgroundable(this.myVcs.getProject(), VcsBundle.message((String)"patch.apply.progress.title", (Object[])new Object[0])){
                VcsException myException;
                {
                    super(arg0, arg1);
                    this.myException = null;
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    try {
                        List<FilePatch> patches = ApplyPatchSaveToFileExecutor.toOnePatchGroup((MultiMap<VirtualFile, TextFilePatchInProgress>)patchGroupsToApply, TreeConflictApplyTheirsPatchExecutor.this.myBaseDir);
                        new PatchApplier(Objects.requireNonNull(this.myProject), TreeConflictApplyTheirsPatchExecutor.this.myBaseDir, patches, localList, null).execute(false, true);
                        MergeFromTheirsResolver.this.myThereAreCreations = patches.stream().anyMatch(patch -> patch.isNewFile() || !Objects.equals(patch.getAfterName(), patch.getBeforeName()));
                    }
                    catch (IOException e) {
                        this.myException = new VcsException((Throwable)e);
                    }
                }

                public void onFinished() {
                    TreeConflictApplyTheirsPatchExecutor.this.myPromise.setResult((Object)this.myException);
                }
            }.queue();
        }
    }
}

