/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.treeConflict;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.FileHistoryPanelImpl;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistoryPartnerAdapter;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.ui.JBColor;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.history.SvnHistoryProvider;
import org.jetbrains.idea.svn.treeConflict.ConflictSidePresentation;
import org.jetbrains.idea.svn.treeConflict.HistoryConflictSideKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/idea/svn/treeConflict/HistoryConflictSide;", "Lorg/jetbrains/idea/svn/treeConflict/ConflictSidePresentation;", "vcs", "Lorg/jetbrains/idea/svn/SvnVcs;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "from", "Lorg/jetbrains/idea/svn/api/Revision;", "to", "(Lorg/jetbrains/idea/svn/SvnVcs;Lcom/intellij/openapi/vcs/FilePath;Lorg/jetbrains/idea/svn/api/Revision;Lorg/jetbrains/idea/svn/api/Revision;)V", "listToReportLoaded", "Lit/unimi/dsi/fastutil/longs/LongArrayList;", "getListToReportLoaded", "()Lit/unimi/dsi/fastutil/longs/LongArrayList;", "setListToReportLoaded", "(Lit/unimi/dsi/fastutil/longs/LongArrayList;)V", "provider", "Lorg/jetbrains/idea/svn/history/SvnHistoryProvider;", "Lorg/jetbrains/annotations/NotNull;", "sessionAdapter", "Lcom/intellij/openapi/vcs/history/VcsAppendableHistoryPartnerAdapter;", "createPanel", "Ljavax/swing/JPanel;", "dispose", "", "load", "intellij.vcs.svn"})
public final class HistoryConflictSide
implements ConflictSidePresentation {
    @NotNull
    private final SvnVcs vcs;
    @NotNull
    private final FilePath path;
    @NotNull
    private final Revision from;
    @Nullable
    private final Revision to;
    @NotNull
    private final VcsAppendableHistoryPartnerAdapter sessionAdapter;
    @NotNull
    private final SvnHistoryProvider provider;
    @Nullable
    private LongArrayList listToReportLoaded;

    public HistoryConflictSide(@NotNull SvnVcs vcs, @NotNull FilePath path, @NotNull Revision from, @Nullable Revision to) {
        this.vcs = vcs;
        this.path = path;
        this.from = from;
        this.to = to;
        this.sessionAdapter = new VcsAppendableHistoryPartnerAdapter();
        this.provider = this.vcs.getVcsHistoryProvider();
    }

    @Nullable
    public final LongArrayList getListToReportLoaded() {
        return this.listToReportLoaded;
    }

    public final void setListToReportLoaded(@Nullable LongArrayList longArrayList) {
        this.listToReportLoaded = longArrayList;
    }

    @Override
    public void load() throws VcsException {
        this.provider.reportAppendableHistory(this.path, (VcsAppendableHistorySessionPartner)this.sessionAdapter, this.from, this.to, this.to == null ? 10 : 0, this.to, true);
        VcsAbstractHistorySession vcsAbstractHistorySession = this.sessionAdapter.getSession();
        if (vcsAbstractHistorySession == null) {
            return;
        }
        VcsAbstractHistorySession session = vcsAbstractHistorySession;
        if (this.listToReportLoaded == null) {
            return;
        }
        for (VcsFileRevision revision : session.getRevisionList()) {
            LongArrayList longArrayList = this.listToReportLoaded;
            Intrinsics.checkNotNull((Object)longArrayList);
            longArrayList.add(HistoryConflictSideKt.access$getSvnRevision(revision).getNumber());
        }
    }

    @Override
    @Nullable
    public JPanel createPanel() {
        VcsAbstractHistorySession vcsAbstractHistorySession = this.sessionAdapter.getSession();
        if (vcsAbstractHistorySession == null) {
            return null;
        }
        VcsAbstractHistorySession session = vcsAbstractHistorySession;
        Collection collection = session.getRevisionList();
        if (collection.isEmpty()) {
            boolean bl = false;
            return null;
        }
        List revisions = (List)collection;
        VcsFileRevision lastRevision = this.to == null && revisions.size() == 10 || this.to != null && this.to.getNumber() > 0L && Intrinsics.areEqual((Object)this.to, (Object)HistoryConflictSideKt.access$getSvnRevision((VcsFileRevision)CollectionsKt.last((List)revisions))) ? (VcsFileRevision)revisions.remove(CollectionsKt.getLastIndex((List)revisions)) : null;
        FileHistoryPanelImpl panel2 = new FileHistoryPanelImpl((AbstractVcs)this.vcs, this.path, (VcsHistorySession)session, (VcsHistoryProvider)this.provider, new FileHistoryRefresherI(){

            public boolean isInRefresh() {
                return false;
            }

            public void refresh(boolean canUseCache) {
            }

            public void selectContent() {
            }
        }, true);
        panel2.setBottomRevisionForShowDiff(lastRevision);
        panel2.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        Disposer.register((Disposable)this, (Disposable)((Disposable)panel2));
        return (JPanel)panel2;
    }

    public void dispose() {
    }
}

