/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.treeConflict;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;

public final class ApplyPatchSaveToFileExecutor
implements ApplyPatchExecutor<TextFilePatchInProgress> {
    private static final Logger LOG = Logger.getInstance(ApplyPatchSaveToFileExecutor.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private final VirtualFile myNewPatchBase;

    public ApplyPatchSaveToFileExecutor(@NotNull Project project, @Nullable VirtualFile newPatchBase) {
        this.myProject = project;
        this.myNewPatchBase = newPatchBase;
    }

    public String getName() {
        return VcsBundle.message((String)"patch.creation.save.to.file.button", (Object[])new Object[0]);
    }

    public void apply(@NotNull List<? extends FilePatch> remaining, @NotNull MultiMap<VirtualFile, TextFilePatchInProgress> patchGroupsToApply, @Nullable LocalChangeList localList, @Nullable String fileName, @Nullable ThrowableComputable<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
        FileSaverDialog dialog = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(VcsBundle.message((String)"patch.creation.save.to.title", (Object[])new Object[0]), "", new String[0]), this.myProject);
        VirtualFileWrapper targetFile = dialog.save(this.myProject.getBaseDir(), SvnBundle.message("value.patch.file.name", new Object[0]));
        if (targetFile != null) {
            this.savePatch(patchGroupsToApply, targetFile);
        }
    }

    private void savePatch(@NotNull MultiMap<VirtualFile, TextFilePatchInProgress> patchGroups, @NotNull VirtualFileWrapper targetFile) {
        VirtualFile newPatchBase = (VirtualFile)ObjectUtils.notNull((Object)this.myNewPatchBase, (Object)this.myProject.getBaseDir());
        try {
            List<FilePatch> textPatches = ApplyPatchSaveToFileExecutor.toOnePatchGroup(patchGroups, newPatchBase);
            PatchWriter.writePatches((Project)this.myProject, (Path)targetFile.getFile().toPath(), (Path)newPatchBase.toNioPath(), textPatches, (CommitContext)new CommitContext());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{e.getMessage()}), (String)CommonBundle.getErrorTitle()), null, (Project)this.myProject);
        }
    }

    @NotNull
    public static List<FilePatch> toOnePatchGroup(@NotNull MultiMap<VirtualFile, TextFilePatchInProgress> patchGroups, @NotNull VirtualFile newPatchBase) throws IOException {
        ArrayList<FilePatch> result = new ArrayList<FilePatch>();
        for (Map.Entry entry : patchGroups.entrySet()) {
            VirtualFile oldPatchBase = (VirtualFile)entry.getKey();
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)oldPatchBase, (VirtualFile)newPatchBase, (char)'/');
            boolean toConvert = !StringUtil.isEmptyOrSpaces((String)relativePath) && !".".equals(relativePath);
            for (TextFilePatchInProgress patchInProgress : (Collection)entry.getValue()) {
                TextFilePatch patch = (TextFilePatch)patchInProgress.getPatch();
                if (toConvert) {
                    patch.setBeforeName(ApplyPatchSaveToFileExecutor.getNewBaseRelativePath(newPatchBase, oldPatchBase, patch.getBeforeName()));
                    patch.setAfterName(ApplyPatchSaveToFileExecutor.getNewBaseRelativePath(newPatchBase, oldPatchBase, patch.getAfterName()));
                }
                result.add((FilePatch)patch);
            }
        }
        return result;
    }

    @Nullable
    private static String getNewBaseRelativePath(@NotNull VirtualFile newBase, @NotNull VirtualFile oldBase, @Nullable String oldBaseRelativePath) throws IOException {
        return !StringUtil.isEmptyOrSpaces((String)oldBaseRelativePath) ? FileUtil.getRelativePath((String)newBase.getPath(), (String)ApplyPatchSaveToFileExecutor.getCanonicalPath(oldBase, oldBaseRelativePath), (char)'/') : oldBaseRelativePath;
    }

    @NotNull
    private static String getCanonicalPath(@NotNull VirtualFile base, @NotNull String relativePath) throws IOException {
        return FileUtil.toSystemIndependentName((String)new File(base.getPath(), relativePath).getCanonicalPath());
    }
}

