/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilterFilePathStrings;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.rollback.SuperfluousRemover;
import org.jetbrains.idea.svn.rollback.SvnRollbackEnvironment;
import org.jetbrains.idea.svn.rollback.UnversionedAndNotTouchedFilesGroupCollector;

public class ChangesChecker {
    @NotNull
    private final SuperfluousRemover myForAdds;
    @NotNull
    private final SuperfluousRemover myForDeletes;
    private final List<File> myForEdits;
    private final SvnChangeProvider myChangeProvider;
    @NotNull
    private final UnversionedAndNotTouchedFilesGroupCollector myCollector;
    private final List<SvnBindException> myExceptions;

    ChangesChecker(@NotNull SvnVcs vcs, @NotNull UnversionedAndNotTouchedFilesGroupCollector collector) {
        this.myChangeProvider = (SvnChangeProvider)vcs.getChangeProvider();
        this.myCollector = collector;
        this.myForAdds = new SuperfluousRemover(true);
        this.myForDeletes = new SuperfluousRemover(false);
        this.myForEdits = new ArrayList<File>();
        this.myExceptions = new ArrayList<SvnBindException>();
    }

    public void gather(List<? extends Change> changes) {
        TreeMap<String, File> renames = new TreeMap<String, File>();
        HashSet<String> alsoReverted = new HashSet<String>();
        HashMap<String, FilePath> files = new HashMap<String, FilePath>();
        for (Change change : changes) {
            String key;
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            String string = key = afterRevision == null ? null : FilePathsHelper.convertWithLastSeparator((FilePath)afterRevision.getFile());
            if (SvnRollbackEnvironment.isMoveRenameReplace(change)) {
                File beforeFile = beforeRevision.getFile().getIOFile();
                renames.put(key, beforeFile);
                files.put(key, afterRevision.getFile());
                this.myCollector.markRename(beforeFile, afterRevision.getFile().getIOFile());
                continue;
            }
            if (afterRevision == null) continue;
            alsoReverted.add(key);
        }
        if (!renames.isEmpty()) {
            ArrayList paths = new ArrayList(renames.keySet());
            if (paths.size() > 1) {
                FilterFilePathStrings.getInstance().doFilter(paths);
            }
            this.myCollector.setRenamesMap(renames);
            this.myCollector.setAlsoReverted(alsoReverted);
            for (String path : paths) {
                try {
                    this.myChangeProvider.getChanges((FilePath)files.get(path), true, (ChangelistBuilder)this.myCollector);
                }
                catch (SvnBindException e) {
                    this.myExceptions.add(e);
                }
            }
        }
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            boolean checked = this.myForAdds.accept(change);
            if (checked |= this.myForDeletes.accept(change)) continue;
            this.myForEdits.add(afterRevision.getFile().getIOFile());
        }
    }

    @NotNull
    public Collection<File> getForAdds() {
        return this.myForAdds.getParentPaths();
    }

    @NotNull
    public Collection<File> getForDeletes() {
        return this.myForDeletes.getParentPaths();
    }

    public List<SvnBindException> getExceptions() {
        return this.myExceptions;
    }

    @NotNull
    public List<File> getForEdits() {
        return this.myForEdits;
    }
}

