/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.revert;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.FileStatusResultParser;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.revert.RevertClient;

public class CmdRevertClient
extends BaseSvnClient
implements RevertClient {
    private static final String STATUS = "\\s*(.+?)\\s*";
    private static final String PATH = "\\s*'(.*?)'\\s*";
    private static final String OPTIONAL_COMMENT = "(.*)";
    private static final Pattern CHANGED_PATH = Pattern.compile("\\s*(.+?)\\s*\\s*'(.*?)'\\s*(.*)");

    @Override
    public void revert(@NotNull Collection<File> paths, @Nullable Depth depth, @Nullable ProgressTracker handler) throws VcsException {
        if (!ContainerUtil.isEmpty(paths)) {
            Command command = this.newCommand(SvnCommandName.revert);
            command.put(depth);
            command.setTargets(paths);
            Target target = Target.on(Objects.requireNonNull((File)ContainerUtil.getFirstItem(paths)));
            CommandExecutor executor = this.execute(this.myVcs, target, CommandUtil.getHomeDirectory(), command, null);
            FileStatusResultParser parser = new FileStatusResultParser(CHANGED_PATH, handler, new RevertStatusConvertor());
            parser.parse(executor.getOutput());
        }
    }

    private static class RevertStatusConvertor
    implements Convertor<Matcher, ProgressEvent> {
        @NonNls
        private static final String REVERTED_CODE = "Reverted";
        @NonNls
        private static final String FAILED_TO_REVERT_CODE = "Failed to revert";
        @NonNls
        private static final String SKIPPED_CODE = "Skipped";

        private RevertStatusConvertor() {
        }

        public ProgressEvent convert(@NotNull Matcher matcher) {
            String statusMessage = matcher.group(1);
            String path = matcher.group(2);
            return CmdRevertClient.createEvent(new File(path), RevertStatusConvertor.createAction(statusMessage));
        }

        @Nullable
        public static EventAction createAction(@NotNull String code) {
            EventAction result = null;
            if (REVERTED_CODE.equals(code)) {
                result = EventAction.REVERT;
            } else if (FAILED_TO_REVERT_CODE.equals(code)) {
                result = EventAction.FAILED_REVERT;
            } else if (SKIPPED_CODE.equals(code)) {
                result = EventAction.SKIP;
            }
            return result;
        }
    }
}

