/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.properties;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.properties.PropertiesMap;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class CmdPropertyClient
extends BaseSvnClient
implements PropertyClient {
    private static final Logger LOG = Logger.getInstance(CmdPropertyClient.class);

    @Override
    @Nullable
    public PropertyValue getProperty(@NotNull Target target, @NotNull String property, boolean revisionProperty, @Nullable Revision revision) throws SvnBindException {
        PropertyData data;
        block4: {
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(property);
            if (!revisionProperty) {
                CommandUtil.put(parameters, target);
                CommandUtil.put(parameters, revision);
            } else {
                this.assertFile(target);
                CommandUtil.put(parameters, target, false);
                parameters.add("--revprop");
                CommandUtil.put(parameters, this.resolveRevisionNumber(target.getFile(), revision));
            }
            parameters.add("--xml");
            data = null;
            try {
                CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.propget, parameters, null);
                data = this.parseSingleProperty(target, command);
            }
            catch (SvnBindException e) {
                if (CmdPropertyClient.isPropertyNotFoundError(e)) break block4;
                throw e;
            }
        }
        return data != null ? data.getValue() : null;
    }

    @Override
    public void getProperty(@NotNull Target target, @NotNull String property, @Nullable Revision revision, @Nullable Depth depth, @Nullable PropertyConsumer handler) throws SvnBindException {
        block2: {
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(property);
            this.fillListParameters(target, revision, depth, parameters, false);
            try {
                CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.propget, parameters, null);
                CmdPropertyClient.parseOutput(target, command, handler);
            }
            catch (SvnBindException e) {
                if (CmdPropertyClient.isPropertyNotFoundError(e)) break block2;
                throw e;
            }
        }
    }

    @Override
    public void list(@NotNull Target target, @Nullable Revision revision, @Nullable Depth depth, @Nullable PropertyConsumer handler) throws SvnBindException {
        ArrayList<String> parameters = new ArrayList<String>();
        this.fillListParameters(target, revision, depth, parameters, true);
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.proplist, parameters, null);
        CmdPropertyClient.parseOutput(target, command, handler);
    }

    @Override
    public void setProperty(@NotNull File file, @NotNull String property, @Nullable PropertyValue value, @Nullable Depth depth, boolean force) throws SvnBindException {
        this.runSetProperty(Target.on(file), property, null, depth, value, force);
    }

    @Override
    public void setProperties(@NotNull File file, @NotNull PropertiesMap properties) throws SvnBindException {
        PropertiesMap currentProperties = this.collectPropertiesToDelete(file);
        currentProperties.putAll(properties);
        for (Map.Entry<String, PropertyValue> entry : currentProperties.entrySet()) {
            this.setProperty(file, entry.getKey(), entry.getValue(), Depth.EMPTY, true);
        }
    }

    private static boolean isPropertyNotFoundError(@NotNull SvnBindException e) {
        return e.contains(ErrorCode.BASE) && e.contains(ErrorCode.PROPERTY_NOT_FOUND);
    }

    @NotNull
    private PropertiesMap collectPropertiesToDelete(@NotNull File file) throws SvnBindException {
        final PropertiesMap result = new PropertiesMap();
        this.list(Target.on(file), null, Depth.EMPTY, new PropertyConsumer(){

            @Override
            public void handleProperty(File path, PropertyData property) {
                result.put(property.getName(), null);
            }
        });
        return result;
    }

    @Override
    public void setRevisionProperty(@NotNull Target target, @NotNull String property, @NotNull Revision revision, @Nullable PropertyValue value, boolean force) throws SvnBindException {
        this.runSetProperty(target, property, revision, null, value, force);
    }

    private void runSetProperty(@NotNull Target target, @NotNull String property, @Nullable Revision revision, @Nullable Depth depth, @Nullable PropertyValue value, boolean force) throws SvnBindException {
        boolean isDelete = value == null;
        Command command = this.newCommand(isDelete ? SvnCommandName.propdel : SvnCommandName.propset);
        command.put(property);
        if (revision != null) {
            command.put("--revprop");
            command.put(revision);
        }
        if (!isDelete) {
            command.setPropertyValue(value);
            command.put("--force", force);
        }
        command.put(target);
        command.put(depth);
        this.execute(this.myVcs, target, null, command, null);
    }

    private void fillListParameters(@NotNull Target target, @Nullable Revision revision, @Nullable Depth depth, @NotNull List<String> parameters, boolean verbose) {
        CommandUtil.put(parameters, target);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, depth);
        parameters.add("--xml");
        CommandUtil.put(parameters, verbose, "--verbose");
    }

    @Nullable
    private PropertyData parseSingleProperty(Target target, @NotNull CommandExecutor command) throws SvnBindException {
        final PropertyData[] data = new PropertyData[1];
        PropertyConsumer handler = new PropertyConsumer(){

            @Override
            public void handleProperty(File path, PropertyData property) {
                data[0] = property;
            }

            @Override
            public void handleProperty(Url url, PropertyData property) {
                data[0] = property;
            }

            @Override
            public void handleProperty(long revision, PropertyData property) {
                data[0] = property;
            }
        };
        CmdPropertyClient.parseOutput(target, command, handler);
        return data[0];
    }

    private static void parseOutput(Target target, @NotNull CommandExecutor command, PropertyConsumer handler) throws SvnBindException {
        try {
            Properties properties = CommandUtil.parse(command.getOutput(), Properties.class);
            if (properties != null) {
                for (PropertiesTarget childInfo : properties.targets) {
                    Target childTarget = SvnUtil.append(target, childInfo.path);
                    for (Property property : childInfo.properties) {
                        CmdPropertyClient.invokeHandler(childTarget, CmdPropertyClient.create(property.name, property.value), handler);
                    }
                }
                if (properties.revisionProperties != null) {
                    for (Property property : properties.revisionProperties.properties) {
                        CmdPropertyClient.invokeHandler(properties.revisionProperties.revisionNumber(), CmdPropertyClient.create(property.name, property.value), handler);
                    }
                }
            }
        }
        catch (JAXBException e) {
            LOG.error("Could not parse properties. Command: " + command.getCommandText() + ", Warning: " + command.getErrorOutput(), new Attachment[]{new Attachment("output.xml", command.getOutput())});
            throw new SvnBindException(e);
        }
    }

    private static void invokeHandler(@NotNull Target target, @Nullable PropertyData data, @Nullable PropertyConsumer handler) throws SvnBindException {
        if (handler != null && data != null) {
            if (target.isFile()) {
                handler.handleProperty(target.getFile(), data);
            } else {
                handler.handleProperty(target.getUrl(), data);
            }
        }
    }

    private static void invokeHandler(long revision, @Nullable PropertyData data, @Nullable PropertyConsumer handler) throws SvnBindException {
        if (handler != null && data != null) {
            handler.handleProperty(revision, data);
        }
    }

    @Nullable
    private static PropertyData create(@NotNull String property, @Nullable String value) {
        PropertyData result = null;
        if (value != null) {
            result = new PropertyData(property, PropertyValue.create(value.trim()));
        }
        return result;
    }

    private Revision resolveRevisionNumber(@NotNull File path, @Nullable Revision revision) throws SvnBindException {
        long result;
        long l = result = revision != null ? revision.getNumber() : -1L;
        if (Revision.BASE.equals(revision)) {
            Info info2 = this.myVcs.getInfo(path, Revision.BASE);
            long l2 = result = info2 != null ? info2.getRevision().getNumber() : -1L;
        }
        if (result == -1L) {
            throw new SvnBindException(SvnBundle.message("error.could.not.determine.revision.number.for.file.and.revision", path, revision));
        }
        return Revision.of(result);
    }

    @XmlRootElement(name="properties")
    public static class Properties {
        @XmlElement(name="target")
        public List<PropertiesTarget> targets = new ArrayList<PropertiesTarget>();
        @XmlElement(name="revprops")
        public RevisionProperties revisionProperties;
    }

    public static class PropertiesTarget {
        @XmlAttribute(name="path")
        public String path;
        @XmlElement(name="property")
        public List<Property> properties = new ArrayList<Property>();
    }

    public static class Property {
        @XmlAttribute(name="name")
        public String name;
        @XmlValue
        public String value;
    }

    public static class RevisionProperties {
        @XmlAttribute(name="rev")
        public String revision;
        @XmlElement(name="property")
        public List<Property> properties = new ArrayList<Property>();

        public long revisionNumber() {
            return Long.parseLong(this.revision);
        }
    }
}

