/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListsListener;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.history.RootsAndBranches;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnMergeInfoRootPanelManual;
import org.jetbrains.idea.svn.mergeinfo.ListMergeStatus;
import org.jetbrains.idea.svn.mergeinfo.MergeCheckResult;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoCached;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public class MergeInfoHolder {
    @NotNull
    private final DecoratorManager myManager;
    @NotNull
    private final SvnMergeInfoCache myMergeInfoCache;
    @NotNull
    private final RootsAndBranches myMainPanel;
    @NotNull
    private final SvnMergeInfoRootPanelManual myPanel;
    @NotNull
    private final Map<Pair<WCInfo, Url>, MergeInfoCached> myCachedMap;

    public MergeInfoHolder(@NotNull Project project, @NotNull DecoratorManager manager, @NotNull RootsAndBranches mainPanel, @NotNull SvnMergeInfoRootPanelManual panel2) {
        this.myManager = manager;
        this.myMainPanel = mainPanel;
        this.myPanel = panel2;
        this.myMergeInfoCache = SvnMergeInfoCache.getInstance(project);
        this.myCachedMap = new HashMap<Pair<WCInfo, Url>, MergeInfoCached>();
    }

    @NotNull
    private Pair<WCInfo, Url> getCacheKey() {
        return Pair.create((Object)this.myPanel.getWcInfo(), (Object)this.myPanel.getBranch().getUrl());
    }

    @Nullable
    private MergeInfoCached getCurrentCache() {
        return this.myCachedMap.get(this.getCacheKey());
    }

    private boolean isEnabledAndConfigured(boolean ignoreEnabled) {
        return (ignoreEnabled || this.myMainPanel.isHighlightingOn() && this.myPanel.isEnabled()) && this.myPanel.getBranch() != null && this.myPanel.getLocalBranch() != null;
    }

    public boolean refreshEnabled(boolean ignoreEnabled) {
        return this.isEnabledAndConfigured(ignoreEnabled) && this.getCurrentCache() == null;
    }

    @NotNull
    public ListMergeStatus refresh(boolean ignoreEnabled) {
        CommittedChangeListsListener refresher = this.createRefresher(ignoreEnabled);
        if (refresher != null) {
            this.myManager.reportLoadedLists(refresher);
        }
        this.myManager.repaintTree();
        return ListMergeStatus.REFRESHING;
    }

    @Nullable
    public CommittedChangeListsListener createRefresher(boolean ignoreEnabled) {
        MyRefresher result = null;
        if (this.refreshEnabled(ignoreEnabled)) {
            MergeInfoCached state = this.myMergeInfoCache.getCachedState(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch());
            this.myCachedMap.put(this.getCacheKey(), state != null ? state.copy() : new MergeInfoCached());
            this.myMergeInfoCache.clear(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch());
            result = new MyRefresher();
        }
        return result;
    }

    @NotNull
    public ListMergeStatus check(CommittedChangeList list, boolean ignoreEnabled) {
        ListMergeStatus result;
        if (!this.isEnabledAndConfigured(ignoreEnabled) || !(list instanceof SvnChangeList)) {
            result = ListMergeStatus.ALIEN;
        } else {
            MergeInfoCached cachedState = this.getCurrentCache();
            MergeInfoCached state = this.myMergeInfoCache.getCachedState(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch());
            result = cachedState != null ? this.check(list, cachedState, true) : (state != null ? this.check(list, state, false) : this.refresh(ignoreEnabled));
        }
        return result;
    }

    @NotNull
    public ListMergeStatus check(@NotNull CommittedChangeList list, @NotNull MergeInfoCached state, boolean isCached) {
        MergeCheckResult mergeCheckResult = state.getMap().get(list.getNumber());
        ListMergeStatus result = state.copiedAfter(list) ? ListMergeStatus.COMMON : ListMergeStatus.from(mergeCheckResult);
        return (ListMergeStatus)((Object)ObjectUtils.notNull((Object)((Object)result), (Object)((Object)(isCached ? ListMergeStatus.REFRESHING : ListMergeStatus.ALIEN))));
    }

    public void updateMixedRevisionsForPanel() {
        this.myPanel.setMixedRevisions(this.myMergeInfoCache.isMixedRevisions(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch()));
    }

    private final class MyRefresher
    implements CommittedChangeListsListener {
        @NotNull
        private final WCInfoWithBranches myRefreshedRoot;
        private final WCInfoWithBranches.Branch myRefreshedBranch;
        private final String myBranchPath;

        private MyRefresher() {
            this.myRefreshedRoot = MergeInfoHolder.this.myPanel.getWcInfo();
            this.myRefreshedBranch = MergeInfoHolder.this.myPanel.getBranch();
            this.myBranchPath = MergeInfoHolder.this.myPanel.getLocalBranch();
        }

        public void onBeforeStartReport() {
        }

        public boolean report(@NotNull CommittedChangeList list) {
            if (list instanceof SvnChangeList) {
                MergeCheckResult checkState = MergeInfoHolder.this.myMergeInfoCache.getState(this.myRefreshedRoot, (SvnChangeList)list, this.myRefreshedBranch, this.myBranchPath);
                long number = list.getNumber();
                ApplicationManager.getApplication().invokeLater(() -> {
                    MergeInfoCached cachedState = MergeInfoHolder.this.myCachedMap.get(this.getCacheKey());
                    if (cachedState != null) {
                        cachedState.getMap().put(number, checkState);
                    }
                    MergeInfoHolder.this.myManager.repaintTree();
                });
            }
            return true;
        }

        public void onAfterEndReport() {
            ApplicationManager.getApplication().invokeLater(() -> {
                MergeInfoHolder.this.myCachedMap.remove(this.getCacheKey());
                MergeInfoHolder.this.updateMixedRevisionsForPanel();
                MergeInfoHolder.this.myManager.repaintTree();
            });
        }

        @NotNull
        private Pair<WCInfo, Url> getCacheKey() {
            return Pair.create((Object)this.myRefreshedRoot, (Object)this.myRefreshedBranch.getUrl());
        }
    }
}

