/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.IntersectingLocalChangesPanel;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.LocalChangesAction;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeContentsVariants;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.QuickMergeWayOptionsPanel;
import org.jetbrains.idea.svn.integrate.SelectMergeItemsResult;
import org.jetbrains.idea.svn.integrate.ToBeMergedDialog;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;

public class QuickMergeInteractionImpl
implements QuickMergeInteraction {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final Project myProject;

    public QuickMergeInteractionImpl(@NotNull MergeContext mergeContext) {
        this.myMergeContext = mergeContext;
        this.myProject = mergeContext.getProject();
    }

    @Override
    @NotNull
    public QuickMergeContentsVariants selectMergeVariant() {
        QuickMergeWayOptionsPanel panel2 = new QuickMergeWayOptionsPanel();
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.title(SvnBundle.message("dialog.title.select.merge.variant", new Object[0])).centerPanel((JComponent)panel2.getMainPanel()).removeAllActions();
        panel2.setWrapper(builder.getDialogWrapper());
        builder.show();
        return panel2.getVariant();
    }

    @Override
    public boolean shouldContinueSwitchedRootFound() {
        return this.prompt(SvnBundle.message("dialog.message.merge.with.switched.paths.in.working.copy", new Object[0]));
    }

    @Override
    public boolean shouldReintegrate(@NotNull Url targetUrl) {
        return this.prompt(XmlStringUtil.wrapInHtml((CharSequence)SvnBundle.message("dialog.message.merge.confirm.reintegrate", this.myMergeContext.getSourceUrl().toDecodedString(), targetUrl.toDecodedString())));
    }

    @Override
    @NotNull
    public SelectMergeItemsResult selectMergeItems(@NotNull List<SvnChangeList> lists, @NotNull MergeChecker mergeChecker, boolean allStatusesCalculated, boolean allListsLoaded) {
        ToBeMergedDialog dialog = new ToBeMergedDialog(this.myMergeContext, lists, mergeChecker, allStatusesCalculated, allListsLoaded);
        dialog.show();
        QuickMergeContentsVariants resultCode = QuickMergeInteractionImpl.toMergeVariant(dialog.getExitCode());
        List<SvnChangeList> selectedLists = resultCode == QuickMergeContentsVariants.select ? dialog.getSelected() : ContainerUtil.emptyList();
        return new SelectMergeItemsResult(resultCode, selectedLists);
    }

    @Override
    @NotNull
    public LocalChangesAction selectLocalChangesAction(boolean mergeAll) {
        String message;
        LocalChangesAction[] possibleResults;
        if (!mergeAll) {
            possibleResults = new LocalChangesAction[]{LocalChangesAction.shelve, LocalChangesAction.inspect, LocalChangesAction.continueMerge, LocalChangesAction.cancel};
            message = SvnBundle.message("dialog.message.merge.intersects.with.local.changes.prompt", new Object[0]);
        } else {
            possibleResults = new LocalChangesAction[]{LocalChangesAction.shelve, LocalChangesAction.continueMerge, LocalChangesAction.cancel};
            message = SvnBundle.message("dialog.message.merge.potentially.intersects.with.local.changes.prompt", new Object[0]);
        }
        int result = Messages.showDialog((String)message, (String)this.myMergeContext.getMergeTitle(), (String[])((String[])ContainerUtil.map2Array((Object[])possibleResults, String.class, (Function)Functions.TO_STRING())), (int)0, (Icon)Messages.getQuestionIcon());
        return result == -1 ? LocalChangesAction.cancel : possibleResults[result];
    }

    @Override
    public void showIntersectedLocalPaths(@NotNull List<FilePath> paths) {
        IntersectingLocalChangesPanel.showInVersionControlToolWindow(this.myProject, SvnBundle.message("tab.title.merge.local.changes.intersection", this.myMergeContext.getMergeTitle()), paths);
    }

    @Override
    public void showErrors(@NlsContexts.TabTitle @NotNull String message, @NotNull List<VcsException> exceptions) {
        AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(exceptions, message);
    }

    @Override
    public void showErrors(@NlsContexts.NotificationContent @NotNull String message, boolean isError) {
        VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)message, (MessageType)(isError ? MessageType.ERROR : MessageType.WARNING), (NamedRunnable[])new NamedRunnable[0]);
    }

    private boolean prompt(@NlsContexts.DialogMessage @NotNull String question) {
        return Messages.showOkCancelDialog((Project)this.myProject, (String)question, (String)this.myMergeContext.getMergeTitle(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    @NotNull
    private static QuickMergeContentsVariants toMergeVariant(int exitCode) {
        return switch (exitCode) {
            case 222 -> QuickMergeContentsVariants.all;
            case 0 -> QuickMergeContentsVariants.select;
            default -> QuickMergeContentsVariants.cancel;
        };
    }
}

