/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class MoreAction
extends DumbAwareAction
implements CustomComponentAction {
    protected final JLabel myLabel;
    private final JPanel myPanel = new JPanel();
    private boolean myEnabled;
    private boolean myVisible;
    private final JButton myLoadMoreBtn;

    protected MoreAction(@NlsContexts.Button @NotNull String name) {
        BoxLayout layout = new BoxLayout(this.myPanel, 0);
        this.myPanel.setLayout(layout);
        this.myLoadMoreBtn = new JButton(name);
        this.myLoadMoreBtn.setMargin((Insets)JBUI.insets((int)2));
        this.myLoadMoreBtn.addActionListener(__ -> this.perform());
        this.myPanel.add(this.myLoadMoreBtn);
        this.myLabel = new JLabel(CommonBundle.getLoadingTreeNodeText());
        this.myLabel.setForeground(NamedColorUtil.getInactiveTextColor());
        this.myLabel.setBorder((Border)JBUI.Borders.empty((int)1, (int)3, (int)1, (int)1));
        this.myPanel.add(this.myLabel);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        return this.myPanel;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
        this.myLoadMoreBtn.setVisible(this.myEnabled);
        this.myLabel.setVisible(!this.myEnabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(this.myEnabled);
        e.getPresentation().setVisible(this.myVisible);
    }

    public void setVisible(boolean b) {
        this.myVisible = b;
    }

    public abstract void perform();

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.perform();
    }
}

