/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.vcs.commit.CommitChangeListDialogWorkflow;
import com.intellij.vcs.commit.CommitSessionInfo;
import com.intellij.vcs.commit.Committer;
import com.intellij.vcs.commit.CommitterResultHandler;
import com.intellij.vcs.commit.ShowNotificationCommitResultHandler;
import com.intellij.vcs.commit.VcsCommitter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.integrate.AlienCommitter;
import org.jetbrains.idea.svn.integrate.AlienLocalChangeList;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/svn/integrate/AlienCommitWorkflow;", "Lcom/intellij/vcs/commit/CommitChangeListDialogWorkflow;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "changeListName", "", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "commitMessage", "(Lcom/intellij/openapi/vcs/AbstractVcs;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "changeList", "Lorg/jetbrains/idea/svn/integrate/AlienLocalChangeList;", "getChangeList", "()Lorg/jetbrains/idea/svn/integrate/AlienLocalChangeList;", "getChanges", "()Ljava/util/List;", "isDefaultCommitEnabled", "", "()Z", "isPartialCommitEnabled", "getVcs", "()Lcom/intellij/openapi/vcs/AbstractVcs;", "canExecute", "sessionInfo", "Lcom/intellij/vcs/commit/CommitSessionInfo;", "", "performCommit", "", "intellij.vcs.svn"})
public final class AlienCommitWorkflow
extends CommitChangeListDialogWorkflow {
    @NotNull
    private final AbstractVcs vcs;
    @NotNull
    private final List<Change> changes;
    @NotNull
    private final AlienLocalChangeList changeList;
    private final boolean isDefaultCommitEnabled;
    private final boolean isPartialCommitEnabled;

    public AlienCommitWorkflow(@NotNull AbstractVcs vcs, @Nls @NotNull String changeListName, @NotNull List<? extends Change> changes, @Nullable String commitMessage) {
        super(vcs.getProject(), commitMessage);
        this.vcs = vcs;
        this.changes = changes;
        this.updateVcses(SetsKt.setOf((Object)this.vcs));
        this.changeList = new AlienLocalChangeList(this.changes, changeListName);
        this.isDefaultCommitEnabled = true;
    }

    @NotNull
    public final AbstractVcs getVcs() {
        return this.vcs;
    }

    @NotNull
    public final List<Change> getChanges() {
        return this.changes;
    }

    @NotNull
    public final AlienLocalChangeList getChangeList() {
        return this.changeList;
    }

    public boolean isDefaultCommitEnabled() {
        return this.isDefaultCommitEnabled;
    }

    public boolean isPartialCommitEnabled() {
        return this.isPartialCommitEnabled;
    }

    public boolean canExecute(@NotNull CommitSessionInfo sessionInfo, @NotNull Collection<? extends Change> changes) {
        return sessionInfo.isVcsCommit();
    }

    protected void performCommit(@NotNull CommitSessionInfo sessionInfo) {
        AlienCommitter committer = new AlienCommitter(this.vcs, this.getCommitState().getChanges(), this.getCommitState().getCommitMessage(), this.getCommitContext());
        this.addCommonResultHandlers(sessionInfo, (Committer)committer);
        committer.addResultHandler((CommitterResultHandler)new ShowNotificationCommitResultHandler((VcsCommitter)committer));
        committer.runCommit(CommitChangeListDialog.DIALOG_TITLE, false);
    }
}

