/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.ignore;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.ignore.FileGroupInfo;
import org.jetbrains.idea.svn.ignore.SvnPropertyService;

public class IgnoreGroupHelperAction {
    private static final Key<Optional<IgnoreGroupHelperAction>> KEY = Key.create((String)"IgnoreGroupHelperAction");
    private final FileGroupInfo myFileGroupInfo = new FileGroupInfo();
    private boolean myAllCanBeIgnored = true;
    private boolean myAllAreIgnored = true;
    private final Ref<Boolean> myIgnoreFilesOk = new Ref((Object)Boolean.FALSE);
    private final Ref<Boolean> myIgnoreExtensionOk = new Ref((Object)Boolean.FALSE);

    private IgnoreGroupHelperAction() {
    }

    @Nullable
    public static IgnoreGroupHelperAction createFor(@NotNull AnActionEvent e) {
        UpdateSession session = e.getUpdateSession();
        Optional helper = (Optional)session.sharedData(KEY, () -> IgnoreGroupHelperAction.tryCreateFor(e));
        return helper.orElse(null);
    }

    @NotNull
    private static Optional<IgnoreGroupHelperAction> tryCreateFor(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        SvnVcs vcs = project != null ? SvnVcs.getInstance(project) : null;
        Object[] files = IgnoreGroupHelperAction.getSelectedFiles(e);
        if (project == null || vcs == null || ArrayUtil.isEmpty((Object[])files)) {
            return Optional.empty();
        }
        IgnoreGroupHelperAction helper = new IgnoreGroupHelperAction();
        if (!helper.checkEnabled(vcs, (VirtualFile[])files)) {
            return Optional.empty();
        }
        helper.checkIgnoreProperty(vcs);
        return Optional.of(helper);
    }

    public static VirtualFile @Nullable [] getSelectedFiles(@NotNull AnActionEvent e) {
        Iterable exactlySelectedFiles;
        if (e.getPlace().equals("ChangesViewPopup") && (exactlySelectedFiles = (Iterable)e.getData(ChangesListView.EXACTLY_SELECTED_FILES_DATA_KEY)) != null) {
            return (VirtualFile[])JBIterable.from((Iterable)exactlySelectedFiles).toList().toArray(VirtualFile[]::new);
        }
        return (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
    }

    private boolean checkEnabled(@NotNull SvnVcs vcs, VirtualFile @NotNull [] files) {
        return ProjectLevelVcsManager.getInstance((Project)vcs.getProject()).checkAllFilesAreUnder((AbstractVcs)vcs, files) && ContainerUtil.and((Object[])files, file -> this.isEnabled(vcs, (VirtualFile)file));
    }

    private void checkIgnoreProperty(@NotNull SvnVcs vcs) {
        if (this.myAllAreIgnored) {
            SvnPropertyService.doCheckIgnoreProperty(vcs, null, this.myFileGroupInfo, this.myFileGroupInfo.getExtensionMask(), this.myIgnoreFilesOk, this.myIgnoreExtensionOk);
        }
    }

    private boolean isEnabledImpl(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        VirtualFile parent;
        if (IgnoreGroupHelperAction.isIgnored(vcs, file)) {
            this.myAllCanBeIgnored = false;
            return this.myAllAreIgnored;
        }
        if (IgnoreGroupHelperAction.isUnversioned(vcs, file) && (parent = file.getParent()) != null && SvnStatusUtil.isUnderControl(vcs, parent)) {
            this.myAllAreIgnored = false;
            return this.myAllCanBeIgnored;
        }
        this.myAllCanBeIgnored = false;
        this.myAllAreIgnored = false;
        return false;
    }

    private boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        boolean result = this.isEnabledImpl(vcs, file);
        if (result) {
            this.myFileGroupInfo.onFileEnabled(file);
        }
        return result;
    }

    public boolean allCanBeIgnored() {
        return this.myAllCanBeIgnored;
    }

    public boolean allAreIgnored() {
        return this.myAllAreIgnored;
    }

    @NotNull
    public FileGroupInfo getFileGroupInfo() {
        return this.myFileGroupInfo;
    }

    public boolean areIgnoreFilesOk() {
        return this.myAllAreIgnored && Boolean.TRUE.equals(this.myIgnoreFilesOk.get());
    }

    public boolean areIgnoreExtensionOk() {
        return this.myAllAreIgnored && Boolean.TRUE.equals(this.myIgnoreExtensionOk.get());
    }

    public static boolean isIgnored(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        return SvnStatusUtil.isIgnoredInAnySense(vcs.getProject(), file);
    }

    public static boolean isUnversioned(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        VirtualFile parent;
        return ChangeListManager.getInstance((Project)vcs.getProject()).isUnversioned(file) && (parent = file.getParent()) != null && SvnStatusUtil.isUnderControl(vcs, parent);
    }
}

