/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.jetbrains.idea.svn.history.SvnMergeSourceDetails;

public class MergeSourceDetailsAction
extends AnAction
implements DumbAware {
    public MergeSourceDetailsAction() {
        super(SvnBundle.messagePointer("action.Subversion.ShowMergeSourceDetails.text", new Object[0]), Presentation.NULL_STRING, AllIcons.Vcs.Branch);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(this.enabled(e));
    }

    public void registerSelf(JComponent comp) {
        this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(77, 10)), comp);
    }

    private boolean enabled(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        VirtualFile revisionVirtualFile = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        if (revisionVirtualFile == null) {
            return false;
        }
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (revision == null) {
            return false;
        }
        if (!(revision instanceof SvnFileRevision)) {
            return false;
        }
        return !((SvnFileRevision)revision).getMergeSources().isEmpty();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (!this.enabled(e)) {
            return;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        VirtualFile revisionVirtualFile = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        SvnMergeSourceDetails.showMe(project, (SvnFileRevision)revision, revisionVirtualFile);
    }
}

