/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.difftool;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProvider;
import com.intellij.util.ThreeState;
import com.intellij.vcsUtil.UIVcsUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ConflictedSvnChange;
import org.jetbrains.idea.svn.SvnBundle;

public class SvnPhantomChangeDiffRequestProvider
implements ChangeDiffRequestProvider {
    @NotNull
    public ThreeState isEquals(@NotNull Change change1, @NotNull Change change2) {
        return ThreeState.UNSURE;
    }

    public boolean canCreate(@Nullable Project project, @NotNull Change change) {
        return change instanceof ConflictedSvnChange && ((ConflictedSvnChange)change).isPhantom();
    }

    @NotNull
    public DiffRequest process(@NotNull ChangeDiffRequestProducer presentable, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        indicator.checkCanceled();
        return new SvnPhantomDiffRequest(presentable.getChange());
    }

    public static class SvnPhantomDiffRequest
    extends DiffRequest {
        @NotNull
        private final Change myChange;

        public SvnPhantomDiffRequest(@NotNull Change change) {
            this.myChange = change;
        }

        @Nullable
        public String getTitle() {
            return ChangeDiffRequestProducer.getRequestTitle((Change)this.myChange);
        }
    }

    public static class SvnPhantomDiffTool
    implements FrameDiffTool {
        @NotNull
        public String getName() {
            return SvnBundle.message("svn.phantom.changes.viewer", new Object[0]);
        }

        public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request) {
            return request instanceof SvnPhantomDiffRequest;
        }

        @NotNull
        public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
            return new FrameDiffTool.DiffViewer(){

                @NotNull
                public JComponent getComponent() {
                    return UIVcsUtil.infoPanel((String)SvnBundle.message("label.svn.phantom.change", new Object[0]), (String)SvnBundle.message("text.svn.phantom.change", new Object[0]));
                }

                @Nullable
                public JComponent getPreferredFocusedComponent() {
                    return null;
                }

                @NotNull
                public FrameDiffTool.ToolbarComponents init() {
                    return new FrameDiffTool.ToolbarComponents();
                }

                public void dispose() {
                }
            };
        }
    }
}

