/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.diff.DirectoryWithBranchComparer;
import org.jetbrains.idea.svn.diff.ElementWithBranchComparer;
import org.jetbrains.idea.svn.diff.FileWithBranchComparer;

public class CompareWithBranchAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        SelectBranchPopup.show(project, file, (p, configuration, url, revision) -> {
            ElementWithBranchComparer comparer = file.isDirectory() ? new DirectoryWithBranchComparer(project, file, url, revision) : new FileWithBranchComparer(project, file, url, revision);
            comparer.run();
        }, SvnBundle.message("compare.with.branch.popup.title", new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        e.getPresentation().setEnabled(project != null && file != null && VcsUtil.isFileForVcs((VirtualFile)file, (Project)project, (AbstractVcs)SvnVcs.getInstance(project)) && AbstractVcs.fileInVcsByFileStatus((Project)project, (VirtualFile)file));
    }
}

