/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.openapi.vcs.VcsException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;

public abstract class Loader {
    @NotNull
    protected final SvnRepositoryCache myCache;

    protected Loader(@NotNull SvnRepositoryCache cache) {
        this.myCache = cache;
    }

    public abstract void load(@NotNull RepositoryTreeNode var1, @NotNull Expander var2);

    @NotNull
    protected abstract NodeLoadState getNodeLoadState();

    protected void refreshNodeError(@NotNull RepositoryTreeNode node, @NotNull VcsException error) {
        RepositoryTreeNode existingNode = Loader.findExistingNode(node);
        if (existingNode != null) {
            existingNode.setErrorNode(error.getMessage());
        }
    }

    protected void refreshNode(@NotNull RepositoryTreeNode node, @NotNull List<DirectoryEntry> data, @NotNull Expander expander) {
        RepositoryTreeNode existingNode = Loader.findExistingNode(node);
        if (existingNode != null) {
            expander.onBeforeRefresh(existingNode);
            existingNode.setChildren(data, this.getNodeLoadState());
            expander.onAfterRefresh(existingNode);
        }
    }

    @Nullable
    private static RepositoryTreeNode findExistingNode(@NotNull RepositoryTreeNode node) {
        RepositoryTreeNode result = null;
        if (!node.isDisposed()) {
            result = node.getNodeWithSamePathUnderModelRoot();
        }
        return result == null || result.isDisposed() ? null : result;
    }
}

