/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.util.NotNullFunction;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browser.AbstractOpeningExpander;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;

public class OpeningExpander
extends AbstractOpeningExpander {
    private final List<Url> pathElements = new LinkedList<Url>();
    private final Url myLongest;

    public OpeningExpander(TreeNode[] path, RepositoryBrowserComponent browser, RepositoryTreeNode selectionPath) {
        super(browser, selectionPath.getURL());
        for (TreeNode aPath : path) {
            RepositoryTreeNode node = (RepositoryTreeNode)aPath;
            this.pathElements.add(node.getURL());
        }
        this.myLongest = this.pathElements.get(this.pathElements.size() - 1);
    }

    @Override
    protected AbstractOpeningExpander.ExpandVariants expandNode(@NotNull Url url) {
        if (this.pathElements.contains(url)) {
            if (this.myLongest.equals(url)) {
                return AbstractOpeningExpander.ExpandVariants.EXPAND_AND_EXIT;
            }
            return AbstractOpeningExpander.ExpandVariants.EXPAND_CONTINUE;
        }
        return AbstractOpeningExpander.ExpandVariants.DO_NOTHING;
    }

    @Override
    protected boolean checkChild(@NotNull Url childUrl) {
        return this.pathElements.contains(childUrl);
    }

    public static class Factory
    implements NotNullFunction<RepositoryBrowserComponent, Expander> {
        private final TreeNode[] myPath;
        private final RepositoryTreeNode mySelectionPath;

        public Factory(TreeNode[] path, RepositoryTreeNode selectionPath) {
            this.myPath = path;
            this.mySelectionPath = selectionPath;
        }

        @NotNull
        public Expander fun(RepositoryBrowserComponent repositoryBrowserComponent) {
            return new OpeningExpander(this.myPath, repositoryBrowserComponent, this.mySelectionPath);
        }
    }
}

