/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.DynamicBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class SetPropertyDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(SetPropertyDialog.class);
    @NlsSafe
    @Nullable
    private final String myPropertyName;
    private final File[] myFiles;
    private JComboBox<String> myPropertyNameBox;
    private JRadioButton mySetPropertyButton;
    private JTextArea myValueText;
    private JRadioButton myDeletePropertyButton;
    private JCheckBox myRecursiveButton;
    private final boolean myIsRecursionAllowed;
    private final SvnVcs myVCS;
    @NonNls
    private static final String HELP_ID = "vcs.subversion.property";
    private JPanel myMainPanel;

    public SetPropertyDialog(Project project, File[] files, @NlsSafe @Nullable String name, boolean allowRecursion) {
        super(project, true);
        this.myFiles = files;
        this.myPropertyName = name;
        this.myIsRecursionAllowed = allowRecursion;
        this.$$$setupUI$$$();
        this.myVCS = SvnVcs.getInstance(project);
        this.setResizable(true);
        this.setTitle(SvnBundle.message("dialog.title.set.property", new Object[0]));
        this.getHelpAction().setEnabled(true);
        this.init();
    }

    protected String getHelpId() {
        return HELP_ID;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPropertyNameBox;
    }

    public String getPropertyName() {
        return (String)this.myPropertyNameBox.getEditor().getItem();
    }

    public String getPropertyValue() {
        if (this.myDeletePropertyButton.isSelected()) {
            return null;
        }
        return this.myValueText.getText();
    }

    public boolean isRecursive() {
        return this.myRecursiveButton.isSelected();
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    protected String getDimensionServiceKey() {
        return "svn.propertyDialog";
    }

    protected void init() {
        super.init();
        if (this.myPropertyName != null) {
            this.updatePropertyValue(this.myPropertyName);
        } else {
            this.myPropertyNameBox.getEditor().setItem("");
        }
        this.myPropertyNameBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                String name = this.getPropertyName();
                this.updatePropertyValue(name);
                this.getOKAction().setEnabled(name != null && !name.trim().isEmpty());
            }
        });
        Component editor = this.myPropertyNameBox.getEditor().getEditorComponent();
        if (editor instanceof JTextField) {
            JTextField jTextField = (JTextField)editor;
            jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    String name = SetPropertyDialog.this.getPropertyName();
                    SetPropertyDialog.this.updatePropertyValue(name);
                    SetPropertyDialog.this.getOKAction().setEnabled(name != null && !name.trim().isEmpty());
                }
            });
        }
        this.getOKAction().setEnabled(this.myPropertyName != null && !this.myPropertyName.trim().isEmpty());
    }

    private void updatePropertyValue(String name) {
        PropertyValue property;
        if (this.myFiles.length != 1) {
            return;
        }
        File file = this.myFiles[0];
        PropertyValue propertyValue = property = !StringUtil.isEmpty((String)name) ? this.getProperty(file, name) : null;
        if (property != null) {
            this.myValueText.setText(property.toString());
            this.myValueText.selectAll();
        } else {
            this.myValueText.setText("");
        }
    }

    @Nullable
    private PropertyValue getProperty(@NotNull File file, @NotNull String name) {
        PropertyValue result;
        try {
            PropertyClient client = this.myVCS.getFactory(file).createPropertyClient();
            result = client.getProperty(Target.on(file, Revision.WORKING), name, false, Revision.WORKING);
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
            result = null;
        }
        return result;
    }

    protected JComponent createCenterPanel() {
        for (String name : this.getPropertyNames(this.myFiles)) {
            this.myPropertyNameBox.addItem(name);
        }
        if (this.myPropertyName != null) {
            this.myPropertyNameBox.getEditor().setItem(this.myPropertyName);
            this.myPropertyNameBox.getEditor().selectAll();
        }
        this.mySetPropertyButton.addChangeListener(e -> {
            if (this.mySetPropertyButton.isSelected()) {
                this.myValueText.setEnabled(true);
            } else {
                this.myValueText.setEnabled(false);
            }
        });
        this.myRecursiveButton.setEnabled(this.myIsRecursionAllowed);
        return this.myMainPanel;
    }

    private @NotNull Collection<@NlsSafe String> getPropertyNames(File[] files) {
        final TreeSet<String> names = new TreeSet<String>();
        if (files.length == 1) {
            File file = files[0];
            try {
                PropertyConsumer handler = new PropertyConsumer(){

                    @Override
                    public void handleProperty(File path, PropertyData property) {
                        names.add(property.getName());
                    }
                };
                PropertyClient client = this.myVCS.getFactory(file).createPropertyClient();
                client.list(Target.on(file, Revision.WORKING), Revision.WORKING, Depth.EMPTY, handler);
            }
            catch (SvnBindException e) {
                LOG.info((Throwable)((Object)e));
            }
        }
        ContainerUtil.addAll(names, (Object[])new String[]{"svn:eol-style", "svn:keywords", "svn:needs-lock", "svn:mime-type", "svn:executable", "svn:ignore", "svn:externals"});
        return names;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JTextArea jTextArea;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/SvnBundle", SetPropertyDialog.class).getString("label.set.property.property.name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JComboBox jComboBox = new JComboBox();
        this.myPropertyNameBox = jComboBox;
        jComboBox.setEditable(true);
        jComboBox.setRequestFocusEnabled(false);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        jPanel.add(jComboBox, gridBagConstraints2);
        this.mySetPropertyButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/SvnBundle", SetPropertyDialog.class).getString("radio.set.property.set.property.value"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jRadioButton2, gridBagConstraints3);
        JBScrollPane jBScrollPane = new JBScrollPane();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jBScrollPane, gridBagConstraints4);
        this.myValueText = jTextArea = new JTextArea();
        jTextArea.setColumns(25);
        jTextArea.setRows(7);
        jTextArea.setText("");
        jBScrollPane.setViewportView(jTextArea);
        this.myDeletePropertyButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/SvnBundle", SetPropertyDialog.class).getString("radio.set.property.delete.property"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 3;
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jRadioButton, gridBagConstraints5);
        JSeparator jSeparator = new JSeparator();
        Font font = UIManager.getFont("TextPane.font");
        if (font != null) {
            jSeparator.setFont(font);
        }
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 4;
        gridBagConstraints6.gridwidth = 2;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jSeparator, gridBagConstraints6);
        this.myRecursiveButton = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/SvnBundle", SetPropertyDialog.class).getString("checkbox.set.property.update.properties.recursively"));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 5;
        gridBagConstraints7.gridwidth = 2;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jCheckBox, gridBagConstraints7);
        jLabel.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

