/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.OrderPanel;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;

public class SelectFilesDialog
extends DialogWrapper
implements ActionListener {
    @NotNull
    private final SortedSet<String> myPaths;
    private FilesList myFilesList;
    private JButton mySelectAllButton;
    private JButton myDeselectAllButton;

    public SelectFilesDialog(@NotNull Project project, @NotNull SortedSet<String> paths) {
        super(project, true);
        this.myPaths = paths;
        this.setOKButtonText(SvnBundle.message("action.name.mark.resolved", new Object[0]));
        this.setTitle(SvnBundle.message("dialog.title.mark.resolved", new Object[0]));
        this.setResizable(true);
        this.getHelpAction().setEnabled(true);
        this.init();
    }

    @NotNull
    protected String getHelpId() {
        return "vcs.subversion.resolve";
    }

    protected void init() {
        super.init();
        this.mySelectAllButton.addActionListener(this);
        this.myDeselectAllButton.addActionListener(this);
    }

    protected String getDimensionServiceKey() {
        return "svn.selectFilesDialog";
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFilesList;
    }

    public boolean isOKActionEnabled() {
        return !this.getSelectedPaths().isEmpty();
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(5, 5));
        JLabel label = new JLabel(SvnBundle.message("label.select.files.and.directories.to.mark.resolved", new Object[0]));
        panel2.add((Component)label, "North");
        this.myFilesList = new FilesList(this.myPaths);
        int height = this.myFilesList.getFontMetrics(this.myFilesList.getFont()).getHeight();
        this.myFilesList.setPreferredSize(new Dimension(this.myFilesList.getPreferredSize().width, height * 7));
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myFilesList)), "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout(0));
        this.mySelectAllButton = new JButton(SvnBundle.message("button.text.select.all", new Object[0]));
        this.myDeselectAllButton = new JButton(SvnBundle.message("button.text.deselect.all", new Object[0]));
        buttonsPanel.add(this.mySelectAllButton);
        buttonsPanel.add(this.myDeselectAllButton);
        panel2.add((Component)buttonsPanel, "South");
        return panel2;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (String file : this.myPaths) {
            this.myFilesList.setChecked(file, e.getSource() == this.mySelectAllButton);
        }
        this.myFilesList.clear();
        this.myFilesList.init();
        this.setOKActionEnabled(this.isOKActionEnabled());
    }

    @NotNull
    public SortedSet<String> getSelectedPaths() {
        return this.myFilesList.getSelectedPaths();
    }

    private class FilesList
    extends OrderPanel<String> {
        private final Map<String, Boolean> mySelectedFiles;

        private FilesList(SortedSet<String> paths) {
            super(String.class);
            this.mySelectedFiles = new TreeMap<String, Boolean>();
            for (String path : paths) {
                this.mySelectedFiles.put(path, Boolean.TRUE);
            }
            this.init();
        }

        public boolean isChecked(@NotNull String entry) {
            return this.isChecked(this.mySelectedFiles.get(entry));
        }

        public void setChecked(@NotNull String entry, boolean checked) {
            this.mySelectedFiles.put(entry, checked);
            SelectFilesDialog.this.getOKAction().setEnabled(SelectFilesDialog.this.isOKActionEnabled());
        }

        private void init() {
            this.addAll(this.mySelectedFiles.keySet());
        }

        @NotNull
        private SortedSet<String> getSelectedPaths() {
            TreeSet<String> selected = new TreeSet<String>();
            for (Map.Entry<String, Boolean> entry : this.mySelectedFiles.entrySet()) {
                if (!this.isChecked(entry.getValue())) continue;
                selected.add(entry.getKey());
            }
            return Collections.unmodifiableSortedSet(selected);
        }

        private boolean isChecked(@Nullable Boolean value) {
            return Boolean.TRUE.equals(value);
        }
    }
}

