/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserDialog;

public class SelectCreateExternalTargetDialog
extends RepositoryBrowserDialog {
    private String mySelectedURL;
    private boolean myCheckout;
    private JTextField myFolderName;
    private boolean myFollowRemoteTarget;
    private final Set<String> myUsedNames;

    public SelectCreateExternalTargetDialog(Project project, VirtualFile below) {
        super(project, true, SvnBundle.message("label.point.to.repository.location", new Object[0]));
        VirtualFile[] children = below.getChildren();
        this.myUsedNames = new HashSet<String>();
        int maxCnt = 1000;
        for (VirtualFile child : children) {
            this.myUsedNames.add(child.getName());
            if (--maxCnt <= 0) break;
        }
    }

    protected void init() {
        super.init();
        this.myFollowRemoteTarget = true;
        this.setTitle(SvnBundle.message("dialog.title.select.target.for.external", new Object[0]));
        this.setOKButtonText(SvnBundle.message("button.select", new Object[0]));
        this.getRepositoryBrowser().addChangeListener(e -> {
            if (this.getOKAction() != null) {
                String selectedURL = this.getRepositoryBrowser().getSelectedURL();
                if (this.myFollowRemoteTarget && selectedURL != null) {
                    this.myFolderName.setText(Url.tail(selectedURL));
                }
                this.checkEnabled();
            }
        });
        this.getOKAction().setEnabled(this.getRepositoryBrowser().getSelectedURL() != null);
    }

    private void checkEnabled() {
        boolean enabled;
        String selectedURL = this.getRepositoryBrowser().getSelectedURL();
        String text = this.myFolderName.getText();
        boolean contains = this.myUsedNames.contains(text);
        boolean bl = enabled = selectedURL != null && !StringUtil.isEmptyOrSpaces((String)text) && !contains;
        if (contains) {
            this.setErrorText(SvnBundle.message("dialog.message.target.file.already.exists", new Object[0]), this.myFolderName);
        } else {
            this.setErrorText(null);
        }
        this.getOKAction().setEnabled(enabled);
    }

    @Override
    protected Action @NotNull [] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    protected void doOKAction() {
        this.mySelectedURL = this.getRepositoryBrowser().getSelectedURL();
        super.doOKAction();
    }

    @Override
    public String getSelectedURL() {
        return this.mySelectedURL;
    }

    @Override
    protected JPopupMenu createPopup(boolean toolWindow) {
        DefaultActionGroup group = new DefaultActionGroup();
        DefaultActionGroup newGroup = DefaultActionGroup.createPopupGroup((Supplier)ActionsBundle.messagePointer((String)"group.NewGroup.text", (Object[])new Object[0]));
        RepositoryBrowserComponent browser = this.getRepositoryBrowser();
        newGroup.add((AnAction)new RepositoryBrowserDialog.AddLocationAction(browser));
        newGroup.add((AnAction)new RepositoryBrowserDialog.MkDirAction(browser));
        group.add((AnAction)newGroup);
        group.addSeparator();
        group.add((AnAction)new RepositoryBrowserDialog.RefreshAction(browser));
        group.add((AnAction)new RepositoryBrowserDialog.DiscardLocationAction(browser));
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("", (ActionGroup)group);
        return menu.getComponent();
    }

    @Override
    public JComponent createCenterPanel() {
        JComponent repositoryPanel = super.createCenterPanel();
        JPanel wrapper = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, (Insets)JBUI.insets((int)1), 0, 0);
        gb.weightx = 1.0;
        gb.weighty = 1.0;
        gb.gridwidth = 2;
        wrapper.add((Component)repositoryPanel, gb);
        ++gb.gridy;
        gb.fill = 0;
        gb.weightx = 0.0;
        gb.weighty = 0.0;
        gb.gridwidth = 1;
        this.myFolderName = new JTextField();
        gb.insets.top = 5;
        gb.anchor = 17;
        wrapper.add((Component)new JBLabel(SvnBundle.message("label.local.target", new Object[0])), gb);
        ++gb.gridx;
        gb.weightx = 1.0;
        gb.fill = 2;
        wrapper.add((Component)this.myFolderName, gb);
        gb.insets.top = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.gridx = 0;
        ++gb.gridy;
        this.myFolderName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SelectCreateExternalTargetDialog.this.myFollowRemoteTarget = false;
                SelectCreateExternalTargetDialog.this.myFolderName.removeFocusListener(this);
            }
        });
        this.myFolderName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SelectCreateExternalTargetDialog.this.checkEnabled();
            }
        });
        this.myFolderName.addInputMethodListener(new InputMethodListener(){

            @Override
            public void inputMethodTextChanged(InputMethodEvent event) {
                SelectCreateExternalTargetDialog.this.checkEnabled();
            }

            @Override
            public void caretPositionChanged(InputMethodEvent event) {
            }
        });
        JBCheckBox checkout = new JBCheckBox(SvnBundle.message("checkbox.checkout", new Object[0]));
        checkout.addActionListener(e -> {
            this.myCheckout = checkout.isSelected();
        });
        wrapper.add((Component)checkout, gb);
        return wrapper;
    }

    public boolean isCheckout() {
        return this.myCheckout;
    }

    public String getLocalTarget() {
        return this.myFolderName.getText();
    }
}

