/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;

public class SSLCredentialsDialog
extends DialogWrapper {
    private JPanel myPanel;
    private TextFieldWithBrowseButton myCertificatePath;
    private JPasswordField myCertificatePassword;
    private JCheckBox mySaveAuth;

    public SSLCredentialsDialog(Project project, String authRealm, boolean authSaveAllowed) {
        super(project, true);
        this.setResizable(true);
        this.initUI(authRealm, authSaveAllowed);
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "svn.sslCredentialsDialog";
    }

    protected Action @NotNull [] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    private void initUI(String authRealm, boolean authSaveAllowed) {
        this.myPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)1), 0, 0);
        gb.fill = 2;
        gb.gridwidth = 2;
        gb.weightx = 0.0;
        JLabel label = new JLabel(SvnBundle.message("label.auth.authentication.realm", authRealm));
        this.myPanel.add((Component)label, gb);
        ++gb.gridy;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        JLabel certificatePath = new JLabel(SvnBundle.message("label.ssl.certificate.path", new Object[0]));
        this.myPanel.add((Component)certificatePath, gb);
        this.myCertificatePath = new TextFieldWithBrowseButton();
        this.myCertificatePath.addBrowseFolderListener(SvnBundle.message("dialog.edit.http.proxies.settings.dialog.select.ssl.client.certificate.path.title", new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        gb.weightx = 1.0;
        ++gb.gridx;
        this.myPanel.add((Component)this.myCertificatePath, gb);
        gb.gridx = 0;
        gb.weightx = 0.0;
        ++gb.gridy;
        JLabel certificatePassword = new JLabel(SvnBundle.message("label.ssl.certificate.password", new Object[0]));
        this.myPanel.add((Component)certificatePassword, gb);
        ++gb.gridx;
        gb.weightx = 1.0;
        this.myCertificatePassword = new JPasswordField();
        this.myPanel.add((Component)this.myCertificatePassword, gb);
        gb.gridx = 0;
        ++gb.gridy;
        gb.weightx = 0.0;
        this.mySaveAuth = new JCheckBox(SvnBundle.message("checkbox.ssl.keep.for.current.session", new Object[0]), authSaveAllowed);
        this.mySaveAuth.setEnabled(authSaveAllowed);
        this.myPanel.add((Component)this.mySaveAuth, gb);
        if (!authSaveAllowed) {
            ++gb.gridy;
            gb.gridwidth = 2;
            JLabel cannotSaveLabel = new JLabel(SvnBundle.message("svn.cannot.save.credentials.store-auth-creds", new Object[0]));
            cannotSaveLabel.setForeground(NamedColorUtil.getInactiveTextColor());
            this.myPanel.add((Component)cannotSaveLabel, gb);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return StringUtil.isEmptyOrSpaces((String)this.myCertificatePath.getText()) ? this.myCertificatePath : this.myCertificatePassword;
    }

    public String getCertificatePath() {
        return this.myCertificatePath.getText();
    }

    public char[] getCertificatePassword() {
        return this.myCertificatePassword.getPassword();
    }

    public boolean getSaveAuth() {
        return this.mySaveAuth.isSelected();
    }

    protected JComponent createNorthPanel() {
        return this.myPanel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    public void setFile(@NotNull String file) {
        this.myCertificatePath.setText(file);
    }
}

