/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.IconUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.dialogs.PropertiesTableView;
import org.jetbrains.idea.svn.dialogs.SetKeywordsDialog;
import org.jetbrains.idea.svn.dialogs.SetPropertyDialog;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class PropertiesComponent
extends JPanel {
    @NonNls
    @NotNull
    public static final String ID = "SVN Properties";
    @NotNull
    private final PropertiesTableView myTable = new PropertiesTableView();
    private JTextArea myTextArea;
    private boolean myIsFollowSelection = true;
    private File myFile;
    private SvnVcs myVcs;
    private JSplitPane mySplitPane;
    private final CloseAction myCloseAction = new CloseAction();
    private final RefreshAction myRefreshAction = new RefreshAction();

    public PropertiesComponent() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.myTextArea = new JTextArea(0, 0);
        this.myTextArea.setEditable(false);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable));
        this.mySplitPane = new JSplitPane(0, true, scrollPane, ScrollPaneFactory.createScrollPane((Component)this.myTextArea));
        this.add((Component)this.mySplitPane, "Center");
        this.add((Component)this.createToolbar(), "West");
        this.myTable.setShowVerticalLines(true);
        this.myTable.setSelectionMode(0);
        this.myTable.getSelectionModel().addListSelectionListener(e -> {
            PropertyData property = (PropertyData)this.myTable.getSelectedObject();
            this.myTextArea.setText(property != null ? property.getValue().toString() : "");
        });
        DefaultActionGroup popupActionGroup = this.createPopup();
        PopupHandler.installPopupMenu((JComponent)((Object)this.myTable), (ActionGroup)popupActionGroup, (String)"SvnPropertiesPopup");
        PopupHandler.installPopupMenu((JComponent)scrollPane, (ActionGroup)popupActionGroup, (String)"SvnPropertiesPopup");
        this.myCloseAction.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CloseActiveTab"), this);
        this.myRefreshAction.registerCustomShortcutSet(CommonShortcuts.getRerun(), this);
    }

    public void setFile(SvnVcs vcs, File file) {
        boolean firstTime;
        boolean bl = firstTime = this.myFile == null;
        if (file != null) {
            this.myFile = file;
            this.myVcs = vcs;
        }
        this.myTable.setProperties(file != null ? PropertiesComponent.collectProperties(vcs, file) : Collections.emptyList());
        if (firstTime) {
            this.mySplitPane.setDividerLocation(0.5);
        }
        if (this.myTable.getRowCount() > 0) {
            this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    @NotNull
    private static List<PropertyData> collectProperties(@NotNull SvnVcs vcs, @NotNull File file) {
        try {
            final ArrayList<PropertyData> properties = new ArrayList<PropertyData>();
            PropertyConsumer handler = new PropertyConsumer(){

                @Override
                public void handleProperty(File path, PropertyData property) {
                    properties.add(property);
                }
            };
            vcs.getFactory(file).createPropertyClient().list(Target.on(file, Revision.UNDEFINED), Revision.WORKING, Depth.EMPTY, handler);
            return properties;
        }
        catch (VcsException e) {
            return Collections.emptyList();
        }
    }

    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new AddPropertyAction());
        group.add((AnAction)new EditPropertyAction());
        group.add((AnAction)new DeletePropertyAction());
        group.addSeparator();
        group.add((AnAction)new SetKeywordsAction());
        group.addSeparator();
        group.add((AnAction)new FollowSelectionAction());
        group.add((AnAction)this.myRefreshAction);
        group.add((AnAction)this.myCloseAction);
        return ActionManager.getInstance().createActionToolbar("SvnProperties", (ActionGroup)group, false).getComponent();
    }

    private DefaultActionGroup createPopup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new AddPropertyAction());
        group.add((AnAction)new EditPropertyAction());
        group.add((AnAction)new DeletePropertyAction());
        group.addSeparator();
        group.add((AnAction)new SetKeywordsAction());
        group.addSeparator();
        group.add((AnAction)this.myRefreshAction);
        return group;
    }

    @Nullable
    private String getSelectedPropertyName() {
        PropertyData property = (PropertyData)this.myTable.getSelectedObject();
        return property != null ? property.getName() : null;
    }

    private void updateFileStatus(boolean recursive) {
        if (this.myFile != null && this.myVcs != null) {
            String url = "file://" + this.myFile.getPath().replace(File.separatorChar, '/');
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
            if (file != null) {
                VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject());
                if (recursive && file.isDirectory()) {
                    dirtyScopeManager.dirDirtyRecursively(file);
                } else {
                    dirtyScopeManager.fileDirty(file);
                }
            }
        }
    }

    private static final class CloseAction
    extends DumbAwareAction {
        private CloseAction() {
            super(SvnBundle.messagePointer("action.Subversion.PropertiesView.Close.text", new Object[0]), SvnBundle.messagePointer("action.Subversion.PropertiesView.Close.description", new Object[0]), AllIcons.Actions.Cancel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(PropertiesComponent.ID);
            if (toolWindow != null) {
                toolWindow.remove();
            }
        }
    }

    private final class RefreshAction
    extends DumbAwareAction {
        private RefreshAction() {
            super(SvnBundle.messagePointer("action.Subversion.PropertiesView.Refresh.text", new Object[0]), SvnBundle.messagePointer("action.Subversion.PropertiesView.Refresh.description", new Object[0]), AllIcons.Actions.Refresh);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(PropertiesComponent.this.myFile != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PropertiesComponent.this.setFile(PropertiesComponent.this.myVcs, PropertiesComponent.this.myFile);
            PropertiesComponent.this.updateFileStatus(false);
        }
    }

    private final class AddPropertyAction
    extends BasePropertyAction {
        private AddPropertyAction() {
            super(SvnBundle.messagePointer("action.Subversion.PropertiesView.AddProperty.text", new Object[0]), SvnBundle.messagePointer("action.Subversion.PropertiesView.AddProperty.description", new Object[0]), IconUtil.getAddIcon());
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(PropertiesComponent.this.myFile != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            SetPropertyDialog dialog = new SetPropertyDialog(project, new File[]{PropertiesComponent.this.myFile}, null, PropertiesComponent.this.myFile.isDirectory());
            boolean recursive = false;
            if (dialog.showAndGet()) {
                recursive = dialog.isRecursive();
                this.setProperty(dialog.getPropertyName(), dialog.getPropertyValue(), recursive, false);
            }
            this.updateFileView(recursive);
        }
    }

    private final class EditPropertyAction
    extends BasePropertyAction {
        private EditPropertyAction() {
            super(SvnBundle.messagePointer("action.Subversion.PropertiesView.EditProperty.text", new Object[0]), SvnBundle.messagePointer("action.Subversion.PropertiesView.EditProperty.description", new Object[0]), AllIcons.Actions.EditSource);
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(PropertiesComponent.this.myFile != null && PropertiesComponent.this.getSelectedPropertyName() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            SetPropertyDialog dialog = new SetPropertyDialog(project, new File[]{PropertiesComponent.this.myFile}, PropertiesComponent.this.getSelectedPropertyName(), PropertiesComponent.this.myFile.isDirectory());
            boolean recursive = false;
            if (dialog.showAndGet()) {
                recursive = dialog.isRecursive();
                this.setProperty(dialog.getPropertyName(), dialog.getPropertyValue(), recursive, false);
            }
            this.updateFileView(recursive);
        }
    }

    private final class DeletePropertyAction
    extends BasePropertyAction {
        private DeletePropertyAction() {
            super(SvnBundle.messagePointer("action.Subversion.PropertiesView.DeleteProperty.text", new Object[0]), SvnBundle.messagePointer("action.Subversion.PropertiesView.DeleteProperty.description", new Object[0]), AllIcons.General.Remove);
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(PropertiesComponent.this.myFile != null && PropertiesComponent.this.getSelectedPropertyName() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.setProperty(PropertiesComponent.this.getSelectedPropertyName(), null, false, true);
            this.updateFileView(false);
        }
    }

    private final class SetKeywordsAction
    extends BasePropertyAction {
        private SetKeywordsAction() {
            super(SvnBundle.messagePointer("action.Subversion.PropertiesView.EditKeywords.text", new Object[0]), SvnBundle.messagePointer("action.Subversion.PropertiesView.EditKeywords.description", new Object[0]), AllIcons.Actions.Properties);
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(PropertiesComponent.this.myFile != null && PropertiesComponent.this.myFile.isFile());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            PropertyValue propValue = null;
            try {
                propValue = PropertiesComponent.this.myVcs.getFactory(PropertiesComponent.this.myFile).createPropertyClient().getProperty(Target.on(PropertiesComponent.this.myFile), "svn:keywords", false, Revision.WORKING);
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
            SetKeywordsDialog dialog = new SetKeywordsDialog(project, propValue);
            if (dialog.showAndGet()) {
                this.setProperty("svn:keywords", dialog.getKeywords(), false, false);
            }
            this.updateFileView(false);
        }
    }

    private final class FollowSelectionAction
    extends DumbAwareToggleAction {
        private FollowSelectionAction() {
            super(SvnBundle.messagePointer("action.Subversion.PropertiesView.FollowSelection.text", new Object[0]), SvnBundle.messagePointer("action.Subversion.PropertiesView.FollowSelection.description", new Object[0]), AllIcons.General.AutoscrollFromSource);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return PropertiesComponent.this.myIsFollowSelection;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (state && !PropertiesComponent.this.myIsFollowSelection) {
                this.updateSelection(e);
            }
            PropertiesComponent.this.myIsFollowSelection = state;
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            if (PropertiesComponent.this.myIsFollowSelection) {
                this.updateSelection(e);
            }
        }

        private void updateSelection(AnActionEvent e) {
            if (PropertiesComponent.this.myVcs == null) {
                return;
            }
            VirtualFile vf = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            if (vf == null) {
                return;
            }
            File f = VfsUtilCore.virtualToIoFile((VirtualFile)vf);
            if (!FileUtil.filesEqual((File)f, (File)PropertiesComponent.this.myFile)) {
                PropertiesComponent.this.setFile(PropertiesComponent.this.myVcs, f);
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)PropertiesComponent.this.myVcs.getProject()).getToolWindow(PropertiesComponent.ID);
                if (toolWindow != null) {
                    toolWindow.setTitle(f.getName());
                }
            }
        }
    }

    private abstract class BasePropertyAction
    extends DumbAwareAction {
        protected BasePropertyAction(@NotNull Supplier<String> dynamicText, @Nullable Supplier<String> dynamicDescription, Icon icon) {
            super(dynamicText, dynamicDescription, icon);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        protected void setProperty(@Nullable String property, @Nullable String value, boolean recursive, boolean force) {
            if (!StringUtil.isEmpty((String)property)) {
                try {
                    PropertiesComponent.this.myVcs.getFactory(PropertiesComponent.this.myFile).createPropertyClient().setProperty(PropertiesComponent.this.myFile, property, PropertyValue.create(value), Depth.allOrEmpty(recursive), force);
                }
                catch (VcsException error) {
                    VcsBalloonProblemNotifier.showOverChangesView((Project)PropertiesComponent.this.myVcs.getProject(), (String)SvnBundle.message("error.can.not.set.property", error.getMessage()), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                }
            }
        }

        protected void updateFileView(boolean recursive) {
            PropertiesComponent.this.setFile(PropertiesComponent.this.myVcs, PropertiesComponent.this.myFile);
            PropertiesComponent.this.updateFileStatus(recursive);
        }
    }
}

