/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.dialogs.UpgradeFormatDialog;

public class ChangeFormatDialog
extends UpgradeFormatDialog {
    private final boolean myWcRootIsAbove;

    public ChangeFormatDialog(Project project, File path, boolean canBeParent, boolean wcRootIsAbove) {
        super(project, path, canBeParent, false);
        this.myWcRootIsAbove = wcRootIsAbove;
        this.setTitle(SvnBundle.message("dialog.title.convert.working.copy.format", new Object[0]));
        this.init();
    }

    @Override
    @Nullable
    protected JPanel getBottomAuxiliaryPanel() {
        if (!this.myWcRootIsAbove) {
            return null;
        }
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.insets = JBUI.insets((int)2);
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        gb.gridwidth = 2;
        gb.gridheight = 1;
        gb.gridx = 0;
        gb.gridy = 0;
        gb.anchor = 17;
        gb.fill = 2;
        JLabel iconLabel = new JLabel(Messages.getWarningIcon());
        result.add((Component)iconLabel, gb);
        ++gb.gridx;
        JLabel warningLabel = new JLabel(SvnBundle.message("label.working.copy.root.outside.text", new Object[0]));
        warningLabel.setFont(warningLabel.getFont().deriveFont(1));
        warningLabel.setUI((LabelUI)new MultiLineLabelUI());
        result.add(warningLabel);
        return result;
    }

    @Override
    @NotNull
    protected String getTopMessage() {
        return SvnBundle.message("label.configure.change.label", this.myPath.getAbsolutePath());
    }

    @Override
    @NlsContexts.RadioButton
    @NotNull
    protected String getFormatText(@NotNull WorkingCopyFormat format) {
        return SvnBundle.message(switch (format) {
            case WorkingCopyFormat.ONE_DOT_SIX -> "radio.configure.change.auto.16format";
            case WorkingCopyFormat.ONE_DOT_SEVEN -> "radio.configure.change.auto.17format";
            case WorkingCopyFormat.ONE_DOT_EIGHT -> "radio.configure.change.auto.18format";
            default -> throw new IllegalArgumentException("unsupported format " + format);
        }, new Object[0]);
    }

    @Override
    protected boolean showHints() {
        return false;
    }
}

