/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.config.PatternsListener;
import org.jetbrains.idea.svn.config.RepositoryUrlsListener;
import org.jetbrains.idea.svn.config.SvnConfigureProxiesComponent;
import org.jetbrains.idea.svn.config.SvnIniFile;

public class RepositoryUrlFilter
implements PatternsListener {
    private final RepositoryUrlsListener myListener;
    private final SvnConfigureProxiesComponent myComponent;
    private final RepositoryUrlsListener myDefaultGroupListener;

    public RepositoryUrlFilter(@NotNull RepositoryUrlsListener listener2, @NotNull SvnConfigureProxiesComponent component, @NotNull RepositoryUrlsListener defaultGroupListener) {
        this.myListener = listener2;
        this.myComponent = component;
        this.myDefaultGroupListener = defaultGroupListener;
    }

    @Override
    public void onChange(String patterns, String exceptions) {
        Collection<String> urls = SvnApplicationSettings.getInstance().getCheckoutURLs();
        ArrayList<String> result = new ArrayList<String>();
        for (String url : urls) {
            if (!SvnIniFile.checkHostGroup(url, patterns, exceptions)) continue;
            result.add(url);
        }
        Collections.sort(result);
        this.myListener.onListChanged(result);
        this.notifyDefaultGroup(urls);
    }

    private void notifyDefaultGroup(@NotNull Collection<String> urls) {
        List<String> filtered = this.myComponent.getGlobalGroupRepositories(urls);
        Collections.sort(filtered);
        this.myDefaultGroupListener.onListChanged(filtered);
    }
}

