/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.auth.CertificateAuthenticationData;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.UsernamePasswordCallback;

public class TwoWaySslCallback
extends UsernamePasswordCallback {
    @NonNls
    private static final String ACCESS_TO_PREFIX = "Access to ";
    @NonNls
    private static final String FORBIDDEN_STATUS = "forbidden";

    TwoWaySslCallback(@NotNull AuthenticationService authenticationService, Url url) {
        super(authenticationService, url);
    }

    @Override
    public boolean canHandle(String error) {
        return error.contains(ACCESS_TO_PREFIX) && error.contains(FORBIDDEN_STATUS);
    }

    @Override
    public String getType() {
        return "svn.ssl.client-passphrase";
    }

    @Override
    public void updateParameters(@NotNull Command command) {
        if (this.myAuthentication instanceof CertificateAuthenticationData) {
            CertificateAuthenticationData auth = (CertificateAuthenticationData)this.myAuthentication;
            command.put("--config-option");
            command.put("servers:global:ssl-client-cert-file=" + auth.getCertificatePath());
            command.put("--config-option");
            command.put("servers:global:ssl-client-cert-password=" + auth.getCertificatePassword());
            if (!auth.isStorageAllowed()) {
                command.put("--no-auth-cache");
            }
        }
    }
}

