/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.ExecutableValidator;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfigurable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.CmdVersionClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

@Service
public final class SvnExecutableChecker
extends ExecutableValidator
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SvnExecutableChecker.class);
    public static final String SVN_EXECUTABLE_LOCALE_REGISTRY_KEY = "svn.executable.locale";
    @NonNls
    private static final String SVN_VERSION_ENGLISH_OUTPUT = "The following repository access (RA) modules are available";
    private static final Pattern INVALID_LOCALE_WARNING_PATTERN = Pattern.compile("^.*cannot set .* locale.*please check that your locale name is correct$", 42);
    @NotNull
    private final SvnVcs myVcs;

    public SvnExecutableChecker(@NotNull Project project) {
        super(project, SvnBundle.message("subversion.executable.notification.title", new Object[0]), SvnBundle.message("subversion.executable.notification.description", new Object[0]), SvnBundle.message("subversion.executable.notification.cant.run.in.safe.mode", new Object[0]));
        this.myVcs = SvnVcs.getInstance(project);
        Registry.get((String)SVN_EXECUTABLE_LOCALE_REGISTRY_KEY).addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                SvnExecutableChecker.this.myVcs.checkCommandLineVersion();
            }
        }, (Disposable)this);
    }

    public void dispose() {
    }

    protected String getCurrentExecutable() {
        return SvnApplicationSettings.getInstance().getCommandLinePath();
    }

    @NotNull
    protected String getConfigurableDisplayName() {
        return SvnConfigurable.getGroupDisplayName();
    }

    protected boolean notify(@Nullable Notification notification) {
        this.expireAll();
        return super.notify(notification);
    }

    public void expireAll() {
        for (ExecutableValidator.ExecutableNotValidNotification notification : (ExecutableValidator.ExecutableNotValidNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ExecutableValidator.ExecutableNotValidNotification.class, this.myProject)) {
            notification.expire();
        }
    }

    protected void showSettingsAndExpireIfFixed(@NotNull Notification notification) {
        this.showSettings();
        notification.expire();
        this.myVcs.checkCommandLineVersion();
    }

    @Nullable
    protected Notification validate(@NotNull String executable) {
        ExecutableValidator.ExecutableNotValidNotification result = this.createDefaultNotification();
        Version version = this.getConfiguredClientVersion();
        if (version != null) {
            try {
                result = this.validateVersion(version);
                if (result == null) {
                    result = this.validateLocale();
                }
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        return result;
    }

    @Nullable
    private Notification validateVersion(@NotNull Version version) {
        return !this.myVcs.isSupportedByCommandLine(WorkingCopyFormat.from(version)) ? new ExecutableValidator.ExecutableNotValidNotification((ExecutableValidator)this, SvnBundle.message("subversion.executable.too.old", version)) : null;
    }

    @Nullable
    private Notification validateLocale() throws SvnBindException {
        ProcessOutput versionOutput = this.getVersionClient().runCommand(false);
        ExecutableValidator.ExecutableNotValidNotification result = null;
        Matcher matcher = INVALID_LOCALE_WARNING_PATTERN.matcher(versionOutput.getStderr());
        if (matcher.find()) {
            @NlsSafe String warningText = matcher.group();
            LOG.info(warningText);
            result = new ExecutableValidator.ExecutableNotValidNotification((ExecutableValidator)this, this.prepareDescription(UIUtil.getHtmlBody((String)warningText), false), NotificationType.WARNING);
        } else if (!SvnExecutableChecker.isEnglishOutput(versionOutput.getStdout())) {
            LOG.info("\"svn --version\" command contains non-English output " + versionOutput.getStdout());
            result = new ExecutableValidator.ExecutableNotValidNotification((ExecutableValidator)this, this.prepareDescription(SvnBundle.message("non.english.locale.detected.warning", new Object[0]), false), NotificationType.WARNING);
        }
        return result;
    }

    @Nullable
    private Version getConfiguredClientVersion() {
        Version result = null;
        try {
            result = this.getVersionClient().getVersion();
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        return result;
    }

    @NotNull
    private CmdVersionClient getVersionClient() {
        return (CmdVersionClient)this.myVcs.getCommandLineFactory().createVersionClient();
    }

    public static boolean isEnglishOutput(@NotNull String versionOutput) {
        return StringUtil.containsIgnoreCase((String)versionOutput, (String)SVN_VERSION_ENGLISH_OUTPUT);
    }
}

