/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.VcsLocaleHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandOutputLogger;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.ResultBuilderNotifier;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.commandLine.SvnProcessHandler;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class CommandExecutor {
    static final Logger LOG = Logger.getInstance((String)CommandExecutor.class.getName());
    private final AtomicReference<Integer> myExitCodeReference;
    @Nullable
    private String myMessage;
    private boolean myIsDestroyed;
    private boolean myNeedsDestroy;
    private volatile @NlsContexts.DialogMessage String myDestroyReason;
    private volatile boolean myWasCancelled;
    @NotNull
    private final List<File> myTempFiles;
    @NotNull
    protected final GeneralCommandLine myCommandLine;
    protected Process myProcess;
    protected SvnProcessHandler myHandler;
    private OutputStreamWriter myProcessWriter;
    private CapturingProcessAdapter outputAdapter;
    private final Object myLock;
    private final EventDispatcher<LineCommandListener> myListeners = EventDispatcher.create(LineCommandListener.class);
    private final AtomicBoolean myWasError = new AtomicBoolean(false);
    @Nullable
    private final LineCommandListener myResultBuilder;
    @NotNull
    private final Command myCommand;

    public CommandExecutor(@NotNull @NonNls String exePath, @NotNull Command command) {
        this.myCommand = command;
        this.myResultBuilder = command.getResultBuilder();
        if (this.myResultBuilder != null) {
            this.myListeners.addListener((EventListener)((Object)this.myResultBuilder));
            this.myListeners.addListener((EventListener)((Object)new CommandCancelTracker()));
        }
        this.myLock = new Object();
        this.myTempFiles = new ArrayList<File>();
        this.myCommandLine = this.createCommandLine();
        this.myCommandLine.setExePath(exePath);
        this.myCommandLine.setWorkDirectory(command.getWorkingDirectory());
        if (command.getConfigDir() != null) {
            this.myCommandLine.addParameters(new String[]{"--config-dir", command.getConfigDir().getPath()});
        }
        this.myCommandLine.addParameter(command.getName().getName());
        this.myCommandLine.addParameters(this.prepareParameters(command));
        this.myExitCodeReference = new AtomicReference();
    }

    @NotNull
    private List<String> prepareParameters(@NotNull Command command) {
        List<String> parameters = command.getParameters();
        this.detectAndRemoveMessage(parameters);
        return parameters;
    }

    private void detectAndRemoveMessage(@NotNull List<String> parameters) {
        int index = parameters.indexOf("-m");
        int n = index = index < 0 ? parameters.indexOf("--message") : index;
        if (index >= 0 && index + 1 < parameters.size()) {
            this.myMessage = parameters.get(index + 1);
            parameters.remove(index + 1);
            parameters.remove(index);
        }
    }

    public boolean isManuallyDestroyed() {
        return this.myIsDestroyed;
    }

    @NlsContexts.DialogMessage
    @Nullable
    public String getDestroyReason() {
        return this.myDestroyReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SvnBindException {
        Object object = this.myLock;
        synchronized (object) {
            this.checkNotStarted();
            try {
                this.beforeCreateProcess();
                this.myProcess = this.createProcess();
                this.myHandler = this.createProcessHandler();
                this.myProcessWriter = new OutputStreamWriter(this.myHandler.getProcessInput(), StandardCharsets.UTF_8);
                this.startHandlingStreams();
            }
            catch (ExecutionException e) {
                this.listeners().startFailed(e);
                throw new SvnBindException(e);
            }
        }
    }

    protected void cleanup() {
        this.deleteTempFiles();
    }

    protected void beforeCreateProcess() throws SvnBindException {
        this.setupLocale();
        this.ensureMessageFile();
        this.ensureTargetsAdded();
        this.ensurePropertyValueAdded();
    }

    private void setupLocale() {
        this.myCommandLine.withEnvironment(VcsLocaleHelper.getDefaultLocaleEnvironmentVars((String)"svn"));
    }

    @NotNull
    private File ensureCommandFile(@NonNls @NotNull String prefix, @NotNull String data, @NotNull String parameterName) throws SvnBindException {
        File result = CommandExecutor.createTempFile(prefix, ".txt");
        this.myTempFiles.add(result);
        try {
            FileUtil.writeToFile((File)result, (String)data);
        }
        catch (IOException e) {
            throw new SvnBindException(e);
        }
        this.myCommandLine.addParameters(new String[]{parameterName, result.getAbsolutePath()});
        return result;
    }

    private void ensureMessageFile() throws SvnBindException {
        if (this.myMessage != null) {
            this.ensureCommandFile("commit-message", this.myMessage, "-F");
            this.myCommandLine.addParameters(new String[]{"--config-option", "config:miscellany:log-encoding=UTF-8"});
        }
    }

    private void ensureTargetsAdded() throws SvnBindException {
        List<String> targetsPaths = this.myCommand.getTargetsPaths();
        if (!ContainerUtil.isEmpty(targetsPaths)) {
            String targetsValue = StringUtil.join(targetsPaths, (String)System.lineSeparator());
            if (this.myCommandLine.getCommandLineString().length() + targetsValue.length() > 7600) {
                this.ensureCommandFile("command-targets", targetsValue, "--targets");
            } else {
                this.myCommandLine.addParameters(targetsPaths);
            }
        }
    }

    private void ensurePropertyValueAdded() throws SvnBindException {
        PropertyValue propertyValue = this.myCommand.getPropertyValue();
        if (propertyValue != null) {
            this.ensureCommandFile("property-value", PropertyValue.toString(propertyValue), "-F");
        }
    }

    private void deleteTempFiles() {
        for (File file : this.myTempFiles) {
            CommandExecutor.deleteTempFile(file);
        }
    }

    @NotNull
    protected static File getSvnFolder() {
        File vcsFolder = new File(PathManager.getSystemPath(), "vcs");
        return new File(vcsFolder, "svn");
    }

    @NotNull
    protected static File createTempFile(@NonNls @NotNull String prefix, @NonNls @NotNull String extension) throws SvnBindException {
        try {
            return FileUtil.createTempFile((File)CommandExecutor.getSvnFolder(), (String)prefix, (String)extension);
        }
        catch (IOException e) {
            throw new SvnBindException(e);
        }
    }

    protected static void deleteTempFile(@Nullable File file) {
        boolean wasDeleted;
        if (file != null && !(wasDeleted = FileUtil.delete((File)file))) {
            LOG.info("Failed to delete temp file " + file.getAbsolutePath());
        }
    }

    @NotNull
    protected SvnProcessHandler createProcessHandler() {
        return new SvnProcessHandler(this.myProcess, this.myCommandLine.getCommandLineString(), this.needsUtf8Output(), this.needsBinaryOutput());
    }

    protected boolean needsBinaryOutput() {
        return this.myCommand.is(SvnCommandName.cat) || this.myCommand.is(SvnCommandName.diff) && !this.myCommand.getParameters().contains("--xml");
    }

    protected boolean needsUtf8Output() {
        return this.myCommand.getParameters().contains("--xml");
    }

    @NotNull
    protected GeneralCommandLine createCommandLine() {
        return new GeneralCommandLine();
    }

    @NotNull
    protected Process createProcess() throws ExecutionException {
        return this.myCommandLine.createProcess();
    }

    protected void startHandlingStreams() {
        this.outputAdapter = new CapturingProcessAdapter();
        this.myHandler.addProcessListener((ProcessListener)this.outputAdapter);
        this.myHandler.addProcessListener((ProcessListener)new ProcessTracker());
        this.myHandler.addProcessListener((ProcessListener)new ResultBuilderNotifier(this.listeners()));
        this.myHandler.addProcessListener((ProcessListener)new CommandOutputLogger());
        this.myHandler.startNotify();
    }

    @NlsSafe
    @NotNull
    public String getOutput() {
        return this.outputAdapter.getOutput().getStdout();
    }

    @NlsSafe
    @NotNull
    public String getErrorOutput() {
        return this.outputAdapter.getOutput().getStderr();
    }

    public ProcessOutput getProcessOutput() {
        return this.outputAdapter.getOutput();
    }

    @NotNull
    public ByteArrayOutputStream getBinaryOutput() {
        return this.myHandler.getBinaryOutput();
    }

    @NotNull
    public Command getCommand() {
        return this.myCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(int timeout) {
        SvnProcessHandler handler;
        this.checkStarted();
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIsDestroyed) {
                return true;
            }
            handler = this.myHandler;
        }
        if (timeout == -1) {
            return handler.waitFor();
        }
        return handler.waitFor(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.myLock;
        synchronized (object) {
            this.checkStarted();
            this.destroyProcess();
        }
    }

    public void run() throws SvnBindException {
        try {
            boolean finished;
            this.start();
            do {
                if ((finished = this.waitFor(500)) || !this.wasError().booleanValue() && !this.needsDestroy() && !this.checkCancelled()) continue;
                this.waitFor(1000);
                this.doDestroyProcess();
                break;
            } while (!finished);
        }
        finally {
            this.cleanup();
        }
    }

    public void run(int timeout) throws SvnBindException {
        try {
            this.start();
            boolean finished = this.waitFor(timeout);
            if (!finished) {
                this.outputAdapter.getOutput().setTimeout();
                this.doDestroyProcess();
            }
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(LineCommandListener listener2) {
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.addListener((EventListener)((Object)listener2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LineCommandListener listeners() {
        Object object = this.myLock;
        synchronized (object) {
            return (LineCommandListener)((Object)this.myListeners.getMulticaster());
        }
    }

    public boolean checkCancelled() {
        if (!this.myWasCancelled && this.myCommand.getCanceller() != null) {
            try {
                this.myCommand.getCanceller().checkCancelled();
            }
            catch (ProcessCanceledException e) {
                this.myWasCancelled = true;
            }
        }
        return this.myWasCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyProcess() {
        Object object = this.myLock;
        synchronized (object) {
            this.myNeedsDestroy = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyProcess(@NlsContexts.DialogMessage @Nullable String destroyReason) {
        Object object = this.myLock;
        synchronized (object) {
            this.myDestroyReason = destroyReason;
            this.myNeedsDestroy = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDestroyProcess() {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myIsDestroyed) {
                LOG.info("Destroying process by command: " + this.getCommandText());
                this.myIsDestroyed = true;
                this.myHandler.destroyProcess();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsDestroy() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myNeedsDestroy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NlsSafe
    @NotNull
    public String getCommandText() {
        Object object = this.myLock;
        synchronized (object) {
            return StringUtil.join((String[])new String[]{this.myCommandLine.getExePath(), " ", this.myCommand.getText()});
        }
    }

    private void checkNotStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("The process has been already started");
        }
    }

    protected void checkStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException("The process is not started yet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myProcess != null;
        }
    }

    public SvnCommandName getCommandName() {
        return this.myCommand.getName();
    }

    public Integer getExitCodeReference() {
        return this.myExitCodeReference.get();
    }

    public void setExitCodeReference(int value) {
        this.myExitCodeReference.set(value);
    }

    public Boolean wasError() {
        return this.myWasError.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String value) throws SvnBindException {
        try {
            Object object = this.myLock;
            synchronized (object) {
                this.myProcessWriter.write(value);
                this.myProcessWriter.flush();
            }
        }
        catch (IOException e) {
            throw new SvnBindException(e);
        }
    }

    public void logCommand() {
        LOG.info("Command text " + this.getCommandText());
        LOG.info("Command output " + this.getOutput());
    }

    private class CommandCancelTracker
    extends LineCommandAdapter {
        private CommandCancelTracker() {
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (CommandExecutor.this.myResultBuilder != null && CommandExecutor.this.myResultBuilder.isCanceled()) {
                LOG.info("Cancelling command: " + CommandExecutor.this.getCommandText());
                CommandExecutor.this.destroyProcess();
            }
        }
    }

    private class ProcessTracker
    extends ProcessAdapter {
        private ProcessTracker() {
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            CommandExecutor.this.setExitCodeReference(event.getExitCode());
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (ProcessOutputTypes.STDERR == outputType) {
                CommandExecutor.this.myWasError.set(true);
            }
        }
    }
}

