/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.browse;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.browse.BrowseClient;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.checkin.CmdCheckinClient;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.lock.Lock;

public class CmdBrowseClient
extends BaseSvnClient
implements BrowseClient {
    @Override
    public void list(@NotNull Target target, @Nullable Revision revision, @Nullable Depth depth, @Nullable DirectoryEntryConsumer handler) throws VcsException {
        this.assertUrl(target);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, depth);
        parameters.add("--xml");
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.list, parameters, null);
        Info info2 = this.myFactory.createInfoClient().doInfo(target, revision);
        CmdBrowseClient.parseOutput(target.getUrl(), command, handler, info2 != null ? info2.getRepositoryRootUrl() : null);
    }

    @Override
    public long createDirectory(@NotNull Target target, @NotNull String message, boolean makeParents) throws VcsException {
        this.assertUrl(target);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target);
        CommandUtil.put(parameters, makeParents, "--parents");
        parameters.add("--message");
        parameters.add(message);
        CmdCheckinClient.CommandListener listener2 = new CmdCheckinClient.CommandListener(null);
        this.execute(this.myVcs, target, SvnCommandName.mkdir, parameters, (LineCommandListener)listener2);
        return listener2.getCommittedRevision();
    }

    private static void parseOutput(@NotNull Url url, @NotNull CommandExecutor command, @Nullable DirectoryEntryConsumer handler, @Nullable Url repositoryUrl) throws SvnBindException {
        try {
            TargetLists lists = CommandUtil.parse(command.getOutput(), TargetLists.class);
            if (handler != null && lists != null) {
                for (TargetList list : lists.lists) {
                    for (Entry entry : list.entries) {
                        handler.consume(entry.toDirectoryEntry(url, repositoryUrl));
                    }
                }
            }
        }
        catch (JAXBException e) {
            throw new SvnBindException(e);
        }
    }

    @XmlRootElement(name="lists")
    public static class TargetLists {
        @XmlElement(name="list")
        public List<TargetList> lists = new ArrayList<TargetList>();
    }

    public static class TargetList {
        @XmlAttribute(name="path")
        public String path;
        @XmlElement(name="entry")
        public List<Entry> entries = new ArrayList<Entry>();
    }

    public static class Entry {
        @XmlAttribute(name="kind", required=true)
        public NodeKind kind;
        @XmlElement(name="name")
        public String name;
        @XmlElement(name="size")
        public long size;
        public CommitInfo.Builder commit;
        public Lock.Builder lock;

        @NotNull
        public DirectoryEntry toDirectoryEntry(@NotNull Url url, @Nullable Url repositoryUrl) throws SvnBindException {
            return new DirectoryEntry(SvnUtil.append(url, this.name), repositoryUrl, PathUtil.getFileName((String)this.name), this.kind, this.commit != null ? this.commit.build() : null, this.name);
        }
    }
}

