/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNewKt;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\t0\u000eJ\u0006\u0010!\u001a\u00020\u0000J\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0005J\u0012\u0010%\u001a\u0004\u0018\u00010\u00052\u0006\u0010$\u001a\u00020\u0005H\u0002J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u001f\u001a\u00020\u0005J\u0010\u0010'\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0005J\"\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u0004\u0018\u00010\u00052\u0006\u0010$\u001a\u00020\u0005J\u000e\u00100\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0005J\"\u00101\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\t0\u000eR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR)\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\t0\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R&\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\t0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u00062"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationNew;", "", "()V", "allBranches", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/idea/svn/api/Url;", "getAllBranches", "()Lkotlin/sequences/Sequence;", "branchLocations", "", "getBranchLocations", "()Ljava/util/List;", "branchMap", "", "Lorg/jetbrains/idea/svn/branchConfig/InfoStorage;", "Lorg/jetbrains/idea/svn/branchConfig/SvnBranchItem;", "getBranchMap", "()Ljava/util/Map;", "isUserInfoInUrl", "", "()Z", "setUserInfoInUrl", "(Z)V", "myBranchMap", "trunk", "getTrunk", "()Lorg/jetbrains/idea/svn/api/Url;", "setTrunk", "(Lorg/jetbrains/idea/svn/api/Url;)V", "addBranches", "", "branchLocation", "items", "copy", "getBaseName", "", "url", "getBaseUrl", "getBranches", "getRelativeUrl", "getUrl2FileMappings", "", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getWorkingBranch", "removeBranch", "updateBranch", "intellij.vcs.svn"})
public final class SvnBranchConfigurationNew {
    @Nullable
    private Url trunk;
    @NotNull
    private final Map<Url, InfoStorage<List<SvnBranchItem>>> myBranchMap = new LinkedHashMap();
    private boolean isUserInfoInUrl;

    @Nullable
    public final Url getTrunk() {
        return this.trunk;
    }

    public final void setTrunk(@Nullable Url url) {
        this.trunk = url;
    }

    public final boolean isUserInfoInUrl() {
        return this.isUserInfoInUrl;
    }

    public final void setUserInfoInUrl(boolean bl) {
        this.isUserInfoInUrl = bl;
    }

    @NotNull
    public final List<Url> getBranchLocations() {
        Iterable $this$sortedBy$iv = this.myBranchMap.keySet();
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Url it = (Url)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.toDecodedString());
                it = (Url)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.toDecodedString())));
            }
        });
    }

    @NotNull
    public final Map<Url, InfoStorage<List<SvnBranchItem>>> getBranchMap() {
        return this.myBranchMap;
    }

    public final void addBranches(@NotNull Url branchLocation, @NotNull InfoStorage<List<SvnBranchItem>> items) {
        InfoStorage<List<SvnBranchItem>> current = this.myBranchMap.get(branchLocation);
        if (current != null) {
            SvnBranchConfigurationNewKt.access$getLOG$p().info("Branches list not added for : '" + branchLocation.toDecodedString() + "; this branch parent URL is already present.");
            return;
        }
        this.myBranchMap.put(branchLocation, items);
    }

    public final void updateBranch(@NotNull Url branchLocation, @NotNull InfoStorage<List<SvnBranchItem>> items) {
        InfoStorage<List<SvnBranchItem>> current = this.myBranchMap.get(branchLocation);
        if (current == null) {
            SvnBranchConfigurationNewKt.access$getLOG$p().info("Branches list not updated for : '" + branchLocation.toDecodedString() + "; since config has changed.");
            return;
        }
        current.accept(items);
    }

    @NotNull
    public final List<SvnBranchItem> getBranches(@NotNull Url branchLocation) {
        Object object = this.myBranchMap.get(branchLocation);
        if (object == null || (object = ((InfoStorage)object).getValue()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final SvnBranchConfigurationNew copy() {
        SvnBranchConfigurationNew result = new SvnBranchConfigurationNew();
        result.isUserInfoInUrl = this.isUserInfoInUrl;
        result.trunk = this.trunk;
        for (Map.Entry<Url, InfoStorage<List<SvnBranchItem>>> entry : this.myBranchMap.entrySet()) {
            Url key = entry.getKey();
            InfoStorage<List<SvnBranchItem>> infoStorage = entry.getValue();
            result.myBranchMap.put(key, new InfoStorage<List>(CollectionsKt.toList((Iterable)infoStorage.getValue()), infoStorage.getInfoReliability()));
        }
        return result;
    }

    private final Url getBaseUrl(Url url) {
        Url trunk = this.trunk;
        if (trunk != null && SvnUtil.isAncestor(trunk, url)) {
            return trunk;
        }
        for (Url branchUrl : SvnBranchConfigurationNewKt.access$sortBranchLocations(this.myBranchMap.keySet())) {
            if (!SvnUtil.isAncestor(branchUrl, url)) continue;
            String relativePath = SvnUtil.getRelativeUrl(branchUrl, url);
            return branchUrl.appendPath(StringsKt.substringBefore$default((String)relativePath, (String)"/", null, (int)2, null), false);
        }
        return null;
    }

    @Nullable
    public final String getBaseName(@NotNull Url url) {
        Url url2 = this.getBaseUrl(url);
        return url2 != null ? url2.getTail() : null;
    }

    @Nullable
    public final String getRelativeUrl(@NotNull Url url) {
        String string;
        Url url2 = this.getBaseUrl(url);
        if (url2 != null) {
            Url it = url2;
            boolean bl = false;
            string = SvnUtil.getRelativeUrl(it, url);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final Url getWorkingBranch(@NotNull Url url) throws SvnBindException {
        return this.getBaseUrl(url);
    }

    @NotNull
    public final Map<Url, File> getUrl2FileMappings(@NotNull Project project, @NotNull VirtualFile root) {
        Object object = SvnVcs.getInstance(project).getInfo(root);
        if (object == null || (object = ((Info)object).getUrl()) == null) {
            return MapsKt.emptyMap();
        }
        Object rootUrl = object;
        File baseDir = VfsUtilCore.virtualToIoFile((VirtualFile)root);
        Map result = new LinkedHashMap();
        for (Url url : this.getAllBranches()) {
            if (!SvnUtil.isAncestor((Url)rootUrl, url)) continue;
            result.put(url, SvnUtil.fileFromUrl(baseDir, ((Url)rootUrl).getPath(), url.getPath()));
        }
        return result;
    }

    private final Sequence<Url> getAllBranches() {
        Object[] objectArray = new Url[]{this.trunk};
        Iterable $this$sortedByDescending$iv = this.myBranchMap.entrySet();
        boolean $i$f$sortedByDescending = false;
        return SequencesKt.plus((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray)), (Sequence)SequencesKt.map((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((Url)it.getKey()).toDecodedString().length());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((Url)it.getKey()).toDecodedString().length()));
            }
        })), (Function1)allBranches.2.INSTANCE)), (Function1)allBranches.3.INSTANCE));
    }

    public final void removeBranch(@NotNull Url url) {
        this.myBranchMap.remove(url);
    }
}

