/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public final class DefaultBranchConfig {
    private static final Logger LOG = Logger.getInstance(DefaultBranchConfig.class);
    @NlsSafe
    public static final String TRUNK_NAME = "trunk";
    @NlsSafe
    public static final String BRANCHES_NAME = "branches";
    @NlsSafe
    public static final String TAGS_NAME = "tags";

    @Nullable
    public static SvnBranchConfigurationNew detect(@NotNull Project project, @NotNull VirtualFile root) {
        SvnBranchConfigurationNew result = null;
        SvnVcs vcs = SvnVcs.getInstance(project);
        Url rootUrl = SvnUtil.getUrl(vcs, VfsUtilCore.virtualToIoFile((VirtualFile)root));
        if (rootUrl != null) {
            try {
                result = DefaultBranchConfig.detect(vcs, rootUrl);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        } else {
            LOG.info("Directory is not a working copy: " + root.getPresentableUrl());
        }
        return result;
    }

    @NotNull
    private static SvnBranchConfigurationNew detect(@NotNull SvnVcs vcs, @NotNull Url url) throws VcsException {
        SvnBranchConfigurationNew result = new SvnBranchConfigurationNew();
        result.setTrunk(url);
        Url branchLocationsParent = DefaultBranchConfig.getBranchLocationsParent(url);
        if (branchLocationsParent != null) {
            Target target = Target.on(branchLocationsParent);
            vcs.getFactory(target).createBrowseClient().list(target, Revision.HEAD, Depth.IMMEDIATES, DefaultBranchConfig.createHandler(result, target.getUrl()));
        }
        return result;
    }

    @Nullable
    private static Url getBranchLocationsParent(@NotNull Url url) throws SvnBindException {
        while (!DefaultBranchConfig.hasEmptyName(url) && !DefaultBranchConfig.hasDefaultName(url)) {
            url = SvnUtil.removePathTail(url);
        }
        return DefaultBranchConfig.hasDefaultName(url) ? SvnUtil.removePathTail(url) : null;
    }

    private static boolean hasEmptyName(@NotNull Url url) {
        return StringUtil.isEmpty((String)url.getTail());
    }

    private static boolean hasDefaultName(@NotNull Url url) {
        String name = url.getTail();
        return name.equalsIgnoreCase(TRUNK_NAME) || name.equalsIgnoreCase(BRANCHES_NAME) || name.equalsIgnoreCase(TAGS_NAME);
    }

    @NotNull
    private static DirectoryEntryConsumer createHandler(@NotNull SvnBranchConfigurationNew result, @NotNull Url rootPath) {
        return entry -> {
            if (entry.isDirectory()) {
                Url childUrl = SvnUtil.append(rootPath, entry.getName());
                if (StringUtil.endsWithIgnoreCase((String)entry.getName(), (String)TRUNK_NAME)) {
                    result.setTrunk(childUrl);
                } else {
                    result.addBranches(childUrl, new InfoStorage<List<SvnBranchItem>>(new ArrayList(0), InfoReliability.defaultValues));
                }
            }
        };
    }
}

