/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.CreateBranchOrTagDialog;
import org.jetbrains.idea.svn.checkin.IdeaCommitHandler;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.update.AutoSvnUpdater;
import org.jetbrains.idea.svn.update.SingleRootSwitcher;

public class CreateBranchOrTagAction
extends BasicAction {
    @Override
    @NotNull
    protected String getActionName() {
        return SvnBundle.message("action.Subversion.Copy.text", new Object[0]);
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        return SvnStatusUtil.isUnderControl(vcs, file);
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) throws VcsException {
        CreateBranchOrTagDialog dialog = new CreateBranchOrTagDialog(vcs, VfsUtilCore.virtualToIoFile((VirtualFile)file));
        if (dialog.showAndGet()) {
            int rc;
            Target source = Objects.requireNonNull(dialog.getSource());
            File sourceFile = dialog.getSourceFile();
            Url destination = Objects.requireNonNull(dialog.getDestination());
            Revision revision = dialog.getRevision();
            String comment = dialog.getComment();
            Url parentUrl = SvnUtil.removePathTail(destination);
            if (!CreateBranchOrTagAction.dirExists(vcs, parentUrl) && (rc = Messages.showYesNoDialog((Project)vcs.getProject(), (String)SvnBundle.message("dialog.message.repository.path.does.not.exist", parentUrl), (String)SvnBundle.message("copy.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon())) == 1) {
                return;
            }
            Ref exception = new Ref();
            Runnable copyCommand = () -> {
                try {
                    ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                    IdeaCommitHandler handler = null;
                    if (progress != null) {
                        progress.setText(SvnBundle.message("progress.text.copy.to", destination.toDecodedString()));
                        handler = new IdeaCommitHandler(progress);
                    }
                    long newRevision = vcs.getFactory(source).createCopyMoveClient().copy(source, Target.on(destination), revision, true, false, comment, handler);
                    CreateBranchOrTagAction.updateStatusBar(newRevision, vcs.getProject());
                }
                catch (Exception e) {
                    exception.set((Object)e);
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously(copyCommand, SvnBundle.message("progress.title.copy", new Object[0]), false, vcs.getProject());
            if (!exception.isNull()) {
                throw new VcsException((Throwable)exception.get());
            }
            if (dialog.isSwitchOnCreate()) {
                SingleRootSwitcher switcher = new SingleRootSwitcher(vcs.getProject(), VcsUtil.getFilePath((File)sourceFile, (boolean)sourceFile.isDirectory()), destination);
                AutoSvnUpdater.run(switcher, SvnBundle.message("action.name.switch", new Object[0]));
            }
        }
    }

    private static void updateStatusBar(long revision, @NotNull Project project) {
        StatusBar statusBar;
        if (revision > 0L && (statusBar = WindowManager.getInstance().getStatusBar(project)) != null) {
            statusBar.setInfo(SvnBundle.message("status.text.committed.revision", revision));
        }
    }

    private static boolean dirExists(@NotNull SvnVcs vcs, @NotNull Url url) throws SvnBindException {
        Ref excRef = new Ref();
        Ref resultRef = new Ref((Object)Boolean.TRUE);
        Runnable taskImpl = () -> {
            try {
                vcs.getInfo(url, Revision.HEAD);
            }
            catch (SvnBindException e) {
                if (e.contains(ErrorCode.RA_ILLEGAL_URL)) {
                    resultRef.set((Object)Boolean.FALSE);
                }
                excRef.set((Object)e);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(taskImpl, SvnBundle.message("progress.title.checking.target.folder", new Object[0]), true, vcs.getProject());
        } else {
            taskImpl.run();
        }
        if (!excRef.isNull()) {
            throw (SvnBindException)((Object)excRef.get());
        }
        return (Boolean)resultRef.get();
    }

    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, VirtualFile @NotNull [] files, @NotNull DataContext context) {
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }
}

