/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.browse.BrowseClient;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;

public class BranchesLoader
implements Runnable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final NewRootBunch myBunch;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final Url myUrl;
    @NotNull
    private final InfoReliability myInfoReliability;
    private final boolean myPassive;

    public BranchesLoader(@NotNull Project project, @NotNull NewRootBunch bunch, @NotNull Url url, @NotNull InfoReliability infoReliability, @NotNull VirtualFile root, boolean passive) {
        this.myProject = project;
        this.myBunch = bunch;
        this.myUrl = url;
        this.myInfoReliability = infoReliability;
        this.myRoot = root;
        this.myPassive = passive;
    }

    @Override
    public void run() {
        try {
            List<SvnBranchItem> branches = this.loadBranches();
            this.myBunch.updateBranches(this.myRoot, this.myUrl, new InfoStorage<List<SvnBranchItem>>(branches, this.myInfoReliability));
        }
        catch (VcsException e) {
            this.showError((Exception)((Object)e));
        }
    }

    @NotNull
    public List<SvnBranchItem> loadBranches() throws VcsException {
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        LinkedList<SvnBranchItem> result = new LinkedList<SvnBranchItem>();
        Target target = Target.on(this.myUrl);
        DirectoryEntryConsumer handler = BranchesLoader.createConsumer(result);
        vcs.getFactory(target).create(BrowseClient.class, !this.myPassive).list(target, Revision.HEAD, Depth.IMMEDIATES, handler);
        Collections.sort(result);
        return result;
    }

    private void showError(Exception e) {
        if (InfoReliability.setByUser.equals((Object)this.myInfoReliability)) {
            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)SvnBundle.message("notification.content.branches.load.error", e.getMessage()), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
        }
    }

    @NotNull
    private static DirectoryEntryConsumer createConsumer(@NotNull List<SvnBranchItem> result) {
        return entry -> {
            if (entry.getDate() != null) {
                result.add(new SvnBranchItem(entry.getUrl(), entry.getDate().getTime(), entry.getRevision()));
            }
        };
    }
}

