/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IdeHttpClientHelpers;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.proxy.CommonProxy;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AcceptResult;
import org.jetbrains.idea.svn.auth.AuthenticationData;
import org.jetbrains.idea.svn.auth.CertificateTrustManager;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.SimpleCredentialsDialog;

public final class AuthenticationService {
    private static final Logger LOG = Logger.getInstance(AuthenticationService.class);
    @NonNls
    private static final String FATAL_HANDSHAKE_FAILURE_ERROR = "received fatal alert: handshake_failure";
    @NonNls
    private static final String SSL_V3_PROTOCOL = "SSLv3";
    @NonNls
    private static final String TLS_V1_PROTOCOL = "TLSv1";
    @NonNls
    private static final String TERMINAL_SSL_SERVER_AUTH_KIND = "terminal.ssl.server";
    @NotNull
    private final SvnVcs myVcs;
    private final boolean myIsActive;
    private boolean myProxyCredentialsWereReturned;
    @NotNull
    private final SvnConfiguration myConfiguration;
    private final Set<String> myRequestedCredentials;

    public AuthenticationService(@NotNull SvnVcs vcs, boolean isActive) {
        this.myVcs = vcs;
        this.myIsActive = isActive;
        this.myConfiguration = this.myVcs.getSvnConfiguration();
        this.myRequestedCredentials = new HashSet<String>();
    }

    @NotNull
    public SvnVcs getVcs() {
        return this.myVcs;
    }

    public boolean isActive() {
        return this.myIsActive;
    }

    @Nullable
    public AuthenticationData requestCredentials(Url repositoryUrl, String type) {
        AuthenticationData authentication = null;
        if (repositoryUrl != null) {
            String realm = repositoryUrl.toDecodedString();
            authentication = this.requestCredentials(realm, type, () -> this.myConfiguration.getInteractiveManager(this.myVcs).getProvider().requestClientAuthentication(type, repositoryUrl, realm, true));
        }
        if (authentication == null) {
            LOG.warn("Could not get authentication. Type - " + type + ", Url - " + repositoryUrl);
        }
        return authentication;
    }

    @Nullable
    private <T> T requestCredentials(@NotNull String realm, @NotNull String type, @NotNull Supplier<T> fromUserProvider) {
        Object result = null;
        Object data = SvnConfiguration.RUNTIME_AUTH_CACHE.getDataWithLowerCheck(type, realm);
        String key = SvnConfiguration.AuthStorage.getKey(type, realm);
        if (data != null && !this.myRequestedCredentials.contains(key)) {
            result = data;
            this.myRequestedCredentials.add(key);
        } else if (this.myIsActive && (result = (Object)fromUserProvider.get()) != null) {
            this.myConfiguration.acknowledge(type, realm, result);
            this.myRequestedCredentials.add(key);
        }
        return (T)result;
    }

    @Nullable
    public String requestSshCredentials(@NotNull String realm, @NotNull SimpleCredentialsDialog.Mode mode, @NotNull String key) {
        return this.requestCredentials(realm, StringUtil.toLowerCase((String)mode.toString()), () -> {
            Ref answer = new Ref();
            Runnable command = () -> {
                SimpleCredentialsDialog dialog = new SimpleCredentialsDialog(this.myVcs.getProject());
                dialog.setup(mode, realm, key, true);
                dialog.setTitle(SvnBundle.message("dialog.title.authentication.required", new Object[0]));
                dialog.setSaveEnabled(false);
                if (dialog.showAndGet()) {
                    answer.set((Object)dialog.getPassword());
                }
            };
            WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)command, (ModalityState)ModalityState.any());
            return (String)answer.get();
        });
    }

    @NotNull
    public AcceptResult acceptCertificate(@NotNull Url url, @NotNull String certificateInfo) {
        AcceptResult result;
        String realm = url.toDecodedString();
        Object data = SvnConfiguration.RUNTIME_AUTH_CACHE.getDataWithLowerCheck(TERMINAL_SSL_SERVER_AUTH_KIND, realm);
        if (data != null) {
            result = (AcceptResult)((Object)data);
        } else {
            result = this.getAuthenticationManager().getProvider().acceptServerAuthentication(url, realm, certificateInfo, true);
            if (!AcceptResult.REJECTED.equals((Object)result)) {
                this.myConfiguration.acknowledge(TERMINAL_SSL_SERVER_AUTH_KIND, realm, (Object)result);
            }
        }
        return result;
    }

    public boolean acceptSSLServerCertificate(@Nullable Url repositoryUrl) throws SvnBindException {
        if (repositoryUrl == null) {
            return false;
        }
        HttpClient client = this.getClient(repositoryUrl);
        try {
            client.execute((HttpUriRequest)new HttpGet(repositoryUrl.toDecodedString()));
            return true;
        }
        catch (IOException e) {
            throw new SvnBindException(AuthenticationService.fixMessage(e), e);
        }
    }

    @Nls
    @Nullable
    private static String fixMessage(@NotNull IOException e) {
        Object message = null;
        if (e instanceof SSLHandshakeException) {
            if (StringUtil.containsIgnoreCase((String)e.getMessage(), (String)FATAL_HANDSHAKE_FAILURE_ERROR)) {
                message = e.getMessage() + ". " + SvnBundle.message("label.specify.ssl.protocol.manually", new Object[0]);
            } else if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
        }
        return message;
    }

    @NotNull
    private HttpClient getClient(@NotNull Url repositoryUrl) {
        SSLContext sslContext = this.createSslContext(repositoryUrl);
        List<String> supportedProtocols = this.getSupportedSslProtocols();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, ArrayUtilRt.toStringArray(supportedProtocols), null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (this.haveDataForTmpConfig()) {
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyIfEnabled((RequestConfig.Builder)requestConfigBuilder);
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyCredentialsIfEnabled((CredentialsProvider)credentialsProvider);
        }
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.getAuthenticationManager().getReadTimeout(repositoryUrl)).build()).setDefaultRequestConfig(requestConfigBuilder.setConnectTimeout(this.getAuthenticationManager().getConnectTimeout(repositoryUrl)).build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
    }

    @NotNull
    private List<String> getSupportedSslProtocols() {
        ArrayList<String> result = new ArrayList<String>();
        switch (this.myConfiguration.getSslProtocols()) {
            case sslv3: {
                result.add(SSL_V3_PROTOCOL);
                break;
            }
            case tlsv1: {
                result.add(TLS_V1_PROTOCOL);
                break;
            }
        }
        return result;
    }

    @NotNull
    private SSLContext createSslContext(@NotNull Url url) {
        SSLContext result = CertificateManager.getSystemSslContext();
        CertificateTrustManager trustManager = new CertificateTrustManager(this, url);
        try {
            result.init(CertificateManager.getDefaultKeyManagers(), new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    @NotNull
    public SvnAuthenticationManager getAuthenticationManager() {
        return this.isActive() ? this.myConfiguration.getInteractiveManager(this.myVcs) : this.myConfiguration.getPassiveAuthenticationManager(this.myVcs);
    }

    public boolean haveDataForTmpConfig() {
        HttpConfigurable instance = HttpConfigurable.getInstance();
        return this.myConfiguration.isUseDefaultProxy() && (instance.USE_HTTP_PROXY || instance.USE_PROXY_PAC);
    }

    @Nullable
    public static Proxy getIdeaDefinedProxy(@NotNull Url url) {
        CommonProxy.getInstance().removeNoProxy(url.getProtocol(), url.getHost(), url.getPort());
        List proxies = CommonProxy.getInstance().select(URI.create(url.toString()));
        if (proxies != null && !proxies.isEmpty()) {
            for (Proxy proxy : proxies) {
                if (!HttpConfigurable.isRealProxy((Proxy)proxy) || !Proxy.Type.HTTP.equals((Object)proxy.type())) continue;
                return proxy;
            }
        }
        return null;
    }

    @Nullable
    public PasswordAuthentication getProxyAuthentication(@NotNull Url repositoryUrl) {
        Proxy proxy = AuthenticationService.getIdeaDefinedProxy(repositoryUrl);
        PasswordAuthentication result = null;
        if (proxy != null) {
            if (this.myProxyCredentialsWereReturned) {
                AuthenticationService.showFailedAuthenticateProxy();
            } else {
                result = AuthenticationService.getProxyAuthentication(proxy, repositoryUrl);
                this.myProxyCredentialsWereReturned = result != null;
            }
        }
        return result;
    }

    private static void showFailedAuthenticateProxy() {
        HttpConfigurable instance = HttpConfigurable.getInstance();
        String message = instance.USE_HTTP_PROXY || instance.USE_PROXY_PAC ? SvnBundle.message("popup.content.failed.to.authenticate.to.proxy.change.credentials", new Object[0]) : SvnBundle.message("popup.content.failed.to.authenticate.to.proxy", new Object[0]);
        PopupUtil.showBalloonForActiveComponent((String)message, (MessageType)MessageType.ERROR);
    }

    @Nullable
    private static PasswordAuthentication getProxyAuthentication(@NotNull Proxy proxy, @NotNull Url repositoryUrl) {
        PasswordAuthentication result = null;
        try {
            result = Authenticator.requestPasswordAuthentication(repositoryUrl.getHost(), ((InetSocketAddress)proxy.address()).getAddress(), repositoryUrl.getPort(), repositoryUrl.getProtocol(), repositoryUrl.getHost(), repositoryUrl.getProtocol(), new URL(repositoryUrl.toString()), Authenticator.RequestorType.PROXY);
        }
        catch (MalformedURLException e) {
            LOG.info((Throwable)e);
        }
        return result;
    }

    public void reset() {
    }

    @NotNull
    public Path getSpecialConfigDir() {
        return this.myConfiguration.getConfigurationPath();
    }
}

