/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.VersionClient;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;

public class CmdVersionClient
extends BaseSvnClient
implements VersionClient {
    private static final Pattern VERSION = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)");
    private static final int COMMAND_TIMEOUT = 30000;

    @Override
    @NotNull
    public Version getVersion() throws SvnBindException {
        return CmdVersionClient.parseVersion(this.runCommand(true));
    }

    @NotNull
    public ProcessOutput runCommand(boolean quiet) throws SvnBindException {
        Command command = new Command(SvnCommandName.version);
        if (quiet) {
            command.put("--quiet");
        }
        return this.newRuntime(this.myVcs).runLocal(command, 30000).getProcessOutput();
    }

    @NotNull
    private static Version parseVersion(@NotNull ProcessOutput output) throws SvnBindException {
        if (output.isTimeout()) {
            throw new SvnBindException(SvnBundle.message("error.could.not.get.svn.version", output.getExitCode(), output.getStderr()));
        }
        return CmdVersionClient.parseVersion(output.getStdout());
    }

    @NotNull
    public static Version parseVersion(@NlsSafe @NotNull String versionText) throws SvnBindException {
        Version result = null;
        NumberFormatException cause = null;
        Matcher matcher = VERSION.matcher(versionText);
        boolean found = matcher.find();
        if (found) {
            try {
                result = new Version(CmdVersionClient.getInt(matcher.group(1)), CmdVersionClient.getInt(matcher.group(2)), CmdVersionClient.getInt(matcher.group(3)));
            }
            catch (NumberFormatException e) {
                cause = e;
            }
        }
        if (!found || cause != null) {
            throw new SvnBindException(SvnBundle.message("error.could.not.parse.svn.version", versionText), cause);
        }
        return result;
    }

    private static int getInt(@NotNull String value) {
        return Integer.parseInt(value);
    }
}

