/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.actions.AddToIgnoreListAction;
import org.jetbrains.idea.svn.actions.RemoveFromIgnoreListAction;
import org.jetbrains.idea.svn.ignore.IgnoreGroupHelperAction;

public class IgnoreActionGroup
extends DefaultActionGroup
implements DumbAware {
    private final RemoveFromIgnoreListAction myRemoveExactAction;
    private final RemoveFromIgnoreListAction myRemoveExtensionAction;
    private final AddToIgnoreListAction myAddExactAction = new AddToIgnoreListAction(false);
    private final AddToIgnoreListAction myAddExtensionAction = new AddToIgnoreListAction(true);

    public IgnoreActionGroup() {
        this.myRemoveExactAction = new RemoveFromIgnoreListAction(false);
        this.myRemoveExtensionAction = new RemoveFromIgnoreListAction(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        IgnoreGroupHelperAction helper = IgnoreGroupHelperAction.createFor(e);
        if (helper == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        if (helper.allAreIgnored()) {
            presentation.setText(SvnBundle.messagePointer("group.RevertIgnoreChoicesGroup.text", new Object[0]));
        } else if (helper.allCanBeIgnored()) {
            presentation.setText(SvnBundle.messagePointer("group.IgnoreChoicesGroup.text", new Object[0]));
        }
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        return new AnAction[]{this.myRemoveExactAction, this.myRemoveExtensionAction, this.myAddExactAction, this.myAddExtensionAction};
    }
}

