/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsFileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnProgressCanceller;
import org.jetbrains.idea.svn.SvnVcs;

public class CleanupWorker
extends Task.Backgroundable {
    @NotNull
    protected final List<VirtualFile> myRoots;
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final List<Pair<VcsException, VirtualFile>> myExceptions = new ArrayList<Pair<VcsException, VirtualFile>>();

    public CleanupWorker(@NotNull SvnVcs vcs, @NotNull List<? extends VirtualFile> roots) {
        this(vcs, roots, null);
    }

    public CleanupWorker(@NotNull SvnVcs vcs, @NotNull List<? extends VirtualFile> roots, @NlsContexts.ProgressTitle @Nullable String title) {
        super(vcs.getProject(), (String)ObjectUtils.notNull((Object)title, (Object)SvnBundle.message("action.Subversion.cleanup.progress.title", new Object[0])));
        this.myVcs = vcs;
        this.myRoots = new ArrayList<VirtualFile>(roots);
    }

    public void execute() {
        StoreUtil.saveDocumentsAndProjectSettings((Project)this.myVcs.getProject());
        this.fillRoots();
        if (!this.myRoots.isEmpty()) {
            this.queue();
        }
    }

    protected void fillRoots() {
    }

    public void run(@NotNull ProgressIndicator indicator) {
        indicator.setIndeterminate(true);
        for (VirtualFile root : this.myRoots) {
            try {
                File path = VfsUtilCore.virtualToIoFile((VirtualFile)root);
                File pathOrParent = VfsUtilCore.virtualToIoFile((VirtualFile)(root.isDirectory() ? root : root.getParent()));
                indicator.setText(SvnBundle.message("progress.text.performing.path.cleanup", path));
                this.myVcs.getFactory(path).createCleanupClient().cleanup(pathOrParent, new SvnProgressCanceller(indicator));
            }
            catch (VcsException e) {
                this.myExceptions.add((Pair<VcsException, VirtualFile>)Pair.create((Object)((Object)e), (Object)root));
            }
        }
    }

    public void onCancel() {
        this.onSuccess();
    }

    public void onSuccess() {
        assert (this.getProject() != null);
        if (this.getProject().isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (!this.getProject().isDisposed()) {
                LocalFileSystem.getInstance().refreshFiles(this.myRoots, false, true, null);
            }
        }));
        VcsFileUtil.markFilesDirty((Project)this.getProject(), this.myRoots);
        if (!this.myExceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.getProject()).showErrors(this.myExceptions.stream().map(pair -> new VcsException(SvnBundle.message("action.Subversion.cleanup.error.message", FileUtil.toSystemDependentName((String)((VirtualFile)pair.second).getPath()), pair.first == null ? "" : ((VcsException)((Object)((Object)pair.first))).getMessage()))).collect(Collectors.toList()), this.getTitle());
        }
    }
}

