/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;

public abstract class BasicAction
extends AnAction
implements DumbAware {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Object[] files = this.getSelectedFiles(e);
        if (ArrayUtil.isEmpty((Object[])files)) {
            return;
        }
        SvnVcs vcs = SvnVcs.getInstance(project);
        if (!ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)vcs, (VirtualFile[])files)) {
            return;
        }
        project.save();
        String actionName = UIUtil.removeMnemonic((String)StringUtil.removeEllipsisSuffix((String)this.getActionName()));
        LocalHistoryAction action = LocalHistory.getInstance().startAction(actionName);
        AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)project);
        try {
            List exceptions = helper.runTransactionRunnable((AbstractVcs)vcs, arg_0 -> this.lambda$actionPerformed$0(vcs, (VirtualFile[])files, e, arg_0), null);
            helper.showErrors(exceptions, actionName);
        }
        finally {
            action.finish();
        }
    }

    protected VirtualFile @Nullable [] getSelectedFiles(@NotNull AnActionEvent e) {
        return (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        SvnVcs vcs = project != null ? SvnVcs.getInstance(project) : null;
        Object[] files = this.getSelectedFiles(e);
        boolean visible = project != null;
        e.getPresentation().setEnabled(visible && vcs != null && !ArrayUtil.isEmpty((Object[])files) && this.isEnabled(vcs, (VirtualFile[])files));
        e.getPresentation().setVisible(visible);
    }

    protected boolean needsAllFiles() {
        return true;
    }

    protected void execute(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) throws VcsException {
        this.perform(vcs, file, context);
        ApplicationManager.getApplication().runWriteAction(() -> file.refresh(false, true));
        this.doVcsRefresh(vcs, file);
    }

    protected void doVcsRefresh(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        VcsDirtyScopeManager.getInstance((Project)vcs.getProject()).fileDirty(file);
    }

    private void batchExecute(@NotNull SvnVcs vcs, VirtualFile @NotNull [] files, @NotNull DataContext context) throws VcsException {
        this.batchPerform(vcs, files, context);
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (VirtualFile file : files) {
                file.refresh(false, true);
            }
        });
        for (VirtualFile file : files) {
            this.doVcsRefresh(vcs, file);
        }
    }

    @NotNull
    @Nls
    protected abstract String getActionName();

    protected boolean isEnabled(@NotNull SvnVcs vcs, VirtualFile @NotNull [] files) {
        Stream<VirtualFile> fileStream = Stream.of(files);
        Predicate<VirtualFile> enabledPredicate = file -> this.isEnabled(vcs, (VirtualFile)file);
        return ProjectLevelVcsManager.getInstance((Project)vcs.getProject()).checkAllFilesAreUnder((AbstractVcs)vcs, files) && (this.needsAllFiles() ? fileStream.allMatch(enabledPredicate) : fileStream.anyMatch(enabledPredicate));
    }

    protected abstract boolean isEnabled(@NotNull SvnVcs var1, @NotNull VirtualFile var2);

    protected abstract void perform(@NotNull SvnVcs var1, @NotNull VirtualFile var2, @NotNull DataContext var3) throws VcsException;

    protected abstract void batchPerform(@NotNull SvnVcs var1, VirtualFile @NotNull [] var2, @NotNull DataContext var3) throws VcsException;

    protected abstract boolean isBatchAction();

    private /* synthetic */ void lambda$actionPerformed$0(SvnVcs vcs, VirtualFile[] files, AnActionEvent e, List exceptionList) {
        VirtualFile badFile = null;
        try {
            if (this.isBatchAction()) {
                this.batchExecute(vcs, files, e.getDataContext());
            } else {
                VirtualFile[] virtualFileArray = files;
                int n = virtualFileArray.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile file;
                    badFile = file = virtualFileArray[i];
                    this.execute(vcs, file, e.getDataContext());
                }
            }
        }
        catch (VcsException ex) {
            ex.setVirtualFile(badFile);
            exceptionList.add(ex);
        }
    }
}

