/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Version;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;

public enum WorkingCopyFormat {
    ONE_DOT_THREE(4, new Version(1, 3, 0)),
    ONE_DOT_FOUR(8, new Version(1, 4, 0)),
    ONE_DOT_FIVE(9, new Version(1, 5, 0)),
    ONE_DOT_SIX(10, new Version(1, 6, 0)),
    ONE_DOT_SEVEN(12, new Version(1, 7, 0)),
    ONE_DOT_EIGHT(12, new Version(1, 8, 0)),
    UNKNOWN(0, new Version(0, 0, 0));

    public static final int INTERNAL_FORMAT_17 = 29;
    public static final int INTERNAL_FORMAT_18 = 31;
    private static final Version ONE_DOT_NINE_VERSION;
    private final int myFormat;
    @NotNull
    private final Version myVersion;

    private WorkingCopyFormat(int format, Version version) {
        this.myFormat = format;
        this.myVersion = version;
    }

    public boolean supportsChangelists() {
        return this.isOrGreater(ONE_DOT_FIVE);
    }

    public boolean supportsMergeInfo() {
        return this.isOrGreater(ONE_DOT_FIVE);
    }

    @NlsSafe
    @NotNull
    public String getName() {
        return this.myVersion.toCompactString();
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return this == UNKNOWN ? SvnBundle.message("label.working.copy.format.unknown", new Object[0]) : this.getName();
    }

    @NotNull
    public Version getVersion() {
        return this.myVersion;
    }

    @NotNull
    public static WorkingCopyFormat getInstance(int value) {
        if (29 == value) {
            return ONE_DOT_SEVEN;
        }
        if (31 == value) {
            return ONE_DOT_EIGHT;
        }
        if (ONE_DOT_FIVE.getFormat() == value) {
            return ONE_DOT_FIVE;
        }
        if (ONE_DOT_FOUR.getFormat() == value) {
            return ONE_DOT_FOUR;
        }
        if (ONE_DOT_THREE.getFormat() == value) {
            return ONE_DOT_THREE;
        }
        if (ONE_DOT_SIX.getFormat() == value) {
            return ONE_DOT_SIX;
        }
        if (ONE_DOT_SEVEN.getFormat() == value) {
            return ONE_DOT_SEVEN;
        }
        return UNKNOWN;
    }

    public int getFormat() {
        return this.myFormat;
    }

    public boolean isOrGreater(@NotNull WorkingCopyFormat format) {
        return this.myVersion.isOrGreaterThan(Integer.valueOf(format.getVersion().major), Integer.valueOf(format.getVersion().minor));
    }

    public boolean less(@NotNull WorkingCopyFormat format) {
        return this.myVersion.lessThan(Integer.valueOf(format.getVersion().major), Integer.valueOf(format.getVersion().minor));
    }

    @NotNull
    public static WorkingCopyFormat from(@NotNull Version version) {
        return version.compareTo(ONE_DOT_NINE_VERSION) >= 0 ? ONE_DOT_EIGHT : Stream.of(WorkingCopyFormat.values()).filter(format -> format.getVersion().is(Integer.valueOf(version.major), Integer.valueOf(version.minor))).findFirst().orElse(UNKNOWN);
    }

    public String toString() {
        return this.getName();
    }

    static {
        ONE_DOT_NINE_VERSION = new Version(1, 9, 0);
    }
}

