/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.ActionWithTempFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RepeatSvnActionThroughBusy;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnChangelistListener;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public class SvnFileSystemListener
implements LocalFileOperationsHandler,
Disposable,
CommandListener {
    private static final Logger LOG = Logger.getInstance(SvnFileSystemListener.class);
    @NotNull
    private final SvnVcs myVcs;
    private final List<AddedFileInfo> myAddedFiles = new ArrayList<AddedFileInfo>();
    private final List<File> myDeletedFiles = new ArrayList<File>();
    private final List<MovedFileInfo> myMovedFiles = new ArrayList<MovedFileInfo>();
    private final List<VcsException> myMoveExceptions = new ArrayList<VcsException>();
    private final List<VirtualFile> myFilesToRefresh = new ArrayList<VirtualFile>();
    @Nullable
    private File myStorageForUndo;
    private final List<Couple<File>> myUndoStorageContents = new ArrayList<Couple<File>>();
    private boolean myUndoingMove = false;
    private boolean myIsInCommand;
    private boolean myIsOperationStarted;

    public SvnFileSystemListener(@NotNull SvnVcs vcs) {
        this.myVcs = vcs;
        LocalFileSystem.getInstance().registerAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(CommandListener.TOPIC, (Object)this);
    }

    public void dispose() {
        LocalFileSystem.getInstance().unregisterAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this);
    }

    private boolean isMyVcs(@NotNull VirtualFile file) {
        return VcsUtil.isFileForVcs((VirtualFile)file, (Project)this.myVcs.getProject(), (AbstractVcs)this.myVcs);
    }

    @NotNull
    private static VcsException handleMoveException(@NotNull VcsException e) {
        return e instanceof SvnBindException && ((SvnBindException)e).contains(ErrorCode.ENTRY_EXISTS) ? SvnFileSystemListener.createMoveTargetExistsError((Exception)((Object)e)) : e;
    }

    @NotNull
    private static VcsException createMoveTargetExistsError(@NotNull Exception e) {
        return new VcsException(Arrays.asList(SvnBundle.message("error.target.of.move.operation.is.already.under.version.control", new Object[0]), SvnBundle.message("error.move.have.not.been.performed", new Object[0]), e.getMessage()));
    }

    @Nullable
    public File copy(@NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull String copyName) {
        if (!this.isMyVcs(toDir)) {
            return null;
        }
        this.startOperation(toDir);
        File srcFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        File destFile = new File(VfsUtilCore.virtualToIoFile((VirtualFile)toDir), copyName);
        if (!SvnUtil.isSvnVersioned(this.myVcs, destFile.getParentFile()) && !this.isPendingAdd(toDir)) {
            return null;
        }
        if (!SvnUtil.isSvnVersioned(this.myVcs, srcFile.getParentFile())) {
            this.myAddedFiles.add(new AddedFileInfo(toDir, copyName, null, false));
            return null;
        }
        Status fileStatus = this.getFileStatus(srcFile);
        if (fileStatus != null && fileStatus.is(StatusType.STATUS_ADDED)) {
            this.myAddedFiles.add(new AddedFileInfo(toDir, copyName, null, false));
            return null;
        }
        if (this.sameRoot(file.getParent(), toDir)) {
            this.myAddedFiles.add(new AddedFileInfo(toDir, copyName, srcFile, false));
            return null;
        }
        this.myAddedFiles.add(new AddedFileInfo(toDir, copyName, null, false));
        return null;
    }

    private boolean sameRoot(@NotNull VirtualFile srcDir, @NotNull VirtualFile dstDir) {
        String srcUUID = this.getRepositoryUUID(srcDir);
        String dstUUID = this.getRepositoryUUID(dstDir);
        return srcUUID != null && srcUUID.equals(dstUUID);
    }

    @Nullable
    private String getRepositoryUUID(final @NotNull VirtualFile dir) {
        block5: {
            try {
                Info info1 = (Info)new RepeatSvnActionThroughBusy(){

                    @Override
                    protected void executeImpl() {
                        this.myT = SvnFileSystemListener.this.myVcs.getInfo(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
                    }
                }.compute();
                if (info1 == null || info1.getRepositoryId() == null) {
                    VirtualFile parent = dir.getParent();
                    if (parent == null) {
                        return null;
                    }
                    if (this.isPendingAdd(parent)) {
                        return this.getRepositoryUUID(parent);
                    }
                    break block5;
                }
                return info1.getRepositoryId();
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean move(@NotNull VirtualFile file, @NotNull VirtualFile toDir) {
        if (!this.isMyVcs(toDir)) {
            return false;
        }
        this.startOperation(toDir);
        if (!this.isMyVcs(file)) {
            return this.createItem(toDir, file.getName(), file.isDirectory(), true);
        }
        File srcFile = SvnFileSystemListener.getIOFile(file);
        File dstFile = new File(SvnFileSystemListener.getIOFile(toDir), file.getName());
        if (this.isPendingAdd(toDir)) {
            this.myMovedFiles.add(new MovedFileInfo(srcFile, dstFile));
            return true;
        }
        this.myFilesToRefresh.add(file.getParent());
        this.myFilesToRefresh.add(toDir);
        return this.doMove(srcFile, dstFile);
    }

    public boolean rename(@NotNull VirtualFile file, @NotNull String newName) {
        if (!this.isMyVcs(file)) {
            return false;
        }
        this.startOperation(file);
        File srcFile = SvnFileSystemListener.getIOFile(file);
        File dstFile = new File(srcFile.getParentFile(), newName);
        this.myFilesToRefresh.add(file.getParent());
        return this.doMove(srcFile, dstFile);
    }

    private boolean doMove(@NotNull File src, @NotNull File dst) {
        try {
            Status srcStatus;
            boolean isUndo = this.isUndo();
            String list = isUndo ? null : SvnChangelistListener.getCurrentMapping(this.myVcs, src);
            WorkingCopyFormat format = this.myVcs.getWorkingCopyFormat(src);
            boolean is17OrLater = format.isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN);
            if (is17OrLater ? SvnFileSystemListener.isUnversioned(srcStatus = this.getFileStatus(src)) && (this.isUnversioned(dst.getParentFile()) || this.isUnversioned(dst)) || this.for17move(src, dst, isUndo, srcStatus) : this.for16move(dst, isUndo)) {
                return false;
            }
            if (!isUndo && list != null) {
                SvnChangelistListener.putUnderList(this.myVcs, list, dst);
            }
        }
        catch (VcsException e) {
            this.myMoveExceptions.add(SvnFileSystemListener.handleMoveException(e));
            return false;
        }
        return true;
    }

    private static boolean isUnversioned(@Nullable Status status) {
        return status == null || status.is(StatusType.STATUS_UNVERSIONED);
    }

    private boolean isUnversioned(@NotNull File file) {
        return SvnFileSystemListener.isUnversioned(this.getFileStatus(file));
    }

    private boolean for17move(File src, File dst, boolean undo, Status srcStatus) throws VcsException {
        if (srcStatus != null && srcStatus.getCopyFromUrl() == null) {
            undo = false;
        }
        if (undo) {
            this.myUndoingMove = true;
            boolean isCaseOnlyMove = FileUtil.filesEqual((File)src, (File)dst);
            this.createRevertAction(isCaseOnlyMove ? src : dst, true).execute();
            SvnFileSystemListener.copyUnversionedMembersOfDirectory(src, dst);
            if (SvnFileSystemListener.isUnversioned(srcStatus)) {
                FileUtil.delete((File)src);
            } else {
                this.createRevertAction(isCaseOnlyMove ? dst : src, true).execute();
            }
            this.restoreFromUndoStorage(dst);
        } else {
            if (this.doUsualMove(src)) {
                return true;
            }
            if (this.isUnversioned(dst.getParentFile())) {
                try {
                    FileUtil.copyFileOrDir((File)src, (File)dst);
                }
                catch (IOException e) {
                    throw new SvnBindException(e);
                }
                this.createDeleteAction(src, true).execute();
                return false;
            }
            SvnFileSystemListener.moveFileWithSvn(this.myVcs, src, dst);
        }
        return false;
    }

    public static void moveFileWithSvn(final SvnVcs vcs, final File src, final File dst) throws VcsException {
        new RepeatSvnActionThroughBusy(){

            @Override
            protected void executeImpl() throws VcsException {
                vcs.getFactory(src).createCopyMoveClient().copy(src, dst, false, true);
            }
        }.execute();
    }

    private static void copyUnversionedMembersOfDirectory(File src, File dst) throws SvnBindException {
        if (src.isDirectory()) {
            SvnBindException[] exc = new SvnBindException[1];
            FileUtil.processFilesRecursively((File)src, file -> {
                String relativePath = FileUtil.getRelativePath((File)src, (File)file);
                File newFile = new File(dst, relativePath);
                if (!newFile.exists()) {
                    try {
                        FileUtil.copyFileOrDir((File)src, (File)dst);
                    }
                    catch (IOException e) {
                        exc[0] = new SvnBindException(e);
                        return false;
                    }
                }
                return true;
            });
            if (exc[0] != null) {
                throw exc[0];
            }
        }
    }

    private boolean doUsualMove(File src) {
        Status srcStatus = this.getFileStatus(src);
        return srcStatus == null || srcStatus.is(StatusType.STATUS_UNVERSIONED, StatusType.STATUS_OBSTRUCTED, StatusType.STATUS_MISSING, StatusType.STATUS_EXTERNAL);
    }

    private boolean for16move(File dst, boolean undo) {
        if (undo) {
            this.myUndoingMove = true;
            this.restoreFromUndoStorage(dst);
        }
        return true;
    }

    private void restoreFromUndoStorage(File dst) {
        File[] files;
        String normPath = FileUtil.toSystemIndependentName((String)dst.getPath());
        Iterator<Couple<File>> it = this.myUndoStorageContents.iterator();
        while (it.hasNext()) {
            Couple<File> e = it.next();
            String p = FileUtil.toSystemIndependentName((String)((File)e.first).getPath());
            if (!p.startsWith(normPath)) continue;
            try {
                FileUtil.rename((File)((File)e.second), (File)((File)e.first));
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
                FileUtil.asyncDelete((File)((File)e.second));
            }
            it.remove();
        }
        if (this.myStorageForUndo != null && ((files = this.myStorageForUndo.listFiles()) == null || files.length == 0)) {
            FileUtil.asyncDelete((File)this.myStorageForUndo);
            this.myStorageForUndo = null;
        }
    }

    public boolean createFile(@NotNull VirtualFile dir, @NotNull String name) {
        if (!this.isMyVcs(dir)) {
            return false;
        }
        this.startOperation(dir);
        return this.createItem(dir, name, false, false);
    }

    public boolean createDirectory(@NotNull VirtualFile dir, @NotNull String name) {
        if (!this.isMyVcs(dir)) {
            return false;
        }
        this.startOperation(dir);
        return this.createItem(dir, name, true, false);
    }

    public boolean delete(@NotNull VirtualFile file) {
        if (!this.isMyVcs(file)) {
            return false;
        }
        this.startOperation(file);
        if (SvnUtil.isAdminDirectory(file)) {
            return true;
        }
        VcsShowConfirmationOption.Value value = this.myVcs.getDeleteConfirmation().getValue();
        if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)value)) {
            return false;
        }
        File ioFile = SvnFileSystemListener.getIOFile(file);
        if (!SvnUtil.isSvnVersioned(this.myVcs, ioFile.getParentFile()) || SvnUtil.isWorkingCopyRoot(ioFile)) {
            return false;
        }
        Status status = this.getFileStatus(ioFile);
        if (status == null || status.is(StatusType.STATUS_UNVERSIONED, StatusType.STATUS_OBSTRUCTED, StatusType.STATUS_EXTERNAL, StatusType.STATUS_IGNORED)) {
            return false;
        }
        if (status.is(StatusType.STATUS_DELETED)) {
            if (this.isUndo()) {
                this.moveToUndoStorage(file);
            }
            return true;
        }
        if (this.isAboveSourceOfCopyOrMove(ioFile)) {
            this.myDeletedFiles.add(ioFile);
            return true;
        }
        if (status.is(StatusType.STATUS_ADDED)) {
            try {
                this.createRevertAction(ioFile, false).execute();
            }
            catch (VcsException vcsException) {}
        } else {
            this.myDeletedFiles.add(ioFile);
            if (file.isDirectory() || this.isUndo()) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private RepeatSvnActionThroughBusy createRevertAction(final @NotNull File file, final boolean recursive) {
        return new RepeatSvnActionThroughBusy(){

            @Override
            protected void executeImpl() throws VcsException {
                SvnFileSystemListener.this.myVcs.getFactory(file).createRevertClient().revert(Collections.singletonList(file), Depth.allOrFiles(recursive), null);
            }
        };
    }

    @NotNull
    private RepeatSvnActionThroughBusy createDeleteAction(final @NotNull File file, final boolean force) {
        return new RepeatSvnActionThroughBusy(){

            @Override
            protected void executeImpl() throws VcsException {
                SvnFileSystemListener.this.myVcs.getFactory(file).createDeleteClient().delete(file, force, false, null);
            }
        };
    }

    private boolean isAboveSourceOfCopyOrMove(File ioFile) {
        for (MovedFileInfo file : this.myMovedFiles) {
            if (!FileUtil.isAncestor((File)ioFile, (File)file.mySrc, (boolean)false)) continue;
            return true;
        }
        for (AddedFileInfo info2 : this.myAddedFiles) {
            if (info2.myCopyFrom == null || !FileUtil.isAncestor((File)ioFile, (File)info2.myCopyFrom, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void moveToUndoStorage(VirtualFile file) {
        if (this.myStorageForUndo == null) {
            try {
                this.myStorageForUndo = FileUtil.createTempDirectory((String)"svnUndoStorage", (String)"");
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return;
            }
        }
        File tmpFile = FileUtil.findSequentNonexistentFile((File)this.myStorageForUndo, (String)"tmp", (String)"");
        this.myUndoStorageContents.add(0, (Couple<File>)Couple.of((Object)VfsUtilCore.virtualToIoFile((VirtualFile)file), (Object)tmpFile));
        VfsUtilCore.virtualToIoFile((VirtualFile)file).renameTo(tmpFile);
    }

    private boolean createItem(VirtualFile dir, String name, boolean directory, boolean recursive) {
        VcsShowConfirmationOption.Value value = this.myVcs.getAddConfirmation().getValue();
        if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)value)) {
            return false;
        }
        if (this.isUndo() && SvnUtil.isAdminDirectory(dir, name)) {
            return false;
        }
        File ioDir = SvnFileSystemListener.getIOFile(dir);
        boolean pendingAdd = this.isPendingAdd(dir);
        if (!SvnUtil.isSvnVersioned(this.myVcs, ioDir) && !pendingAdd) {
            return false;
        }
        File targetFile = new File(ioDir, name);
        Status status = this.getFileStatus(targetFile);
        if (status == null || status.is(StatusType.STATUS_NONE, StatusType.STATUS_UNVERSIONED)) {
            this.myAddedFiles.add(new AddedFileInfo(dir, name, null, recursive));
            return false;
        }
        if (status.is(StatusType.STATUS_MISSING)) {
            return false;
        }
        if (status.is(StatusType.STATUS_DELETED)) {
            NodeKind kind = status.getNodeKind();
            if (directory && !kind.isDirectory() || !directory && !kind.isFile()) {
                return false;
            }
            try {
                if (this.isUndo()) {
                    this.createRevertAction(targetFile, false).execute();
                    return true;
                }
                this.myAddedFiles.add(new AddedFileInfo(dir, name, null, recursive));
                return false;
            }
            catch (VcsException e) {
                FileUtil.delete((File)targetFile);
                return false;
            }
        }
        return false;
    }

    private boolean isPendingAdd(VirtualFile dir) {
        for (AddedFileInfo i : this.myAddedFiles) {
            if (!Comparing.equal((Object)i.myDir, (Object)dir.getParent()) || !i.myName.equals(dir.getName())) continue;
            return true;
        }
        return false;
    }

    public void commandStarted(@NotNull CommandEvent event) {
        this.myIsInCommand = true;
        this.myUndoingMove = false;
        if (this.myVcs.getProject() != event.getProject()) {
            return;
        }
        this.commandStarted();
    }

    private void commandStarted() {
        this.myUndoingMove = false;
        this.myMoveExceptions.clear();
    }

    public void commandFinished(@NotNull CommandEvent event) {
        this.myIsInCommand = false;
        if (this.myVcs.getProject() != event.getProject()) {
            return;
        }
        this.commandFinished();
    }

    private void commandFinished() {
        this.checkOverwrites();
        if (!this.myAddedFiles.isEmpty()) {
            this.processAddedFiles();
        }
        this.processMovedFiles();
        if (!this.myDeletedFiles.isEmpty()) {
            this.processDeletedFiles();
        }
        if (!this.myMoveExceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.myVcs.getProject()).showErrors(this.myMoveExceptions, SvnBundle.message("move.files.errors.title", new Object[0]));
        }
        if (!this.myFilesToRefresh.isEmpty()) {
            this.refreshFiles();
        }
    }

    private void checkOverwrites() {
        if (this.myAddedFiles.isEmpty() || this.myDeletedFiles.isEmpty()) {
            return;
        }
        Iterator<AddedFileInfo> iterator = this.myAddedFiles.iterator();
        while (iterator.hasNext()) {
            AddedFileInfo addedFileInfo = iterator.next();
            File ioFile = new File(addedFileInfo.myDir.getPath(), addedFileInfo.myName);
            if (!this.myDeletedFiles.remove(ioFile)) continue;
            iterator.remove();
        }
    }

    private void refreshFiles() {
        ArrayList<VirtualFile> toRefreshFiles = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> toRefreshDirs = new ArrayList<VirtualFile>();
        for (VirtualFile file : this.myFilesToRefresh) {
            if (file == null) continue;
            if (file.isDirectory()) {
                toRefreshDirs.add(file);
                continue;
            }
            toRefreshFiles.add(file);
        }
        SvnFileSystemListener.filterOutInvalid(this.myFilesToRefresh);
        RefreshQueue.getInstance().refresh(true, true, () -> {
            if (this.myVcs.getProject().isDisposed()) {
                return;
            }
            SvnFileSystemListener.filterOutInvalid(toRefreshFiles);
            SvnFileSystemListener.filterOutInvalid(toRefreshDirs);
            VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject());
            vcsDirtyScopeManager.filesDirty((Collection)toRefreshFiles, (Collection)toRefreshDirs);
        }, this.myFilesToRefresh);
        this.myFilesToRefresh.clear();
    }

    private static void filterOutInvalid(@NotNull Collection<VirtualFile> files) {
        Iterator<VirtualFile> iterator = files.iterator();
        while (iterator.hasNext()) {
            VirtualFile file = iterator.next();
            if (file == null) {
                iterator.remove();
                continue;
            }
            if (file.isValid() && file.exists()) continue;
            LOG.info("Refresh root is not valid: " + file.getPath());
            iterator.remove();
        }
    }

    private void processAddedFiles() {
        ArrayList addedVFiles = new ArrayList();
        HashMap<VirtualFile, File> copyFromMap = new HashMap<VirtualFile, File>();
        HashSet recursiveItems = new HashSet();
        this.fillAddedFiles(addedVFiles, copyFromMap, recursiveItems);
        if (addedVFiles.isEmpty()) {
            return;
        }
        VcsShowConfirmationOption.Value value = this.myVcs.getAddConfirmation().getValue();
        if (value != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            this.runNotUnderWriteAction(() -> {
                AbstractVcsHelper vcsHelper = AbstractVcsHelper.getInstance((Project)this.myVcs.getProject());
                Collection<VirtualFile> filesToProcess = this.promptAboutAddition(addedVFiles, value, vcsHelper);
                if (filesToProcess != null && !filesToProcess.isEmpty()) {
                    ArrayList exceptions = new ArrayList();
                    this.runInBackground(SvnBundle.message("progress.title.adding.files.to.subversion", new Object[0]), this.createAdditionRunnable(copyFromMap, filesToProcess, exceptions));
                    if (!exceptions.isEmpty()) {
                        vcsHelper.showErrors(exceptions, SvnBundle.message("add.files.errors.title", new Object[0]));
                    }
                }
            });
        }
    }

    private void runNotUnderWriteAction(@NotNull Runnable runnable) {
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed()) {
            application.invokeLater(runnable, this.myVcs.getProject().getDisposed());
        } else {
            runnable.run();
        }
    }

    private void runInBackground(@NlsContexts.ProgressTitle @NotNull String name, @NotNull Runnable runnable) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, name, false, this.myVcs.getProject());
        } else {
            runnable.run();
        }
    }

    private Runnable createAdditionRunnable(Map<VirtualFile, File> copyFromMap, Collection<? extends VirtualFile> filesToProcess, List<? super VcsException> exceptions) {
        return () -> {
            for (VirtualFile file : filesToProcess) {
                final File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                try {
                    final File copyFrom = (File)copyFromMap.get(file);
                    if (copyFrom != null) {
                        try {
                            new ActionWithTempFile(ioFile){

                                protected void executeInternal() throws VcsException {
                                    new RepeatSvnActionThroughBusy(){

                                        @Override
                                        protected void executeImpl() throws VcsException {
                                            SvnFileSystemListener.this.myVcs.getFactory(copyFrom).createCopyMoveClient().copy(copyFrom, ioFile, true, false);
                                        }
                                    }.execute();
                                }
                            }.execute();
                        }
                        catch (VcsException e) {
                            exceptions.add(e);
                        }
                    } else {
                        new RepeatSvnActionThroughBusy(){

                            @Override
                            protected void executeImpl() throws VcsException {
                                SvnFileSystemListener.this.myVcs.getFactory(ioFile).createAddClient().add(ioFile, null, false, false, true, null);
                            }
                        }.execute();
                    }
                    VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject()).fileDirty(file);
                }
                catch (VcsException e) {
                    exceptions.add(e);
                }
            }
        };
    }

    private Collection<VirtualFile> promptAboutAddition(List<VirtualFile> addedVFiles, VcsShowConfirmationOption.Value value, AbstractVcsHelper vcsHelper) {
        Collection<Object> filesToProcess;
        if (value == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            filesToProcess = addedVFiles;
        } else {
            String singleFilePrompt = addedVFiles.size() == 1 && addedVFiles.get(0).isDirectory() ? SvnBundle.message("confirmation.text.add.dir", new Object[0]) : SvnBundle.message("confirmation.text.add.file", new Object[0]);
            filesToProcess = vcsHelper.selectFilesToProcess(addedVFiles, SvnBundle.message("confirmation.title.add.multiple.files", new Object[0]), null, SvnBundle.message("confirmation.title.add.file", new Object[0]), singleFilePrompt, this.myVcs.getAddConfirmation());
        }
        return filesToProcess;
    }

    private void fillAddedFiles(List<? super VirtualFile> addedVFiles, Map<VirtualFile, File> copyFromMap, Set<? super VirtualFile> recursiveItems) {
        ArrayList<AddedFileInfo> addedFileInfos = new ArrayList<AddedFileInfo>(this.myAddedFiles);
        this.myAddedFiles.clear();
        for (AddedFileInfo addedFileInfo : addedFileInfos) {
            boolean isIgnored;
            Status fileStatus;
            File ioFile = new File(SvnFileSystemListener.getIOFile(addedFileInfo.myDir), addedFileInfo.myName);
            VirtualFile addedFile = addedFileInfo.myDir.findChild(addedFileInfo.myName);
            if (addedFile == null) {
                addedFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
            }
            if (addedFile == null || (fileStatus = this.getFileStatus(ioFile)) != null && fileStatus.is(StatusType.STATUS_IGNORED) || (isIgnored = ChangeListManager.getInstance((Project)this.myVcs.getProject()).isIgnoredFile(addedFile))) continue;
            addedVFiles.add((VirtualFile)addedFile);
            copyFromMap.put(addedFile, addedFileInfo.myCopyFrom);
            if (!addedFileInfo.myRecursive) continue;
            recursiveItems.add((VirtualFile)addedFile);
        }
    }

    private void processDeletedFiles() {
        ArrayList deletedFiles = new ArrayList();
        ArrayList<FilePath> filesToProcess = new ArrayList<FilePath>();
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        AbstractVcsHelper vcsHelper = AbstractVcsHelper.getInstance((Project)this.myVcs.getProject());
        try {
            this.fillDeletedFiles(deletedFiles, filesToProcess);
            if (deletedFiles.isEmpty() && filesToProcess.isEmpty() || this.myUndoingMove) {
                return;
            }
            VcsShowConfirmationOption.Value value = this.myVcs.getDeleteConfirmation().getValue();
            if (value != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
                Collection<FilePath> confirmed;
                if (!deletedFiles.isEmpty() && (confirmed = this.promptAboutDeletion(deletedFiles, value, vcsHelper)) != null) {
                    filesToProcess.addAll(confirmed);
                }
                if (!filesToProcess.isEmpty()) {
                    this.runInBackground(SvnBundle.message("progress.title.deleting.files.from.subversion", new Object[0]), this.createDeleteRunnable(filesToProcess, exceptions));
                }
                List deletedFilesFiles = ContainerUtil.map(deletedFiles, (Function)Functions.pairFirst());
                for (FilePath file : deletedFilesFiles) {
                    FilePath parent = file.getParentPath();
                    if (parent == null) continue;
                    this.myFilesToRefresh.add(parent.getVirtualFile());
                }
                deletedFilesFiles.removeAll(filesToProcess);
                for (FilePath file : deletedFilesFiles) {
                    FileUtil.delete((File)file.getIOFile());
                }
            }
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            vcsHelper.showErrors(exceptions, SvnBundle.message("delete.files.errors.title", new Object[0]));
        }
    }

    private Runnable createDeleteRunnable(Collection<? extends FilePath> filesToProcess, List<? super VcsException> exceptions) {
        return () -> {
            for (FilePath file : filesToProcess) {
                VirtualFile vFile = file.getVirtualFile();
                File ioFile = new File(file.getPath());
                try {
                    this.createDeleteAction(ioFile, true).execute();
                    if (vFile != null && vFile.isValid() && vFile.isDirectory()) {
                        vFile.refresh(true, true);
                        VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject()).dirDirtyRecursively(vFile);
                        continue;
                    }
                    VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject()).fileDirty(file);
                }
                catch (VcsException e) {
                    exceptions.add(e);
                }
            }
        };
    }

    private Collection<FilePath> promptAboutDeletion(List<? extends Pair<FilePath, WorkingCopyFormat>> deletedFiles, VcsShowConfirmationOption.Value value, AbstractVcsHelper vcsHelper) {
        List filesToProcess;
        if (value == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            filesToProcess = ContainerUtil.map(deletedFiles, (Function)Functions.pairFirst());
        } else {
            String singleFilePrompt = deletedFiles.size() == 1 && ((FilePath)deletedFiles.get(0).getFirst()).isDirectory() ? (((WorkingCopyFormat)((Object)deletedFiles.get(0).getSecond())).isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN) ? SvnBundle.message("confirmation.text.delete.dir.17", new Object[0]) : SvnBundle.message("confirmation.text.delete.dir", new Object[0])) : SvnBundle.message("confirmation.text.delete.file", new Object[0]);
            Collection files = vcsHelper.selectFilePathsToProcess(ContainerUtil.map(deletedFiles, (Function)Functions.pairFirst()), SvnBundle.message("confirmation.title.delete.multiple.files", new Object[0]), null, SvnBundle.message("confirmation.title.delete.file", new Object[0]), singleFilePrompt, this.myVcs.getDeleteConfirmation());
            filesToProcess = files == null ? null : new ArrayList(files);
        }
        return filesToProcess;
    }

    private void fillDeletedFiles(List<? super Pair<FilePath, WorkingCopyFormat>> deletedFiles, Collection<? super FilePath> deleteAnyway) throws VcsException {
        ArrayList<File> files = new ArrayList<File>(this.myDeletedFiles);
        this.myDeletedFiles.clear();
        for (final File file : files) {
            Status status = (Status)new RepeatSvnActionThroughBusy(){

                @Override
                protected void executeImpl() throws VcsException {
                    this.myT = SvnFileSystemListener.this.myVcs.getFactory(file).createStatusClient().doStatus(file, false);
                }
            }.compute();
            FilePath filePath = VcsUtil.getFilePath((File)file);
            if (status.is(StatusType.STATUS_ADDED)) {
                deleteAnyway.add((FilePath)filePath);
                continue;
            }
            deletedFiles.add((Pair<FilePath, WorkingCopyFormat>)Pair.create((Object)filePath, (Object)((Object)this.myVcs.getWorkingCopyFormat(file))));
        }
    }

    private void processMovedFiles() {
        if (this.myMovedFiles.isEmpty()) {
            return;
        }
        Runnable runnable = () -> {
            Iterator<MovedFileInfo> iterator = this.myMovedFiles.iterator();
            while (iterator.hasNext()) {
                MovedFileInfo movedFileInfo = iterator.next();
                this.doMove(movedFileInfo.mySrc, movedFileInfo.myDst);
                iterator.remove();
            }
        };
        this.runInBackground(SvnBundle.message("progress.title.moving.files.in.subversion", new Object[0]), runnable);
    }

    @NotNull
    private static File getIOFile(@NotNull VirtualFile vf) {
        return VfsUtilCore.virtualToIoFile((VirtualFile)vf).getAbsoluteFile();
    }

    @Nullable
    private Status getFileStatus(final @NotNull File file) {
        try {
            return (Status)new RepeatSvnActionThroughBusy(){

                @Override
                protected void executeImpl() throws VcsException {
                    this.myT = SvnFileSystemListener.this.myVcs.getFactory(file).createStatusClient().doStatus(file, false);
                }
            }.compute();
        }
        catch (VcsException e) {
            return null;
        }
    }

    private boolean isUndo() {
        return UndoManager.getInstance((Project)this.myVcs.getProject()).isUndoInProgress();
    }

    private void startOperation(@NotNull VirtualFile file) {
        if (!this.myIsInCommand) {
            boolean bl = this.myIsOperationStarted = this.myVcs.getProject() == ProjectLocator.getInstance().guessProjectForFile(file);
            if (this.myIsOperationStarted) {
                this.commandStarted();
            }
        }
    }

    public void afterDone(@NotNull ThrowableConsumer<? super LocalFileOperationsHandler, ? extends IOException> invoker) {
        if (!this.myIsInCommand && this.myIsOperationStarted) {
            this.commandFinished();
        }
    }

    private static class AddedFileInfo {
        private final VirtualFile myDir;
        private final String myName;
        @Nullable
        private final File myCopyFrom;
        private final boolean myRecursive;

        AddedFileInfo(@NotNull VirtualFile dir, @NotNull String name, @Nullable File copyFrom, boolean recursive) {
            this.myDir = dir;
            this.myName = name;
            this.myCopyFrom = copyFrom;
            this.myRecursive = recursive;
        }
    }

    private static final class MovedFileInfo {
        private final File mySrc;
        private final File myDst;

        private MovedFileInfo(@NotNull File src, @NotNull File dst) {
            this.mySrc = src;
            this.myDst = dst;
        }
    }
}

