/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffMixin;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.DiffProviderEx;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionDescriptionImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LatestExistentSearcher;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.info.InfoConsumer;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public class SvnDiffProvider
extends DiffProviderEx
implements DiffProvider,
DiffMixin {
    private static final Logger LOG = Logger.getInstance(SvnDiffProvider.class);
    public static final String COMMIT_MESSAGE = "svn:log";
    private static final int BATCH_INFO_SIZE = 20;
    @NotNull
    private final SvnVcs myVcs;

    public SvnDiffProvider(@NotNull SvnVcs vcs) {
        this.myVcs = vcs;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision(@NotNull VirtualFile file) {
        Info svnInfo = this.myVcs.getInfo(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        return SvnDiffProvider.getRevision(svnInfo);
    }

    @Nullable
    private static VcsRevisionNumber getRevision(@Nullable Info info2) {
        SvnRevisionNumber result = null;
        if (info2 != null) {
            Revision revision = !info2.getCommitInfo().getRevision().isValid() && info2.getCopyFromRevision().isValid() ? info2.getCopyFromRevision() : info2.getRevision();
            result = new SvnRevisionNumber(revision);
        }
        return result;
    }

    @NotNull
    public Map<VirtualFile, VcsRevisionNumber> getCurrentRevisions(@NotNull Iterable<? extends VirtualFile> files) {
        HashMap<VirtualFile, VcsRevisionNumber> result = new HashMap<VirtualFile, VcsRevisionNumber>();
        HashMap<String, VirtualFile> items = new HashMap<String, VirtualFile>();
        ArrayList<File> ioFiles = new ArrayList<File>();
        for (VirtualFile virtualFile : files) {
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            ioFiles.add(ioFile);
            items.put(ioFile.getAbsolutePath(), virtualFile);
            if (items.size() != 20) continue;
            this.collectRevisionsInBatch(result, items, ioFiles);
            items.clear();
            ioFiles.clear();
        }
        this.collectRevisionsInBatch(result, items, ioFiles);
        return result;
    }

    private void collectRevisionsInBatch(@NotNull Map<VirtualFile, VcsRevisionNumber> revisionMap, @NotNull Map<String, VirtualFile> fileMap, @NotNull List<File> ioFiles) {
        this.myVcs.collectInfo(ioFiles, SvnDiffProvider.createInfoHandler(revisionMap, fileMap));
    }

    @NotNull
    private static InfoConsumer createInfoHandler(@NotNull Map<VirtualFile, VcsRevisionNumber> revisionMap, @NotNull Map<String, VirtualFile> fileMap) {
        return info2 -> {
            if (info2 != null) {
                VirtualFile file = (VirtualFile)fileMap.get(info2.getFile().getAbsolutePath());
                if (file != null) {
                    revisionMap.put(file, SvnDiffProvider.getRevision(info2));
                } else {
                    LOG.info("Could not find virtual file for path " + info2.getFile().getAbsolutePath());
                }
            }
        };
    }

    @Nullable
    public VcsRevisionDescription getCurrentRevisionDescription(@NotNull VirtualFile file) {
        return this.getCurrentRevisionDescription(VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    @Nullable
    private VcsRevisionDescription getCurrentRevisionDescription(@NotNull File path) {
        File localPath;
        Info svnInfo = this.myVcs.getInfo(path);
        if (svnInfo == null) {
            return null;
        }
        if (!svnInfo.getCommitInfo().getRevision().isValid() && svnInfo.getCopyFromRevision().isValid() && svnInfo.getCopyFromUrl() != null && (localPath = this.myVcs.getSvnFileUrlMapping().getLocalPath(svnInfo.getCopyFromUrl())) != null) {
            return this.getCurrentRevisionDescription(localPath);
        }
        return new VcsRevisionDescriptionImpl((VcsRevisionNumber)new SvnRevisionNumber(svnInfo.getCommitInfo().getRevision()), svnInfo.getCommitInfo().getDate(), svnInfo.getCommitInfo().getAuthor(), this.getCommitMessage(path, svnInfo));
    }

    @Nullable
    private String getCommitMessage(@NotNull File path, @NotNull Info info2) {
        String result;
        try {
            PropertyValue property = this.myVcs.getFactory(path).createPropertyClient().getProperty(Target.on(path), COMMIT_MESSAGE, true, info2.getCommitInfo().getRevision());
            result = PropertyValue.toString(property);
        }
        catch (VcsException e) {
            LOG.info("Failed to get commit message for file " + path + ", " + info2.getCommitInfo().getRevision() + ", " + info2.getRevision(), (Throwable)e);
            result = "";
        }
        return result;
    }

    @NotNull
    private static ItemLatestState defaultResult() {
        return SvnDiffProvider.createResult(Revision.HEAD, true, true);
    }

    @NotNull
    private static ItemLatestState createResult(@NotNull Revision revision, boolean exists, boolean defaultHead) {
        return new ItemLatestState((VcsRevisionNumber)new SvnRevisionNumber(revision), exists, defaultHead);
    }

    @NotNull
    public ItemLatestState getLastRevision(@NotNull VirtualFile file) {
        return this.getLastRevision(VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    @NotNull
    public ContentRevision createFileContent(@NotNull VcsRevisionNumber revisionNumber, @NotNull VirtualFile selectedFile) {
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)selectedFile);
        Revision revision = ((SvnRevisionNumber)revisionNumber).getRevision();
        if (!Revision.HEAD.equals(revision) && revisionNumber.equals(this.getCurrentRevision(selectedFile))) {
            return SvnContentRevision.createBaseRevision(this.myVcs, filePath, revision);
        }
        Status svnStatus = this.getFileStatus(VfsUtilCore.virtualToIoFile((VirtualFile)selectedFile), false);
        return svnStatus != null && revision.equals(svnStatus.getRevision()) ? SvnContentRevision.createBaseRevision(this.myVcs, filePath, revision) : SvnContentRevision.createRemote(this.myVcs, filePath, revision);
    }

    @Nullable
    private Status getFileStatus(@NotNull File file, boolean remote) {
        Status result = null;
        try {
            result = this.myVcs.getFactory(file).createStatusClient().doStatus(file, remote);
        }
        catch (SvnBindException e) {
            LOG.debug((Throwable)((Object)e));
        }
        return result;
    }

    @NotNull
    public ItemLatestState getLastRevision(@NotNull FilePath filePath) {
        return this.getLastRevision(filePath.getIOFile());
    }

    @Nullable
    public VcsRevisionNumber getLatestCommittedRevision(@NotNull VirtualFile vcsRoot) {
        Info info2 = this.myVcs.getInfo(VfsUtilCore.virtualToIoFile((VirtualFile)vcsRoot), Revision.HEAD);
        return info2 != null ? new SvnRevisionNumber(info2.getCommitInfo().getRevision()) : null;
    }

    @NotNull
    private ItemLatestState getLastRevision(@NotNull File file) {
        Status svnStatus = this.getFileStatus(file, true);
        if (svnStatus == null || SvnDiffProvider.itemExists(svnStatus)) {
            Info info2 = this.myVcs.getInfo(file, Revision.HEAD);
            if (info2 == null || info2.getUrl() == null) {
                LOG.info("No SVN status returned for " + file.getPath());
                return SvnDiffProvider.defaultResult();
            }
            return SvnDiffProvider.createResult(info2.getCommitInfo().getRevision(), true, false);
        }
        return SvnDiffProvider.createResult(this.getLastExistingRevision(file, svnStatus), false, false);
    }

    @NotNull
    private Revision getLastExistingRevision(@NotNull File file, @NotNull Status svnStatus) {
        WorkingCopyFormat format = this.myVcs.getWorkingCopyFormat(file);
        long revision = -1L;
        if (format.less(WorkingCopyFormat.ONE_DOT_EIGHT)) {
            if (svnStatus.getRepositoryRootUrl() != null) {
                revision = new LatestExistentSearcher(this.myVcs, svnStatus.getUrl(), svnStatus.getRepositoryRootUrl()).getDeletionRevision();
            } else {
                LOG.info("Could not find repository url for file " + file);
            }
        }
        return Revision.of(revision);
    }

    private static boolean itemExists(@NotNull Status svnStatus) {
        return !StatusType.STATUS_DELETED.equals((Object)svnStatus.getRemoteItemStatus());
    }
}

