/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableBase;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.io.File;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.GeneralSettingsPanel;
import org.jetbrains.idea.svn.NetworkSettingsPanel;
import org.jetbrains.idea.svn.PresentationSettingsPanel;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.dialogs.SshSettingsPanel;

public abstract class SvnConfigurable
extends ConfigurableBase<ConfigurableUi<SvnConfiguration>, SvnConfiguration> {
    @NonNls
    private static final String ID = "vcs.Subversion";
    @NonNls
    private static final String HELP_ID = "project.propSubversion";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Supplier<? extends ConfigurableUi<SvnConfiguration>> myUiSupplier;

    @NlsContexts.ConfigurableName
    @NotNull
    public static String getGroupDisplayName() {
        return "Subversion";
    }

    protected SvnConfigurable(@NotNull Project project, @NonNls @NotNull String idSuffix, @NlsContexts.ConfigurableName @NotNull String displayName, @NotNull Supplier<? extends ConfigurableUi<SvnConfiguration>> uiSupplier) {
        this(project, "vcs.Subversion." + idSuffix, displayName, uiSupplier, "project.propSubversion." + idSuffix);
    }

    protected SvnConfigurable(@NotNull Project project, @NonNls @NotNull String id, @NlsContexts.ConfigurableName @NotNull String displayName, @NotNull Supplier<? extends ConfigurableUi<SvnConfiguration>> uiSupplier, @NonNls @NotNull String helpId) {
        super(id, displayName, helpId);
        this.myProject = project;
        this.myUiSupplier = uiSupplier;
    }

    protected ConfigurableUi<SvnConfiguration> createUi() {
        return this.myUiSupplier.get();
    }

    @NotNull
    protected SvnConfiguration getSettings() {
        return SvnConfiguration.getInstance(this.myProject);
    }

    public static void selectConfigurationDirectory(@NotNull String path, @NotNull Consumer<? super String> dirConsumer, Project project, @Nullable Component component) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(SvnBundle.message("dialog.title.select.configuration.directory", new Object[0])).withDescription(SvnBundle.message("dialog.description.select.configuration.directory", new Object[0])).withShowFileSystemRoots(true).withHideIgnored(false).withShowHiddenFiles(true);
        path = "file://" + ((String)path).replace(File.separatorChar, '/');
        VirtualFile root = VirtualFileManager.getInstance().findFileByUrl((String)path);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)component, (Project)project, (VirtualFile)root);
        if (file == null) {
            return;
        }
        String resultPath = file.getPath().replace('/', File.separatorChar);
        dirConsumer.consume((Object)resultPath);
    }

    public static class Ssh
    extends SvnConfigurable {
        public Ssh(@NotNull Project project) {
            super(project, "SSH", SvnBundle.message("configurable.name.svn.ssh", new Object[0]), () -> new SshSettingsPanel(project));
        }
    }

    public static class Network
    extends SvnConfigurable {
        public Network(@NotNull Project project) {
            super(project, "Network", SvnBundle.message("configurable.name.svn.network", new Object[0]), () -> new NetworkSettingsPanel(project));
        }
    }

    public static class Presentation
    extends SvnConfigurable {
        public Presentation(@NotNull Project project) {
            super(project, "Presentation", SvnBundle.message("configurable.name.svn.presentation", new Object[0]), () -> new PresentationSettingsPanel(project));
        }
    }

    public static class General
    extends SvnConfigurable {
        public General(@NotNull Project project) {
            super(project, SvnConfigurable.ID, General.getGroupDisplayName(), () -> new GeneralSettingsPanel(project), SvnConfigurable.HELP_ID);
        }
    }
}

