/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopiesBuilder;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnChangeProviderContext;
import org.jetbrains.idea.svn.SvnChangedFile;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnRecursiveStatusWalker;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.CleanupWorker;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnExceptionWrapper;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public class SvnChangeProvider
implements ChangeProvider {
    private static final Logger LOG = Logger.getInstance(SvnChangeProvider.class);
    @NonNls
    public static final String PROPERTY_LAYER = "Property";
    @NotNull
    private final SvnVcs myVcs;

    public SvnChangeProvider(@NotNull SvnVcs vcs) {
        this.myVcs = vcs;
    }

    public void getChanges(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder, @NotNull ProgressIndicator progress, @NotNull ChangeListManagerGate addGate) throws VcsException {
        try {
            SvnChangeProviderContext context = new SvnChangeProviderContext(this.myVcs, builder, progress);
            NestedCopiesBuilder nestedCopiesBuilder = new NestedCopiesBuilder(this.myVcs);
            EventDispatcher statusReceiver = EventDispatcher.create(StatusReceiver.class);
            statusReceiver.addListener((EventListener)context);
            statusReceiver.addListener((EventListener)nestedCopiesBuilder);
            SvnRecursiveStatusWalker walker = new SvnRecursiveStatusWalker(this.myVcs, (StatusReceiver)statusReceiver.getMulticaster(), progress);
            for (FilePath path : dirtyScope.getRecursivelyDirtyDirectories()) {
                walker.go(path, Depth.INFINITY);
            }
            for (FilePath path : ContainerUtil.map2SetNotNull((Collection)dirtyScope.getDirtyFilesNoExpand(), it -> it.isDirectory() ? it : it.getParentPath())) {
                walker.go(path, Depth.IMMEDIATES);
            }
            ((StatusReceiver)statusReceiver.getMulticaster()).finish();
            this.processCopiedAndDeleted(context, dirtyScope);
            SvnChangeProvider.processUnsaved(dirtyScope, addGate, context);
            this.myVcs.getSvnFileUrlMappingImpl().acceptNestedData(nestedCopiesBuilder.getCopies());
        }
        catch (SvnExceptionWrapper e) {
            LOG.info((Throwable)e);
            throw new VcsException(e.getCause());
        }
    }

    private static void processUnsaved(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangeListManagerGate addGate, @NotNull SvnChangeProviderContext context) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document unsavedDocument : fileDocumentManager.getUnsavedDocuments()) {
            FileStatus status;
            VirtualFile file = fileDocumentManager.getFile(unsavedDocument);
            if (file == null || !dirtyScope.belongsTo(VcsUtil.getFilePath((VirtualFile)file)) || !fileDocumentManager.isFileModified(file) || (status = addGate.getStatus(file)) != null && !FileStatus.NOT_CHANGED.equals(status)) continue;
            context.addModifiedNotSavedChange(file);
        }
    }

    private void processCopiedAndDeleted(@NotNull SvnChangeProviderContext context, @Nullable VcsDirtyScope dirtyScope) {
        for (SvnChangedFile copiedFile : context.getCopiedFiles()) {
            context.checkCanceled();
            this.processCopiedFile(copiedFile, context, dirtyScope);
        }
        for (SvnChangedFile deletedFile : context.getDeletedFiles()) {
            context.checkCanceled();
            context.processStatus(deletedFile.getFilePath(), deletedFile.getStatus());
        }
    }

    public void getChanges(@NotNull FilePath path, boolean recursive, @NotNull ChangelistBuilder builder) throws SvnBindException {
        SvnChangeProviderContext context = new SvnChangeProviderContext(this.myVcs, builder, null);
        SvnRecursiveStatusWalker walker = new SvnRecursiveStatusWalker(this.myVcs, context, ProgressManager.getInstance().getProgressIndicator());
        walker.go(path, recursive ? Depth.INFINITY : Depth.IMMEDIATES);
        this.processCopiedAndDeleted(context, null);
    }

    private void processCopiedFile(@NotNull SvnChangedFile copiedFile, @NotNull SvnChangeProviderContext context, @Nullable VcsDirtyScope dirtyScope) {
        File wcPath;
        boolean foundRename;
        Url copyFromURL = Objects.requireNonNull(copiedFile.getCopyFromURL());
        SvnChangedFile movedFromFile = (SvnChangedFile)ContainerUtil.find(context.getDeletedFiles(), it -> copyFromURL.equals(it.getStatus().getUrl()));
        if (movedFromFile != null) {
            HashSet<SvnChangedFile> movedFiles = new HashSet<SvnChangedFile>();
            String changeListName = SvnUtil.getChangelistName(copiedFile.getStatus());
            this.applyMovedChange(context, copiedFile.getFilePath(), dirtyScope, movedFiles, movedFromFile, copiedFile.getStatus(), changeListName);
            for (SvnChangedFile svnChangedFile : context.getDeletedFiles()) {
                Url childUrl;
                if (movedFromFile == svnChangedFile || (childUrl = svnChangedFile.getStatus().getUrl()) == null || !SvnUtil.isAncestor(copyFromURL, childUrl)) continue;
                String relativePath = SvnUtil.getRelativeUrl(copyFromURL, childUrl);
                File newPath = new File(copiedFile.getFilePath().getIOFile(), relativePath);
                FilePath newFilePath = VcsUtil.getFilePath((File)newPath);
                if (context.isDeleted(newFilePath)) continue;
                this.applyMovedChange(context, newFilePath, dirtyScope, movedFiles, svnChangedFile, context.getTreeConflictStatus(newPath), changeListName);
            }
            List<SvnChangedFile> deletedFiles = context.getDeletedFiles();
            for (SvnChangedFile file : movedFiles) {
                deletedFiles.remove(file);
            }
        }
        boolean bl = foundRename = movedFromFile != null;
        if (!foundRename && copiedFile.getStatus().getUrl() != null && (wcPath = this.myVcs.getSvnFileUrlMapping().getLocalPath(copyFromURL)) != null) {
            Status status;
            try {
                status = this.myVcs.getFactory(wcPath).createStatusClient().doStatus(wcPath, false);
            }
            catch (SvnBindException svnBindException) {
                LOG.info((Throwable)((Object)svnBindException));
                status = null;
            }
            if (status != null && status.is(StatusType.STATUS_DELETED)) {
                FilePath filePath = VcsUtil.getFilePath((File)wcPath, (boolean)status.isDirectory());
                SvnContentRevision beforeRevision = SvnContentRevision.createBaseRevision(this.myVcs, filePath, status.getRevision());
                ContentRevision afterRevision = CurrentContentRevision.create((FilePath)copiedFile.getFilePath());
                context.getBuilder().processChangeInList(context.createMovedChange(beforeRevision, afterRevision, copiedFile.getStatus(), status), SvnUtil.getChangelistName(status), SvnVcs.getKey());
                foundRename = true;
            }
        }
        if (!foundRename) {
            LOG.info("Rename not found for " + copiedFile.getFilePath().getPresentableUrl());
            context.processStatus(copiedFile.getFilePath(), copiedFile.getStatus());
        }
    }

    private void applyMovedChange(@NotNull SvnChangeProviderContext context, @NotNull FilePath oldPath, @Nullable VcsDirtyScope dirtyScope, @NotNull Set<SvnChangedFile> movedFiles, @NotNull SvnChangedFile deletedFile, @Nullable Status copiedStatus, @Nullable String clName) {
        boolean isUnder;
        FilePath filePath = VcsUtil.getFilePath((File)deletedFile.getStatus().getFile(), (boolean)deletedFile.getFilePath().isDirectory());
        SvnContentRevision beforeRevision = SvnContentRevision.createBaseRevision(this.myVcs, filePath, deletedFile.getStatus().getRevision());
        ContentRevision afterRevision = CurrentContentRevision.create((FilePath)oldPath);
        Change change = context.createMovedChange(beforeRevision, afterRevision, copiedStatus, deletedFile.getStatus());
        boolean bl = isUnder = dirtyScope == null || (Boolean)ReadAction.compute(() -> ChangeListManagerImpl.isUnder((Change)change, (VcsDirtyScope)dirtyScope)) != false;
        if (isUnder) {
            context.getBuilder().removeRegisteredChangeFor(oldPath);
            context.getBuilder().processChangeInList(change, clName, SvnVcs.getKey());
            movedFiles.add(deletedFile);
        }
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public void doCleanup(@NotNull List<VirtualFile> files) {
        new CleanupWorker(this.myVcs, files).execute();
    }
}

