/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsMappingListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifier;
import org.jetbrains.idea.svn.info.Info;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0006\u0010\u001c\u001a\u00020\u0019J\b\u0010\u001d\u001a\u00020\u0019H\u0002J\b\u0010\u001e\u001a\u00020\u0019H\u0016J\b\u0010\u001f\u001a\u00020\u0019H\u0016J\u0014\u0010 \u001a\u0004\u0018\u00010\u000f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\u0012\u0010#\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u000eH\u0007J\u001c\u0010$\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u000e2\b\u0010%\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lorg/jetbrains/idea/svn/RootsToWorkingCopies;", "Lcom/intellij/openapi/vcs/VcsMappingListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myLock", "", "myQueue", "Lcom/intellij/openapi/progress/BackgroundTaskQueue;", "myRechecker", "Ljava/lang/Runnable;", "myRootMapping", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/idea/svn/WorkingCopy;", "myUnversioned", "", "myZipperUpdater", "Lcom/intellij/openapi/util/ZipperUpdater;", "vcs", "Lorg/jetbrains/idea/svn/SvnVcs;", "getVcs", "()Lorg/jetbrains/idea/svn/SvnVcs;", "addRoot", "", "root", "calculateRoot", "clear", "clearData", "directoryMappingChanged", "dispose", "getMatchingCopy", "url", "Lorg/jetbrains/idea/svn/api/Url;", "getWcRoot", "registerWorkingCopy", "resolvedWorkingCopy", "Companion", "intellij.vcs.svn"})
public final class RootsToWorkingCopies
implements VcsMappingListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Object myLock;
    @NotNull
    private final Map<VirtualFile, WorkingCopy> myRootMapping;
    @NotNull
    private final Set<VirtualFile> myUnversioned;
    @NotNull
    private final BackgroundTaskQueue myQueue;
    @NotNull
    private final ZipperUpdater myZipperUpdater;
    @NotNull
    private final Runnable myRechecker;

    public RootsToWorkingCopies(@NotNull Project project) {
        this.project = project;
        this.myLock = new Object();
        this.myRootMapping = new LinkedHashMap();
        this.myUnversioned = new LinkedHashSet();
        this.myQueue = new BackgroundTaskQueue(this.project, SvnBundle.message("progress.title.svn.roots.authorization.checker", new Object[0]));
        this.myZipperUpdater = new ZipperUpdater(200, (Disposable)this);
        this.myRechecker = () -> RootsToWorkingCopies.myRechecker$lambda$0(this);
        this.project.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
    }

    private final SvnVcs getVcs() {
        return SvnVcs.getInstance(this.project);
    }

    private final void addRoot(VirtualFile root) {
        Project project = this.project;
        Object[] objectArray = new Object[]{root.getPath()};
        String string = SvnBundle.message("progress.title.looking.for.file.working.copy.root", objectArray);
        this.myQueue.run(new Task.Backgroundable(this, root, project, string){
            final /* synthetic */ RootsToWorkingCopies this$0;
            final /* synthetic */ VirtualFile $root;
            {
                this.this$0 = $receiver;
                this.$root = $root;
                super($super_call_param$1, $super_call_param$2, false);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                RootsToWorkingCopies.access$calculateRoot(this.this$0, this.$root);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresBackgroundThread
    @Nullable
    public final WorkingCopy getMatchingCopy(@Nullable Url url) {
        boolean bl;
        boolean bl2 = bl = !ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (url == null) {
            return null;
        }
        VirtualFile[] roots = ProjectLevelVcsManager.getInstance((Project)this.project).getRootsUnderVcs((AbstractVcs)this.getVcs());
        Object object = this.myLock;
        synchronized (object) {
            boolean bl3 = false;
            VirtualFile[] virtualFileArray = roots;
            int n = 0;
            int n2 = virtualFileArray.length;
            while (true) {
                if (n >= n2) {
                    Unit unit = Unit.INSTANCE;
                    return null;
                }
                VirtualFile root = virtualFileArray[n];
                WorkingCopy wcRoot = this.getWcRoot(root);
                if (wcRoot != null) {
                    if (SvnUtil.isAncestor(wcRoot.getUrl(), url)) return wcRoot;
                    if (SvnUtil.isAncestor(url, wcRoot.getUrl())) {
                        return wcRoot;
                    }
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    @Nullable
    public final WorkingCopy getWcRoot(@NotNull VirtualFile root) {
        boolean bl;
        boolean bl2 = bl = !ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Object object = this.myLock;
        synchronized (object) {
            block7: {
                WorkingCopy existing;
                block6: {
                    boolean bl3 = false;
                    if (!this.myUnversioned.contains(root)) break block6;
                    WorkingCopy workingCopy = null;
                    return workingCopy;
                }
                WorkingCopy workingCopy = existing = this.myRootMapping.get(root);
                if (workingCopy == null) break block7;
                WorkingCopy workingCopy2 = workingCopy;
                return workingCopy2;
            }
            Unit unit = Unit.INSTANCE;
        }
        return this.calculateRoot(root);
    }

    private final WorkingCopy calculateRoot(VirtualFile root) {
        Info svnInfo;
        File workingCopyRoot = SvnUtil.getWorkingCopyRoot(VfsUtilCore.virtualToIoFile((VirtualFile)root));
        WorkingCopy workingCopy = null;
        if (workingCopyRoot != null && (svnInfo = this.getVcs().getInfo(workingCopyRoot)) != null && svnInfo.getUrl() != null) {
            workingCopy = new WorkingCopy(workingCopyRoot, svnInfo.getUrl());
        }
        return this.registerWorkingCopy(root, workingCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WorkingCopy registerWorkingCopy(VirtualFile root, WorkingCopy resolvedWorkingCopy) {
        Object object = this.myLock;
        synchronized (object) {
            Boolean bl;
            boolean bl2 = false;
            if (resolvedWorkingCopy == null) {
                this.myRootMapping.remove(root);
                bl = this.myUnversioned.add(root);
            } else {
                this.myUnversioned.remove(root);
                this.myRootMapping.put(root, resolvedWorkingCopy);
                bl = Unit.INSTANCE;
            }
            Boolean bl3 = bl;
        }
        return resolvedWorkingCopy;
    }

    public void dispose() {
        this.clearData();
    }

    public final void clear() {
        this.clearData();
        this.myZipperUpdater.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearData() {
        Object object = this.myLock;
        synchronized (object) {
            boolean bl = false;
            this.myRootMapping.clear();
            this.myUnversioned.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public void directoryMappingChanged() {
        SvnAuthenticationNotifier.Companion.getInstance(this.project).clear();
        this.myZipperUpdater.queue(this.myRechecker);
    }

    private static final void myRechecker$lambda$0(RootsToWorkingCopies this$0) {
        VirtualFile[] roots;
        this$0.clear();
        for (VirtualFile root : roots = ProjectLevelVcsManager.getInstance((Project)this$0.project).getRootsUnderVcs((AbstractVcs)this$0.getVcs())) {
            this$0.addRoot(root);
        }
    }

    @JvmStatic
    @NotNull
    public static final RootsToWorkingCopies getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ WorkingCopy access$calculateRoot(RootsToWorkingCopies $this, VirtualFile root) {
        return $this.calculateRoot(root);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/svn/RootsToWorkingCopies$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/idea/svn/RootsToWorkingCopies;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.svn"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RootsToWorkingCopies getInstance(@NotNull Project project) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RootsToWorkingCopies> serviceClass$iv = RootsToWorkingCopies.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (RootsToWorkingCopies)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

