/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.RootUrlPair;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Url;

public class RootUrlInfo
implements RootUrlPair {
    @NotNull
    private final WorkingCopyFormat myFormat;
    @NotNull
    private final Node myNode;
    @NotNull
    private final VirtualFile myRoot;
    @Nullable
    private volatile NestedCopyType myType;

    public RootUrlInfo(@NotNull Node node, @NotNull WorkingCopyFormat format, @NotNull VirtualFile root) {
        this(node, format, root, null);
    }

    public RootUrlInfo(@NotNull Node node, @NotNull WorkingCopyFormat format, @NotNull VirtualFile root, @Nullable NestedCopyType type) {
        this.myNode = node;
        this.myFormat = format;
        this.myRoot = root;
        this.myType = type;
    }

    @NotNull
    public Node getNode() {
        return this.myNode;
    }

    @NotNull
    public Url getRepositoryUrl() {
        return this.myNode.getRepositoryRootUrl();
    }

    @NotNull
    public WorkingCopyFormat getFormat() {
        return this.myFormat;
    }

    @NotNull
    public File getIoFile() {
        return this.myNode.getIoFile();
    }

    @NlsSafe
    @NotNull
    public String getPath() {
        return this.getIoFile().getAbsolutePath();
    }

    @NotNull
    public VirtualFile getRoot() {
        return this.myRoot;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myNode.getFile();
    }

    @Override
    @NotNull
    public Url getUrl() {
        return this.myNode.getUrl();
    }

    @Nullable
    public NestedCopyType getType() {
        return this.myType;
    }

    public void setType(@Nullable NestedCopyType type) {
        this.myType = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RootUrlInfo info2 = (RootUrlInfo)o;
        if (this.myFormat != info2.myFormat) {
            return false;
        }
        if (!this.myNode.equals(info2.myNode)) {
            return false;
        }
        if (!this.myRoot.equals(info2.myRoot)) {
            return false;
        }
        return this.myType == info2.myType;
    }

    public int hashCode() {
        int result = this.myFormat.hashCode();
        result = 31 * result + this.myNode.hashCode();
        result = 31 * result + this.myRoot.hashCode();
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        return result;
    }
}

