/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util.threading;

import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reflection.ReflectionUtilKt;
import com.jetbrains.rd.util.threading.SingleThreadSchedulerBase;
import com.jetbrains.rd.util.threading.SpinWait;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H&J\u0016\u0010\"\u001a\u00020\u001e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0$H\u0016J\b\u0010%\u001a\u00020\u0003H\u0016R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lcom/jetbrains/rd/util/threading/SingleThreadSchedulerBase;", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "name", "", "(Ljava/lang/String;)V", "<set-?>", "", "active", "getActive", "()I", "setActive", "(I)V", "active$delegate", "Lkotlin/properties/ReadWriteProperty;", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "getExecutor", "()Ljava/util/concurrent/ThreadPoolExecutor;", "isActive", "", "()Z", "getName", "()Ljava/lang/String;", "tasksInQueue", "Ljava/util/concurrent/atomic/AtomicInteger;", "getTasksInQueue", "()Ljava/util/concurrent/atomic/AtomicInteger;", "createThreadFactory", "Ljava/util/concurrent/ThreadFactory;", "flush", "", "onException", "ex", "", "queue", "action", "Lkotlin/Function0;", "toString", "rd-core"})
public abstract class SingleThreadSchedulerBase
implements IScheduler {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String name;
    @NotNull
    private final ThreadPoolExecutor executor;
    @NotNull
    private final AtomicInteger tasksInQueue;
    @NotNull
    private final ReadWriteProperty active$delegate;

    public SingleThreadSchedulerBase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        ThreadFactory threadFactory = this.createThreadFactory();
        this.executor = new ThreadPoolExecutor(this, timeUnit, linkedBlockingQueue, threadFactory){
            final /* synthetic */ SingleThreadSchedulerBase this$0;
            {
                this.this$0 = $receiver;
                super(1, 1, 0L, $super_call_param$1, (BlockingQueue<Runnable>)$super_call_param$2, $super_call_param$3);
            }

            protected void afterExecute(@Nullable Runnable r, @Nullable Throwable t) {
                super.afterExecute(r, t);
                if (t == null) {
                    return;
                }
                this.this$0.onException(t);
            }
        };
        this.tasksInQueue = new AtomicInteger(0);
        this.active$delegate = ReflectionUtilKt.threadLocal(active.2.INSTANCE);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public abstract void onException(@NotNull Throwable var1);

    private final ThreadFactory createThreadFactory() {
        return arg_0 -> SingleThreadSchedulerBase.createThreadFactory$lambda-2(this, arg_0);
    }

    @NotNull
    public final ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    @NotNull
    public final AtomicInteger getTasksInQueue() {
        return this.tasksInQueue;
    }

    @Override
    public void queue(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.tasksInQueue.incrementAndGet();
        this.executor.execute(() -> SingleThreadSchedulerBase.queue$lambda-3(this, action));
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    private final int getActive() {
        return ((Number)this.active$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    private final void setActive(int n) {
        this.active$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    @Override
    public boolean isActive() {
        return this.getActive() > 0;
    }

    @Override
    public void flush() {
        if (!(!this.isActive())) {
            boolean $i$a$-require-SingleThreadSchedulerBase$flush$22 = false;
            String $i$a$-require-SingleThreadSchedulerBase$flush$22 = "Can't flush this scheduler in a reentrant way: we are inside queued item's execution";
            throw new IllegalArgumentException($i$a$-require-SingleThreadSchedulerBase$flush$22.toString());
        }
        SpinWait.Companion this_$iv = SpinWait.Companion;
        boolean $i$f$spinUntil = false;
        long spins$iv = 0L;
        while (true) {
            boolean bl = false;
            if (this.tasksInQueue.get() == 0) break;
            long l = spins$iv;
            spins$iv = l + 1L;
            if (l < 100L) {
                Thread.yield();
                continue;
            }
            Thread.sleep(spins$iv / (long)100);
        }
    }

    @Override
    public void assertThread(@Nullable Object debugInfo) {
        IScheduler.DefaultImpls.assertThread(this, debugInfo);
    }

    @Override
    public boolean getOutOfOrderExecution() {
        return IScheduler.DefaultImpls.getOutOfOrderExecution(this);
    }

    @Override
    public void invokeOrQueue(@NotNull Function0<Unit> action) {
        IScheduler.DefaultImpls.invokeOrQueue(this, action);
    }

    private static final Thread createThreadFactory$lambda-2(SingleThreadSchedulerBase this$0, Runnable r) {
        Thread thread2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Thread $this$createThreadFactory_u24lambda_u2d2_u24lambda_u2d0 = thread2 = new Thread(r, this$0.name);
        boolean bl = false;
        $this$createThreadFactory_u24lambda_u2d2_u24lambda_u2d0.setDaemon(true);
        Thread $this$createThreadFactory_u24lambda_u2d2_u24lambda_u2d1 = thread2;
        boolean bl2 = false;
        $this$createThreadFactory_u24lambda_u2d2_u24lambda_u2d1.setPriority(5);
        return thread2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void queue$lambda-3(SingleThreadSchedulerBase this$0, Function0 $action) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        int n = this$0.getActive();
        this$0.setActive(n + 1);
        try {
            $action.invoke();
        }
        finally {
            n = this$0.getActive();
            this$0.setActive(n + -1);
            this$0.tasksInQueue.decrementAndGet();
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SingleThreadSchedulerBase.class, "active", "getActive()I", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

