/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util.threading;

import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.time.DurationKt;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 M2\u00020\u0001:\u0003LMNB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u000e\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\fJ\b\u00103\u001a\u00020\tH\u0002J\u0006\u00104\u001a\u00020\tJ\b\u00105\u001a\u00020\tH\u0002J\u000e\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020\u0003J\"\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020:2\b\b\u0002\u0010;\u001a\u00020\u00052\b\b\u0002\u0010<\u001a\u00020\u0005J\u0006\u0010=\u001a\u00020\tJ\b\u0010>\u001a\u00020\tH\u0002J\u000e\u0010?\u001a\u00020\t2\u0006\u00107\u001a\u00020\u0003J\u0010\u0010@\u001a\u00020\t2\u0006\u0010A\u001a\u00020\bH\u0002J\u0006\u0010B\u001a\u00020\tJ\u0010\u0010C\u001a\u00020\u00102\b\b\u0002\u0010D\u001a\u00020EJ\u0010\u0010F\u001a\u00020\u00102\b\b\u0002\u0010D\u001a\u00020EJ \u0010G\u001a\u00020\u00102\u0006\u0010D\u001a\u00020E2\u0006\u0010H\u001a\u00020-2\u0006\u0010I\u001a\u00020\u0003H\u0002J\b\u0010J\u001a\u00020\tH\u0002J\b\u0010K\u001a\u00020\tH\u0002R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u00030$j\b\u0012\u0004\u0012\u00020\u0003`%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0018\"\u0004\b+\u0010,R\u001e\u0010.\u001a\u00020-2\u0006\u0010\u000b\u001a\u00020-@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u0006O"}, d2={"Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor;", "", "id", "", "chunkSize", "", "processor", "Lkotlin/Function1;", "Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor$Chunk;", "", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)V", "<set-?>", "", "acknowledgedSeqn", "getAcknowledgedSeqn", "()J", "", "allDataProcessed", "getAllDataProcessed", "()Z", "asyncProcessingThread", "Ljava/lang/Thread;", "chunkCount", "getChunkCount", "()I", "getChunkSize", "chunkToFill", "chunkToProcess", "getId", "()Ljava/lang/String;", "lastShrinkOrGrowTimeMs", "lock", "Ljava/lang/Object;", "log", "Lcom/jetbrains/rd/util/Logger;", "pauseReasons", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "processing", "getProcessor", "()Lkotlin/jvm/functions/Function1;", "shrinkIntervalMs", "getShrinkIntervalMs", "setShrinkIntervalMs", "(I)V", "Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor$StateKind;", "state", "getState", "()Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor$StateKind;", "acknowledge", "seqn", "cleanup0", "clear", "growConditionally", "pause", "reason", "put", "newData", "", "offset", "count", "reprocessUnacknowledged", "reset", "resume", "shrinkConditionally", "upTo", "start", "stop", "timeout", "Ljava/time/Duration;", "terminate", "terminate0", "stateToSet", "action", "threadProc", "waitProcessingFinished", "Chunk", "Companion", "StateKind", "rd-core"})
public final class ByteBufferAsyncProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final int chunkSize;
    @NotNull
    private final Function1<Chunk, Unit> processor;
    @NotNull
    private final Logger log;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread asyncProcessingThread;
    private Chunk chunkToFill;
    private Chunk chunkToProcess;
    @NotNull
    private final HashSet<String> pauseReasons;
    private boolean processing;
    private boolean allDataProcessed;
    private volatile long acknowledgedSeqn;
    private long lastShrinkOrGrowTimeMs;
    private int shrinkIntervalMs;
    @NotNull
    private StateKind state;
    private static final int DefaultChunkSize = 16370;
    private static final int DefaultShrinkIntervalMs = 30000;

    public ByteBufferAsyncProcessor(@NotNull String id, int chunkSize, @NotNull Function1<? super Chunk, Unit> processor) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        this.id = id;
        this.chunkSize = chunkSize;
        this.processor = processor;
        this.log = LoggerKt.getLogger(Reflection.getOrCreateKotlinClass(this.getClass()));
        this.lock = new Object();
        this.pauseReasons = new HashSet();
        this.allDataProcessed = true;
        this.lastShrinkOrGrowTimeMs = System.currentTimeMillis();
        this.shrinkIntervalMs = 30000;
        this.state = StateKind.Initialized;
        this.reset();
    }

    public /* synthetic */ ByteBufferAsyncProcessor(String string, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 16370;
        }
        this(string, n, (Function1<? super Chunk, Unit>)function1);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final int getChunkSize() {
        return this.chunkSize;
    }

    @NotNull
    public final Function1<Chunk, Unit> getProcessor() {
        return this.processor;
    }

    public final boolean getAllDataProcessed() {
        return this.allDataProcessed;
    }

    public final long getAcknowledgedSeqn() {
        return this.acknowledgedSeqn;
    }

    public final int getShrinkIntervalMs() {
        return this.shrinkIntervalMs;
    }

    public final void setShrinkIntervalMs(int n) {
        this.shrinkIntervalMs = n;
    }

    @NotNull
    public final StateKind getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getChunkCount() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Chunk chunk = this.chunkToFill;
            if (chunk == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
                chunk = null;
            }
            Chunk chunk2 = chunk.getNext();
            int res = 1;
            while (true) {
                Chunk chunk3;
                if ((chunk3 = this.chunkToFill) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
                    chunk3 = null;
                }
                if (Intrinsics.areEqual((Object)chunk2, (Object)chunk3)) break;
                ++res;
                chunk2 = chunk2.getNext();
            }
            int n = res;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanup0() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.state = StateKind.Terminated;
            this.chunkToFill = Chunk.Companion.getEmpty();
            this.chunkToProcess = Chunk.Companion.getEmpty();
            this.allDataProcessed = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean terminate0(Duration timeout, StateKind stateToSet, String action) {
        boolean threadStopped;
        Object object = this.lock;
        synchronized (object) {
            block12: {
                block11: {
                    void $this$log$iv$iv;
                    boolean bl = false;
                    if (this.state != StateKind.Initialized) break block11;
                    Logger $this$debug$iv = this.log;
                    boolean $i$f$debug = false;
                    Logger logger = $this$debug$iv;
                    LogLevel level$iv$iv = LogLevel.Debug;
                    boolean $i$f$log = false;
                    if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                        LogLevel logLevel = level$iv$iv;
                        void var13_27 = $this$log$iv$iv;
                        boolean bl2 = false;
                        String string = "Can't " + action + " '" + this.id + "', because it hasn't been started yet";
                        var13_27.log(logLevel, string, null);
                    }
                    this.cleanup0();
                    boolean bl3 = true;
                    return bl3;
                }
                if (this.state.compareTo((Enum)stateToSet) < 0) break block12;
                Logger $this$debug$iv = this.log;
                boolean $i$f$debug = false;
                Logger $this$log$iv$iv = $this$debug$iv;
                LogLevel level$iv$iv = LogLevel.Debug;
                boolean $i$f$log = false;
                if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    Logger logger = $this$log$iv$iv;
                    boolean bl = false;
                    String string = "Trying to " + action + " async processor '" + this.id + "' but it's in state '" + (Object)((Object)this.state) + '\'';
                    logger.log(logLevel, string, null);
                }
                boolean bl = true;
                return bl;
            }
            this.state = stateToSet;
            this.lock.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
        Thread thread2 = this.asyncProcessingThread;
        if (thread2 == null) {
            return true;
        }
        Thread t = thread2;
        t.join(timeout.toMillis());
        boolean bl = threadStopped = !t.isAlive();
        if (!threadStopped) {
            boolean $i$f$catch = false;
            Object comment$iv$iv = null;
            boolean $i$f$catch2 = false;
            try {
                boolean bl4 = false;
                t.stop();
            }
            catch (Throwable e$iv$iv) {
                String sfx$iv$iv = "";
                LoggerKt.getLogger("Default-Error-Logger").log(LogLevel.Error, "Catch" + sfx$iv$iv, e$iv$iv);
            }
        }
        this.cleanup0();
        return threadStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void acknowledge(long seqn) {
        Object object = this.lock;
        synchronized (object) {
            void $this$log$iv$iv;
            boolean bl = false;
            Logger $this$trace$iv = this.log;
            boolean $i$f$trace = false;
            Logger logger = $this$trace$iv;
            LogLevel level$iv$iv = LogLevel.Trace;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var11_12 = $this$log$iv$iv;
                boolean bl2 = false;
                String string = "New acknowledged seqn received: " + seqn;
                var11_12.log(logLevel, string, null);
            }
            if (seqn > this.acknowledgedSeqn) {
                this.acknowledgedSeqn = seqn;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reprocessUnacknowledged() {
        if (!(!Intrinsics.areEqual((Object)Thread.currentThread(), (Object)this.asyncProcessingThread))) {
            boolean bl = false;
            String string = "Thread.currentThread() != asyncProcessingThread";
            throw new IllegalArgumentException(string.toString());
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            while (this.processing) {
                this.lock.wait(1L);
            }
            Chunk chunk = this.chunkToFill;
            if (chunk == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
                chunk = null;
            }
            Chunk chunk2 = chunk.getNext();
            while (true) {
                Chunk chunk3;
                if ((chunk3 = this.chunkToFill) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
                    chunk3 = null;
                }
                if (Intrinsics.areEqual((Object)chunk2, (Object)chunk3)) break;
                if (!chunk2.checkEmpty(this)) {
                    this.chunkToProcess = chunk2;
                    this.allDataProcessed = false;
                    this.lock.notifyAll();
                    return;
                }
                chunk2 = chunk2.getNext();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void threadProc() {
        while (true) {
            var2_3 = this.lock;
            synchronized (var2_3) {
                $i$a$-synchronized-ByteBufferAsyncProcessor$threadProc$1 = false;
                if (this.state.compareTo((Enum)StateKind.Terminated) >= 0) {
                    return;
                }
                while (this.allDataProcessed || ((Collection)this.pauseReasons).isEmpty() == false) {
                    if (this.state.compareTo((Enum)StateKind.Stopping) >= 0) {
                        return;
                    }
                    this.lock.wait();
                    if (this.state.compareTo((Enum)StateKind.Terminating) < 0) continue;
                    return;
                }
                while (true) {
                    if ((v0 = this.chunkToProcess) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToProcess");
                        v0 = null;
                    }
                    if (!v0.checkEmpty(this)) break;
                    v1 = this.chunkToProcess;
                    if (v1 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToProcess");
                        v1 = null;
                    }
                    this.chunkToProcess = v1.getNext();
                }
                v2 = this.chunkToFill;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
                    v2 = null;
                }
                if ((v3 = this.chunkToProcess) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToProcess");
                    v3 = null;
                }
                if (Intrinsics.areEqual((Object)v2, (Object)v3)) {
                    this.growConditionally();
                    v4 = this.chunkToProcess;
                    if (v4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToProcess");
                        v4 = null;
                    }
                    this.chunkToFill = v4.getNext();
                }
                if ((v5 = this.chunkToProcess) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToProcess");
                    v5 = null;
                }
                this.shrinkConditionally(v5);
                v6 = this.chunkToProcess;
                if (v6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToProcess");
                    v6 = null;
                }
                value$iv = v6.getPtr() > 0;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !value$iv) {
                    $i$a$-assert-ByteBufferAsyncProcessor$threadProc$1$1 = false;
                    $i$a$-assert-ByteBufferAsyncProcessor$threadProc$1$1 = "chunkToProcess.ptr > 0";
                    throw new AssertionError((Object)$i$a$-assert-ByteBufferAsyncProcessor$threadProc$1$1);
                }
                v7 = this.chunkToFill;
                if (v7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
                    v7 = null;
                }
                if ((v8 = this.chunkToProcess) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToProcess");
                    v8 = null;
                }
                if (Intrinsics.areEqual((Object)v7, (Object)v8)) ** GOTO lbl-1000
                v9 = this.chunkToFill;
                if (v9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
                    v9 = null;
                }
                if (v9.isNotProcessed()) {
                    v10 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v10 = false;
                }
                value$iv = v10;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !value$iv) {
                    $i$a$-assert-ByteBufferAsyncProcessor$threadProc$1$2 = false;
                    var6_19 = "chunkToFill != chunkToProcess && chunkToFill.isNotProcessed";
                    throw new AssertionError((Object)var6_19);
                }
                this.processing = true;
                $i$a$-synchronized-ByteBufferAsyncProcessor$threadProc$1 = Unit.INSTANCE;
            }
            try {
                v11 = this.chunkToProcess;
                if (v11 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToProcess");
                    v11 = null;
                }
                this.processor.invoke((Object)v11);
                var2_3 = this.lock;
            }
            catch (Exception e) {
                try {
                    LoggerKt.error(this.log, "Exception while processing byte queue", e);
                    var2_3 = this.lock;
                }
                catch (Throwable var1_2) {
                    var3_6 = this.lock;
                    synchronized (var3_6) {
                        $i$a$-synchronized-ByteBufferAsyncProcessor$threadProc$2 = false;
                        this.processing = false;
                        v14 = this.chunkToProcess;
                        if (v14 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToProcess");
                            v14 = null;
                        }
                        if ((v15 = (this.chunkToProcess = v14.getNext())) == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToProcess");
                            v15 = null;
                        }
                        if (v15.getPtr() == 0) {
                            this.allDataProcessed = true;
                        }
                        var4_13 = Unit.INSTANCE;
                    }
                    throw var1_2;
                }
                synchronized (var2_3) {
                    $i$a$-synchronized-ByteBufferAsyncProcessor$threadProc$2 = false;
                    this.processing = false;
                    v16 = this.chunkToProcess;
                    if (v16 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToProcess");
                        v16 = null;
                    }
                    if ((v17 = (this.chunkToProcess = v16.getNext())) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToProcess");
                        v17 = null;
                    }
                    if (v17.getPtr() == 0) {
                        this.allDataProcessed = true;
                    }
                    var3_4 = Unit.INSTANCE;
                }
                continue;
            }
            synchronized (var2_3) {
                $i$a$-synchronized-ByteBufferAsyncProcessor$threadProc$2 = false;
                this.processing = false;
                v12 = this.chunkToProcess;
                if (v12 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToProcess");
                    v12 = null;
                }
                if ((v13 = (this.chunkToProcess = v12.getNext())) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToProcess");
                    v13 = null;
                }
                if (v13.getPtr() == 0) {
                    this.allDataProcessed = true;
                }
                $i$a$-synchronized-ByteBufferAsyncProcessor$threadProc$2 = Unit.INSTANCE;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void start() {
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            void $this$start_u24lambda_u2d17_u24lambda_u2d16;
            Thread thread2;
            boolean bl = false;
            if (this.state != StateKind.Initialized) {
                void $this$log$iv$iv;
                Logger $this$debug$iv = this.log;
                boolean $i$f$debug = false;
                Logger logger = $this$debug$iv;
                LogLevel level$iv$iv = LogLevel.Debug;
                boolean $i$f$log = false;
                if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    void var9_14 = $this$log$iv$iv;
                    boolean bl2 = false;
                    String string = "Trying to START async processor '" + this.id + "' but it's in state '" + (Object)((Object)this.state) + '\'';
                    var9_14.log(logLevel, string, null);
                }
                return;
            }
            this.state = StateKind.AsyncProcessing;
            Thread $i$f$debug = thread2 = new Thread(() -> ByteBufferAsyncProcessor.start$lambda-17$lambda-15(this), this.id);
            ByteBufferAsyncProcessor byteBufferAsyncProcessor = this;
            boolean bl3 = false;
            $this$start_u24lambda_u2d17_u24lambda_u2d16.setDaemon(true);
            byteBufferAsyncProcessor.asyncProcessingThread = thread2;
            Thread thread3 = this.asyncProcessingThread;
            if (thread3 != null) {
                thread3.start();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    private final void reset() {
        Chunk chunk;
        this.chunkToFill = new Chunk(this.chunkSize);
        Chunk chunk2 = this.chunkToFill;
        if (chunk2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
            chunk2 = null;
        }
        if ((chunk = this.chunkToFill) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
            chunk = null;
        }
        chunk2.setNext(chunk);
        this.lastShrinkOrGrowTimeMs = System.currentTimeMillis();
        Chunk chunk3 = this.chunkToFill;
        if (chunk3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
            chunk3 = null;
        }
        this.chunkToProcess = chunk3;
    }

    private final void waitProcessingFinished() {
        if (Intrinsics.areEqual((Object)Thread.currentThread(), (Object)this.asyncProcessingThread)) {
            return;
        }
        while (this.processing) {
            this.lock.wait(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void clear() {
        if (!(!Intrinsics.areEqual((Object)Thread.currentThread(), (Object)this.asyncProcessingThread))) {
            boolean bl = false;
            String string = "Thread.currentThread() != asyncProcessingThread";
            throw new IllegalArgumentException(string.toString());
        }
        Object object = this.lock;
        synchronized (object) {
            void $this$log$iv$iv;
            boolean bl = false;
            Logger $this$debug$iv = this.log;
            boolean $i$f$debug = false;
            Logger logger = $this$debug$iv;
            LogLevel level$iv$iv = LogLevel.Debug;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var9_13 = $this$log$iv$iv;
                boolean bl2 = false;
                String string = "Cleaning '" + this.id + "', state=" + (Object)((Object)this.state);
                var9_13.log(logLevel, string, null);
            }
            if (this.state.compareTo((Enum)StateKind.Stopping) >= 0) {
                return;
            }
            this.waitProcessingFinished();
            this.reset();
            this.allDataProcessed = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void pause(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Object object = this.lock;
        synchronized (object) {
            void $this$log$iv$iv;
            boolean bl = false;
            if (this.state.compareTo((Enum)StateKind.Stopping) >= 0) {
                return;
            }
            boolean alreadyHadReason = !this.pauseReasons.add(reason);
            Logger $this$debug$iv = this.log;
            boolean $i$f$debug = false;
            Logger logger = $this$debug$iv;
            LogLevel level$iv$iv = LogLevel.Debug;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                String string;
                LogLevel logLevel = level$iv$iv;
                void var11_13 = $this$log$iv$iv;
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder().append("PAUSE ('").append(reason).append("') ");
                boolean $this$condstr$iv = alreadyHadReason;
                boolean $i$f$condstr = false;
                if ($this$condstr$iv) {
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl3 = false;
                    string = "<already has this pause reason> ";
                    stringBuilder = stringBuilder2;
                } else {
                    string = "";
                }
                String string2 = stringBuilder.append(string).append(":: {id = ").append(this.id).append(", state = '").append((Object)this.state).append("'}").toString();
                var11_13.log(logLevel, string2, null);
            }
            this.waitProcessingFinished();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void resume(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Object object = this.lock;
        synchronized (object) {
            void $this$log$iv$iv;
            boolean bl = false;
            this.pauseReasons.remove(reason);
            boolean unpaused = this.pauseReasons.size() == 0;
            Logger $this$debug$iv = this.log;
            boolean $i$f$debug = false;
            Logger logger = $this$debug$iv;
            LogLevel level$iv$iv = LogLevel.Debug;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var11_13 = $this$log$iv$iv;
                boolean bl2 = false;
                String string = (unpaused ? "RESUME" : "Remove pause reason('" + reason + "')") + " :: {id = " + this.id + ", state = '" + (Object)((Object)this.state) + "'}";
                var11_13.log(logLevel, string, null);
            }
            this.lock.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean stop(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        return this.terminate0(timeout, StateKind.Stopping, "STOP");
    }

    public static /* synthetic */ boolean stop$default(ByteBufferAsyncProcessor byteBufferAsyncProcessor, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            duration = DurationKt.getInfiniteDuration();
        }
        return byteBufferAsyncProcessor.stop(duration);
    }

    public final boolean terminate(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        return this.terminate0(timeout, StateKind.Terminating, "TERMINATE");
    }

    public static /* synthetic */ boolean terminate$default(ByteBufferAsyncProcessor byteBufferAsyncProcessor, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            duration = DurationKt.getInfiniteDuration();
        }
        return byteBufferAsyncProcessor.terminate(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(@NotNull byte[] newData, int offset, int count) {
        Intrinsics.checkNotNullParameter((Object)newData, (String)"newData");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.state.compareTo((Enum)StateKind.Stopping) >= 0) {
                return;
            }
            int ptr = 0;
            while (ptr < count) {
                int available;
                Chunk chunk = this.chunkToFill;
                if (chunk == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
                    chunk = null;
                }
                boolean value$iv = chunk.isNotProcessed();
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !value$iv) {
                    boolean $i$a$-assert-ByteBufferAsyncProcessor$put$1$22 = false;
                    String $i$a$-assert-ByteBufferAsyncProcessor$put$1$22 = "chunkToFill.isNotProcessed";
                    throw new AssertionError((Object)$i$a$-assert-ByteBufferAsyncProcessor$put$1$22);
                }
                int rest = count - ptr;
                Chunk chunk2 = this.chunkToFill;
                if (chunk2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
                    chunk2 = null;
                }
                if ((available = this.chunkSize - chunk2.getPtr()) > 0) {
                    int copylen = Math.min(rest, available);
                    Chunk chunk3 = this.chunkToFill;
                    if (chunk3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
                        chunk3 = null;
                    }
                    byte[] byArray = chunk3.getData();
                    Chunk chunk4 = this.chunkToFill;
                    if (chunk4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
                        chunk4 = null;
                    }
                    System.arraycopy(newData, ptr + offset, byArray, chunk4.getPtr(), copylen);
                    Chunk chunk5 = this.chunkToFill;
                    if (chunk5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
                        chunk5 = null;
                    }
                    Chunk chunk6 = chunk5;
                    chunk6.setPtr(chunk6.getPtr() + copylen);
                    ptr += copylen;
                    continue;
                }
                this.growConditionally();
                Chunk chunk7 = this.chunkToFill;
                if (chunk7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
                    chunk7 = null;
                }
                this.chunkToFill = chunk7.getNext();
            }
            if (this.allDataProcessed) {
                this.allDataProcessed = false;
                this.lock.notify();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void put$default(ByteBufferAsyncProcessor byteBufferAsyncProcessor, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        byteBufferAsyncProcessor.put(byArray, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private final void growConditionally() {
        void $this$growConditionally_u24lambda_u2d29;
        Chunk chunk;
        Chunk chunk2;
        Chunk chunk3;
        void $this$log$iv$iv;
        Chunk chunk4 = this.chunkToFill;
        if (chunk4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
            chunk4 = null;
        }
        if (chunk4.getNext().checkEmpty(this)) {
            return;
        }
        Logger $this$trace$iv = this.log;
        boolean $i$f$trace22 = false;
        Logger logger = $this$trace$iv;
        LogLevel level$iv$iv = LogLevel.Trace;
        boolean $i$f$log = false;
        if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
            LogLevel logLevel = level$iv$iv;
            chunk3 = $this$log$iv$iv;
            boolean bl = false;
            String string = "Grow: " + this.chunkSize + " bytes";
            chunk3.log(logLevel, string, null);
        }
        if ((chunk2 = this.chunkToFill) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
            chunk2 = null;
        }
        Chunk $i$f$trace22 = chunk = new Chunk(this.chunkSize);
        chunk3 = chunk2;
        boolean bl = false;
        Chunk chunk5 = this.chunkToFill;
        if (chunk5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
            chunk5 = null;
        }
        $this$growConditionally_u24lambda_u2d29.setNext(chunk5.getNext());
        chunk3.setNext(chunk);
        this.lastShrinkOrGrowTimeMs = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    private final void shrinkConditionally(Chunk upTo) {
        Chunk chunk = this.chunkToFill;
        if (chunk == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
            chunk = null;
        }
        boolean value$iv = !Intrinsics.areEqual((Object)chunk, (Object)upTo);
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !value$iv) {
            boolean $i$a$-assert-ByteBufferAsyncProcessor$shrinkConditionally$22 = false;
            String $i$a$-assert-ByteBufferAsyncProcessor$shrinkConditionally$22 = "chunkToFill != upTo";
            throw new AssertionError((Object)$i$a$-assert-ByteBufferAsyncProcessor$shrinkConditionally$22);
        }
        long now = System.currentTimeMillis();
        if (now - this.lastShrinkOrGrowTimeMs <= (long)this.shrinkIntervalMs) {
            return;
        }
        this.lastShrinkOrGrowTimeMs = now;
        while (true) {
            Chunk chunk2;
            void $this$log$iv$iv;
            Chunk toRemove;
            Chunk chunk3;
            if ((chunk3 = this.chunkToFill) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
                chunk3 = null;
            }
            if (Intrinsics.areEqual((Object)(toRemove = chunk3.getNext()), (Object)upTo) || !toRemove.checkEmpty(this)) break;
            Logger $this$trace$iv = this.log;
            boolean $i$f$trace = false;
            Logger logger = $this$trace$iv;
            LogLevel level$iv$iv = LogLevel.Trace;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var11_14 = $this$log$iv$iv;
                boolean bl = false;
                String string = "Shrink: " + this.chunkSize + " bytes, seqN: " + toRemove;
                var11_14.log(logLevel, string, null);
            }
            if ((chunk2 = this.chunkToFill) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"chunkToFill");
                chunk2 = null;
            }
            chunk2.setNext(toRemove.getNext());
        }
    }

    private static final void start$lambda-17$lambda-15(ByteBufferAsyncProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.threadProc();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor$StateKind;", "", "(Ljava/lang/String;I)V", "Initialized", "AsyncProcessing", "Stopping", "Terminating", "Terminated", "rd-core"})
    public static final class StateKind
    extends Enum<StateKind> {
        public static final /* enum */ StateKind Initialized = new StateKind();
        public static final /* enum */ StateKind AsyncProcessing = new StateKind();
        public static final /* enum */ StateKind Stopping = new StateKind();
        public static final /* enum */ StateKind Terminating = new StateKind();
        public static final /* enum */ StateKind Terminated = new StateKind();
        private static final /* synthetic */ StateKind[] $VALUES;

        public static StateKind[] values() {
            return (StateKind[])$VALUES.clone();
        }

        public static StateKind valueOf(String value2) {
            return Enum.valueOf(StateKind.class, value2);
        }

        static {
            $VALUES = stateKindArray = new StateKind[]{StateKind.Initialized, StateKind.AsyncProcessing, StateKind.Stopping, StateKind.Terminating, StateKind.Terminated};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0000X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0004R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\""}, d2={"Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor$Chunk;", "", "chunkSize", "", "(I)V", "data", "", "getData", "()[B", "isNotProcessed", "", "()Z", "next", "getNext", "()Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor$Chunk;", "setNext", "(Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor$Chunk;)V", "ptr", "getPtr", "()I", "setPtr", "seqn", "", "getSeqn", "()J", "setSeqn", "(J)V", "Reset", "", "Reset$rd_core", "checkEmpty", "buffer", "Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor;", "Companion", "rd-core"})
    public static final class Chunk {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final byte[] data;
        private int ptr;
        public Chunk next;
        private long seqn;
        @NotNull
        private static final Chunk empty = new Chunk(0);

        public Chunk(int chunkSize) {
            this.data = new byte[chunkSize];
            this.seqn = Long.MAX_VALUE;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }

        public final int getPtr() {
            return this.ptr;
        }

        public final void setPtr(int n) {
            this.ptr = n;
        }

        @NotNull
        public final Chunk getNext() {
            Chunk chunk = this.next;
            if (chunk != null) {
                return chunk;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"next");
            return null;
        }

        public final void setNext(@NotNull Chunk chunk) {
            Intrinsics.checkNotNullParameter((Object)chunk, (String)"<set-?>");
            this.next = chunk;
        }

        public final long getSeqn() {
            return this.seqn;
        }

        public final void setSeqn(long l) {
            this.seqn = l;
        }

        public final boolean checkEmpty(@NotNull ByteBufferAsyncProcessor buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (this.ptr == 0) {
                boolean value$iv = this.seqn == Long.MAX_VALUE;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !value$iv) {
                    boolean bl = false;
                    String string = "seqn == long.MaxValue, but: " + this.seqn;
                    throw new AssertionError((Object)string);
                }
                return true;
            }
            if (buffer.getAcknowledgedSeqn() < this.seqn) {
                return false;
            }
            this.Reset$rd_core();
            return true;
        }

        public final boolean isNotProcessed() {
            return this.seqn == Long.MAX_VALUE;
        }

        public final void Reset$rd_core() {
            this.seqn = Long.MAX_VALUE;
            this.ptr = 0;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor$Chunk$Companion;", "", "()V", "empty", "Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor$Chunk;", "getEmpty", "()Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor$Chunk;", "rd-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Chunk getEmpty() {
                return empty;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor$Companion;", "", "()V", "DefaultChunkSize", "", "DefaultShrinkIntervalMs", "rd-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

