/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util;

import com.jetbrains.rd.util.ILoggerFactory;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerFactoryStatic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0007\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\b\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/util/SwitchLogger;", "Lcom/jetbrains/rd/util/Logger;", "category", "", "(Ljava/lang/String;)V", "cachedPair", "Lcom/jetbrains/rd/util/SwitchLogger$Pair;", "getRealLogger", "getRealLogger$rd_core", "isEnabled", "", "level", "Lcom/jetbrains/rd/util/LogLevel;", "log", "", "message", "", "throwable", "", "Pair", "rd-core"})
public final class SwitchLogger
implements Logger {
    @NotNull
    private final String category;
    @Nullable
    private volatile Pair cachedPair;

    public SwitchLogger(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        this.category = category;
    }

    @Override
    public void log(@NotNull LogLevel level, @Nullable Object message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.getRealLogger$rd_core().log(level, message, throwable);
    }

    @Override
    public boolean isEnabled(@NotNull LogLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return this.getRealLogger$rd_core().isEnabled(level);
    }

    @NotNull
    public final Logger getRealLogger$rd_core() {
        Pair pair = this.cachedPair;
        while (true) {
            ILoggerFactory currentFactory = LoggerFactoryStatic.INSTANCE.getCurrentFactory();
            Pair pair2 = pair;
            if ((pair2 != null ? pair2.getFactory() : null) == currentFactory) {
                return pair.getLogger();
            }
            this.cachedPair = pair = new Pair(currentFactory, currentFactory.getLogger(this.category));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rd/util/SwitchLogger$Pair;", "", "factory", "Lcom/jetbrains/rd/util/ILoggerFactory;", "logger", "Lcom/jetbrains/rd/util/Logger;", "(Lcom/jetbrains/rd/util/ILoggerFactory;Lcom/jetbrains/rd/util/Logger;)V", "getFactory", "()Lcom/jetbrains/rd/util/ILoggerFactory;", "getLogger", "()Lcom/jetbrains/rd/util/Logger;", "rd-core"})
    private static final class Pair {
        @NotNull
        private final ILoggerFactory factory;
        @NotNull
        private final Logger logger;

        public Pair(@NotNull ILoggerFactory factory, @NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.factory = factory;
            this.logger = logger;
        }

        @NotNull
        public final ILoggerFactory getFactory() {
            return this.factory;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }
    }
}

